/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.api.composer;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gatein.mop.api.composer.PageIteratorStrategy;
import org.gatein.mop.api.workspace.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PageIteratorStrategies implements PageIteratorStrategy
{
    SIMPLE{

        @Override
        public Iterator<Page> iterator(Page page) {
            return Collections.singletonList(page).iterator();
        }
    }
    ,
    PAGE_TEMPLATE{

        @Override
        public Iterator<Page> iterator(final Page page) {
            return new Iterator<Page>(){
                Page current;
                {
                    this.current = page;
                }

                @Override
                public boolean hasNext() {
                    return this.current != null;
                }

                @Override
                public Page next() {
                    if (this.current == null) {
                        throw new NoSuchElementException();
                    }
                    Page next = null;
                    for (Page p = this.current; p != null; p = p.getParent()) {
                        Page template = p.getTemplate();
                        if (template == null) continue;
                        next = template;
                        break;
                    }
                    Page tmp = this.current;
                    this.current = next;
                    return tmp;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
    ,
    PAGE_AND_SITE_TEMPLATE{

        @Override
        public Iterator<Page> iterator(Page page) {
            throw new UnsupportedOperationException();
        }
    };

}

