/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.chromattic;

import java.util.List;
import org.chromattic.api.Chromattic;
import org.chromattic.api.ChromatticBuilder;
import org.exoplatform.commons.chromattic.AbstractContext;
import org.exoplatform.commons.chromattic.ChromatticImpl;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.chromattic.GlobalContext;
import org.exoplatform.commons.chromattic.LifeCycleContext;
import org.exoplatform.commons.chromattic.LocalContext;
import org.exoplatform.commons.chromattic.LoginContext;
import org.exoplatform.commons.chromattic.PortalSessionLifeCycle;
import org.exoplatform.commons.chromattic.SessionContext;
import org.exoplatform.commons.chromattic.Synchronization;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class ChromatticLifeCycle
extends BaseComponentPlugin {
    private final String domainName;
    private final String workspaceName;
    Chromattic realChromattic;
    private ChromatticImpl chromattic;
    ChromatticManager manager;
    private final List<String> entityClassNames;
    final ThreadLocal<LocalContext> currentContext = new ThreadLocal();
    final Logger log = LoggerFactory.getLogger(ChromatticLifeCycle.class);

    public ChromatticLifeCycle(InitParams params) {
        this.domainName = params.getValueParam("domain-name").getValue();
        this.workspaceName = params.getValueParam("workspace-name").getValue();
        this.entityClassNames = params.getValuesParam("entities").getValues();
    }

    public String getDomainName() {
        return this.domainName;
    }

    public final String getWorkspaceName() {
        return this.workspaceName;
    }

    public final Chromattic getChromattic() {
        return this.chromattic;
    }

    public final ChromatticManager getManager() {
        return this.manager;
    }

    public final SessionContext getContext() {
        return this.getContext(false);
    }

    public final SessionContext getContext(boolean peek) {
        this.log.trace((Object)"Requesting context");
        Synchronization sync = this.manager.getSynchronization();
        if (sync != null) {
            this.log.trace((Object)("Found synchronization about to get the current context for chromattic " + this.domainName));
            GlobalContext context = sync.getContext(this.domainName);
            if (context == null && !peek) {
                this.log.trace((Object)"No current context found, about to open one");
                context = sync.openContext(this);
            } else {
                this.log.trace((Object)"Found a context and will return it");
            }
            return context;
        }
        this.log.trace((Object)"No active synchronization about to try the current local context");
        LocalContext localContext = this.currentContext.get();
        this.log.trace((Object)("Found local context " + localContext));
        return localContext;
    }

    LoginContext getLoginContext() {
        Synchronization sync = this.manager.getSynchronization();
        if (sync != null) {
            return sync;
        }
        return this.currentContext.get();
    }

    final SessionContext openGlobalContext() {
        this.log.trace((Object)"Opening a global context");
        AbstractContext context = (AbstractContext)this.getContext(true);
        if (context != null) {
            String msg = "A global context is already opened";
            this.log.trace((Object)msg);
            throw new IllegalStateException(msg);
        }
        this.log.trace((Object)"Ok, no global context found, asking current synchronization");
        Synchronization sync = this.manager.getSynchronization();
        if (sync == null) {
            String msg = "Need global synchronization for opening a global context";
            this.log.trace((Object)msg);
            throw new IllegalStateException(msg);
        }
        this.log.trace((Object)"Opening a global context for the related sync");
        return sync.openContext(this);
    }

    public final SessionContext openContext() {
        this.log.trace((Object)"Opening a context");
        AbstractContext context = (AbstractContext)this.getContext(true);
        if (context != null) {
            String msg = "A context is already opened";
            this.log.trace((Object)msg);
            throw new IllegalStateException(msg);
        }
        this.log.trace((Object)"Ok, no context found, asking current synchronization");
        Synchronization sync = this.manager.getSynchronization();
        if (sync != null) {
            this.log.trace((Object)"Found a synchronization, about to open a global context");
            context = sync.openContext(this);
        } else {
            this.log.trace((Object)"Not synchronization found, about to a local context");
            LocalContext localContext = new LocalContext(this);
            this.currentContext.set(localContext);
            this.onOpenSession(localContext);
            context = localContext;
        }
        return context;
    }

    public final void closeContext(boolean save) {
        this.log.trace((Object)("Requesting for context close with save=" + save + " going to look for any context"));
        AbstractContext context = (AbstractContext)this.getContext(true);
        if (context == null) {
            String msg = "Cannot close non existing context";
            this.log.trace((Object)msg);
            throw new IllegalStateException(msg);
        }
        context.close(save);
    }

    protected void onOpenSession(SessionContext context) {
    }

    protected void onCloseSession(SessionContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws Exception {
        this.log.debug((Object)("About to setup Chromattic life cycle " + this.domainName));
        ChromatticBuilder builder = ChromatticBuilder.create();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (String className : this.entityClassNames) {
            String fqn = className.trim();
            this.log.debug((Object)("Adding class " + fqn + " to life cycle " + this.domainName));
            Class<?> entityClass = cl.loadClass(fqn);
            builder.add(entityClass);
        }
        LifeCycleContext.bootContext.set(new LifeCycleContext(this, this.manager, this.workspaceName));
        try {
            builder.setOption(ChromatticBuilder.SESSION_LIFECYCLE_CLASSNAME, (Object)PortalSessionLifeCycle.class.getName());
            this.log.debug((Object)("Building Chromattic " + this.domainName));
            this.realChromattic = builder.build();
            this.chromattic = new ChromatticImpl(this);
        }
        catch (Exception e) {
            this.log.error((Object)("Could not start Chromattic " + this.domainName), (Throwable)e);
        }
        finally {
            LifeCycleContext.bootContext.set(null);
        }
    }

    public final void stop() {
    }
}

