/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application.replication.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.webui.application.replication.SerializationContext;
import org.exoplatform.webui.application.replication.factory.ObjectFactory;
import org.exoplatform.webui.application.replication.model.FieldModel;
import org.exoplatform.webui.application.replication.model.ReplicatableTypeModel;
import org.exoplatform.webui.application.replication.model.TypeModel;
import org.exoplatform.webui.application.replication.serial.DataContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectReader
extends ObjectInputStream {
    private final SerializationContext context;
    private final Map<Integer, Object> idToObject;
    private final Map<Integer, List<Resolution>> idToResolutions;

    public ObjectReader(SerializationContext context, InputStream in) throws IOException {
        super(in);
        this.enableResolveObject(true);
        this.context = context;
        this.idToObject = new HashMap<Integer, Object>();
        this.idToResolutions = new HashMap<Integer, List<Resolution>>();
    }

    private <O> O instantiate(ReplicatableTypeModel<O> typeModel, Map<FieldModel, ?> state) throws InvalidClassException {
        try {
            ObjectFactory<O> factory = this.context.getFactory(typeModel.getJavaType());
            return factory.create(typeModel.getJavaType(), state);
        }
        catch (Exception e) {
            InvalidClassException ice = new InvalidClassException("Cannot instantiate object from class " + typeModel.getJavaType().getName());
            ice.initCause(e);
            throw ice;
        }
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        if (obj instanceof DataContainer) {
            DataContainer container = (DataContainer)obj;
            int sw = container.readInt();
            switch (sw) {
                case 2: {
                    int id = container.readInt();
                    Object o1 = this.idToObject.get(id);
                    if (o1 == null) {
                        throw new AssertionError();
                    }
                    return o1;
                }
                case 0: {
                    int id = container.readInt();
                    Class clazz = (Class)container.readObject();
                    ReplicatableTypeModel typeModel = (ReplicatableTypeModel)this.context.getTypeDomain().getTypeModel(clazz);
                    HashMap<FieldModel, Object> state = new HashMap<FieldModel, Object>();
                    ArrayList<Bilto> biltos = new ArrayList<Bilto>();
                    for (TypeModel currentTypeModel = typeModel; currentTypeModel != null; currentTypeModel = currentTypeModel.getSuperType()) {
                        if (!(currentTypeModel instanceof ReplicatableTypeModel)) continue;
                        for (FieldModel fieldModel : currentTypeModel.getFields()) {
                            if (fieldModel.isTransient()) continue;
                            switch (container.readInt()) {
                                case 1: {
                                    state.put(fieldModel, null);
                                    break;
                                }
                                case 2: {
                                    int refId = container.readInt();
                                    Object refO = this.idToObject.get(refId);
                                    if (refO != null) {
                                        state.put(fieldModel, refO);
                                        break;
                                    }
                                    biltos.add(new Bilto(refId, fieldModel));
                                    break;
                                }
                                case 0: {
                                    Object o = container.readObject();
                                    state.put(fieldModel, o);
                                }
                            }
                        }
                    }
                    Object instance = this.instantiate(typeModel, state);
                    for (Bilto bilto : biltos) {
                        List<Resolution> resolutions = this.idToResolutions.get(bilto.ref);
                        if (resolutions == null) {
                            resolutions = new ArrayList<Resolution>();
                            this.idToResolutions.put(bilto.ref, resolutions);
                        }
                        resolutions.add(new Resolution(instance, bilto.fieldModel));
                    }
                    this.idToObject.put(id, instance);
                    List<Resolution> resolutions = this.idToResolutions.remove(id);
                    if (resolutions != null) {
                        for (Resolution resolution : resolutions) {
                            resolution.fieldModel.setValue(resolution.target, instance);
                        }
                    }
                    return instance;
                }
            }
            throw new StreamCorruptedException("Unrecognized data " + sw);
        }
        return obj;
    }

    private static class Resolution {
        private final Object target;
        private final FieldModel fieldModel;

        private Resolution(Object target, FieldModel fieldModel) {
            this.target = target;
            this.fieldModel = fieldModel;
        }
    }

    private static class Bilto {
        private final int ref;
        private final FieldModel fieldModel;

        private Bilto(int ref, FieldModel fieldModel) {
            this.ref = ref;
            this.fieldModel = fieldModel;
        }
    }
}

