/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.SessionManagerContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.ConfigurationManager;
import org.exoplatform.webui.application.StateManager;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIApplication;

public class PortalStateManager
extends StateManager {
    protected static Log log = ExoLogger.getLogger((String)"portal:PortalStateManager");
    private ConcurrentMap<String, HashMap<String, PortalApplicationState>> uiApplications = new ConcurrentHashMap<String, HashMap<String, PortalApplicationState>>();

    public UIApplication restoreUIRootComponent(WebuiRequestContext context) throws Exception {
        context.setStateManager((StateManager)this);
        WebuiApplication app = (WebuiApplication)context.getApplication();
        if (context instanceof PortletRequestContext) {
            WebuiRequestContext preqContext = (WebuiRequestContext)context.getParentAppRequestContext();
            PortletRequestContext pcontext = (PortletRequestContext)context;
            String key = pcontext.getApplication().getApplicationId() + "/" + pcontext.getWindowId();
            PortalApplicationState state = this.getApplicationState(preqContext);
            UIApplication uiApplication = (UIApplication)state.get(key);
            if (uiApplication != null) {
                return uiApplication;
            }
            ConfigurationManager cmanager = app.getConfigurationManager();
            String uirootClass = cmanager.getApplication().getUIRootComponent();
            Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(uirootClass);
            uiApplication = (UIApplication)app.createUIComponent(type, null, null, context);
            state.put(key, uiApplication);
            return uiApplication;
        }
        PortalRequestContext pcontext = (PortalRequestContext)context;
        PortalApplicationState state = this.getApplicationState(pcontext);
        if (state != null && !Safe.equals((Object)pcontext.getRemoteUser(), (Object)state.getUserName())) {
            this.clearSession(pcontext.getRequest().getSession());
            state = null;
        }
        if (state == null) {
            ConfigurationManager cmanager = app.getConfigurationManager();
            String uirootClass = cmanager.getApplication().getUIRootComponent();
            Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(uirootClass);
            UserPortalConfig config = this.getUserPortalConfig(pcontext);
            if (config == null) {
                HttpServletResponse response = pcontext.getResponse();
                response.sendRedirect(pcontext.getRequest().getContextPath() + "/portal-unavailable.jsp");
                pcontext.setResponseComplete(true);
                return null;
            }
            pcontext.setAttribute(UserPortalConfig.class, config);
            UIPortalApplication uiApplication = (UIPortalApplication)app.createUIComponent(type, null, null, context);
            state = new PortalApplicationState(uiApplication, pcontext.getRemoteUser());
            this.cacheApplicationState(pcontext.getSessionId(), pcontext.getPortalOwner(), state);
            SessionManagerContainer pcontainer = (SessionManagerContainer)app.getApplicationServiceContainer();
            pcontainer.createSessionContainer(context.getSessionId(), uiApplication.getOwner());
        }
        return state.getUIPortalApplication();
    }

    public void storeUIRootComponent(WebuiRequestContext context) {
    }

    public void expire(String sessionId, WebuiApplication app) {
        this.uiApplications.remove(sessionId);
        SessionManagerContainer pcontainer = (SessionManagerContainer)app.getApplicationServiceContainer();
        pcontainer.removeSessionContainer(sessionId);
    }

    private PortalApplicationState getApplicationState(WebuiRequestContext context) {
        PortalRequestContext portalContext = null;
        portalContext = context instanceof PortalRequestContext ? (PortalRequestContext)context : (PortalRequestContext)context.getParentAppRequestContext();
        String portalName = portalContext.getPortalOwner();
        String sessionId = portalContext.getSessionId();
        HashMap appStates = (HashMap)this.uiApplications.get(sessionId);
        return appStates == null ? null : (PortalApplicationState)appStates.get(portalName);
    }

    private void cacheApplicationState(String sessionId, String portalName, PortalApplicationState state) {
        HashMap<String, PortalApplicationState> appStates = (HashMap<String, PortalApplicationState>)this.uiApplications.get(sessionId);
        if (appStates == null) {
            appStates = new HashMap<String, PortalApplicationState>();
            this.uiApplications.put(sessionId, appStates);
        }
        appStates.put(portalName, state);
    }

    private UserPortalConfig getUserPortalConfig(PortalRequestContext context) throws Exception {
        ExoContainer appContainer = context.getApplication().getApplicationServiceContainer();
        UserPortalConfigService service_ = (UserPortalConfigService)appContainer.getComponentInstanceOfType(UserPortalConfigService.class);
        String remoteUser = context.getRemoteUser();
        String ownerUser = context.getPortalOwner();
        return service_.getUserPortalConfig(ownerUser, remoteUser);
    }

    private void clearSession(HttpSession session) {
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            session.removeAttribute(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PortalApplicationState
    extends HashMap<String, UIApplication> {
        private final UIPortalApplication uiPortalApplication_;
        private final String userName_;

        public PortalApplicationState(UIPortalApplication uiPortalApplication, String userName) {
            this.uiPortalApplication_ = uiPortalApplication;
            this.userName_ = userName;
        }

        public String getUserName() {
            return this.userName_;
        }

        public UIPortalApplication getUIPortalApplication() {
            return this.uiPortalApplication_;
        }
    }
}

