/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.portlet.PortletMode;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.pom.spi.wsrp.WSRP;
import org.exoplatform.portal.webui.application.ExoPortletInstanceContext;
import org.exoplatform.portal.webui.application.ExoPortletInvocationContext;
import org.exoplatform.portal.webui.application.ExoUserContext;
import org.exoplatform.portal.webui.application.ExoWindowContext;
import org.exoplatform.portal.webui.application.ModelAdapter;
import org.exoplatform.portal.webui.application.PortletState;
import org.exoplatform.portal.webui.application.UIApplication;
import org.exoplatform.portal.webui.application.UIPortletActionListener;
import org.exoplatform.portal.webui.application.UIPortletLifecycle;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalComponentActionListener;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.event.Event;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.net.media.MediaType;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.StatefulPortletContext;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.pc.api.info.MetaInfo;
import org.gatein.pc.api.info.ModeInfo;
import org.gatein.pc.api.info.ParameterInfo;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.ClientContext;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.spi.PortalContext;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.spi.RequestContext;
import org.gatein.pc.api.spi.SecurityContext;
import org.gatein.pc.api.spi.ServerContext;
import org.gatein.pc.api.spi.UserContext;
import org.gatein.pc.api.spi.WindowContext;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.portlet.impl.spi.AbstractClientContext;
import org.gatein.pc.portlet.impl.spi.AbstractPortalContext;
import org.gatein.pc.portlet.impl.spi.AbstractRequestContext;
import org.gatein.pc.portlet.impl.spi.AbstractSecurityContext;
import org.gatein.pc.portlet.impl.spi.AbstractServerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIPortletLifecycle.class, template="system:/groovy/portal/webui/application/UIPortlet.gtmpl", events={@EventConfig(listeners={UIPortletActionListener.RenderActionListener.class}), @EventConfig(listeners={UIPortletActionListener.ChangePortletModeActionListener.class}), @EventConfig(listeners={UIPortletActionListener.ChangeWindowStateActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.DeleteComponentActionListener.class}, confirm="UIPortlet.deletePortlet"), @EventConfig(listeners={UIPortletActionListener.EditPortletActionListener.class}), @EventConfig(phase=Event.Phase.PROCESS, listeners={UIPortletActionListener.ProcessActionActionListener.class}), @EventConfig(phase=Event.Phase.PROCESS, listeners={UIPortletActionListener.ServeResourceActionListener.class}), @EventConfig(phase=Event.Phase.PROCESS, listeners={UIPortletActionListener.ProcessEventsActionListener.class})})
public class UIPortlet<S, C extends Serializable>
extends UIApplication {
    protected static final Log log = ExoLogger.getLogger((String)"portal:UIPortlet");
    public static final String DEFAULT_THEME = "Default:DefaultTheme::Vista:VistaTheme::Mac:MacTheme";
    private String storageId;
    private String storageName;
    private ModelAdapter<S, C> adapter;
    private Portlet producedOfferedPortlet;
    private PortletContext producerOfferedPortletContext;
    private LocalizedString displayName;
    private PortletState<S> state;
    private String applicationId;
    private String theme_;
    private String portletStyle;
    private boolean showPortletMode = true;
    private PortletMode currentPortletMode_ = PortletMode.VIEW;
    private javax.portlet.WindowState currentWindowState_ = javax.portlet.WindowState.NORMAL;
    private List<String> supportModes_;
    private List<QName> supportedProcessingEvents_;
    private List<QName> supportedPublishingEvents_;
    private List<String> supportedPublicParams_;
    private boolean portletInPortal_ = true;
    private StateString navigationalState;
    private static final ThreadLocal<UIPortlet> currentPortlet = new ThreadLocal();

    public UIPortlet() {
        this.storageName = UUID.randomUUID().toString();
    }

    public String getStorageId() {
        return this.storageId;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    public String getStorageName() {
        return this.storageName;
    }

    public void setStorageName(String storageName) {
        this.storageName = storageName;
    }

    public String getWindowId() {
        return this.storageName;
    }

    public String getSkinId() {
        ApplicationType<S> type = this.state.getApplicationType();
        if (type == ApplicationType.PORTLET) {
            return this.applicationId;
        }
        if (type == ApplicationType.GADGET) {
            return "dashboard/GadgetPortlet";
        }
        return null;
    }

    public String getId() {
        return this.storageName;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getPortletStyle() {
        return this.portletStyle;
    }

    public void setPortletStyle(String s) {
        this.portletStyle = s;
    }

    public boolean getShowPortletMode() {
        return this.showPortletMode;
    }

    public void setShowPortletMode(Boolean b) {
        this.showPortletMode = b;
    }

    public void setPortletInPortal(boolean b) {
        this.portletInPortal_ = b;
    }

    public boolean isPortletInPortal() {
        return this.portletInPortal_;
    }

    public String getTheme() {
        if (this.theme_ == null || this.theme_.trim().length() < 1) {
            return DEFAULT_THEME;
        }
        return this.theme_;
    }

    public void setTheme(String theme) {
        this.theme_ = theme;
    }

    public String getSuitedTheme(String skin) {
        Map<String, String> themeMap;
        if (skin == null) {
            skin = ((UIPortalApplication)this.getAncestorOfType(UIPortalApplication.class)).getSkin();
        }
        if ((themeMap = this.stringToThemeMap(this.getTheme())).containsKey(skin)) {
            return themeMap.get(skin);
        }
        return DEFAULT_THEME.split(":")[1];
    }

    public void putSuitedTheme(String skin, String theme) {
        if (skin == null) {
            skin = ((UIPortalApplication)this.getAncestorOfType(UIPortalApplication.class)).getSkin();
        }
        Map<String, String> themeMap = this.stringToThemeMap(this.getTheme());
        themeMap.put(skin, theme);
        this.setTheme(this.themeMapToString(themeMap));
    }

    private String themeMapToString(Map<String, String> themeMap) {
        StringBuffer builder = new StringBuffer();
        Iterator<Map.Entry<String, String>> itr = themeMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, String> entry = itr.next();
            builder.append(entry.getKey()).append(":").append(entry.getValue());
            if (!itr.hasNext()) continue;
            builder.append("::");
        }
        return builder.toString();
    }

    private Map<String, String> stringToThemeMap(String themesString) {
        String[] themeIds;
        HashMap<String, String> themeMap = new HashMap<String, String>();
        for (String ele : themeIds = themesString.split("::")) {
            String[] strs = ele.split(":");
            themeMap.put(strs[0], strs[1]);
        }
        return themeMap;
    }

    public PortletMode getCurrentPortletMode() {
        return this.currentPortletMode_;
    }

    public void setCurrentPortletMode(PortletMode mode) {
        this.currentPortletMode_ = mode;
    }

    public javax.portlet.WindowState getCurrentWindowState() {
        return this.currentWindowState_;
    }

    public void setCurrentWindowState(javax.portlet.WindowState state) {
        this.currentWindowState_ = state;
    }

    public List<QName> getSupportedProcessingEvents() {
        return this.supportedProcessingEvents_;
    }

    public void setSupportedProcessingEvents(List<QName> supportedProcessingEvents) {
        this.supportedProcessingEvents_ = supportedProcessingEvents;
    }

    public List<String> getSupportedPublicRenderParameters() {
        return this.supportedPublicParams_;
    }

    public void setSupportedPublicRenderParameters(List<String> supportedPublicRenderParameters) {
        this.supportedPublicParams_ = supportedPublicRenderParameters;
    }

    public String getDisplayTitle() {
        String title = this.getTitle();
        if (title == null) {
            title = this.getDisplayName();
        }
        return title;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            Portlet portlet = this.getProducedOfferedPortlet();
            if (portlet != null) {
                PortletInfo info = portlet.getInfo();
                MetaInfo meta = info.getMeta();
                this.displayName = meta.getMetaValue("display-name");
                String value = null;
                if (this.displayName != null) {
                    org.exoplatform.web.application.RequestContext i = PortalRequestContext.getCurrentInstance();
                    Locale locale = i.getLocale();
                    value = this.displayName.getString(locale, true);
                }
                if (value == null || value.length() == 0) {
                    value = info.getName();
                }
                return value;
            }
            return "";
        }
        String value = null;
        if (this.displayName != null) {
            org.exoplatform.web.application.RequestContext i = PortalRequestContext.getCurrentInstance();
            Locale locale = i.getLocale();
            value = this.displayName.getString(locale, true);
        }
        if (value == null || value.length() == 0) {
            Portlet portlet = this.getProducedOfferedPortlet();
            PortletInfo info = portlet.getInfo();
            value = info.getName();
        }
        return value;
    }

    public Portlet getProducedOfferedPortlet() {
        return this.producedOfferedPortlet;
    }

    public List<String> getSupportModes() {
        if (this.supportModes_ != null) {
            return this.supportModes_;
        }
        ArrayList<String> supportModes = new ArrayList<String>();
        Portlet portlet = this.getProducedOfferedPortlet();
        if (portlet == null) {
            return supportModes;
        }
        Set modes = portlet.getInfo().getCapabilities().getModes(MediaType.create((String)"text/html"));
        for (ModeInfo info : modes) {
            supportModes.add(info.getModeName());
        }
        if (supportModes.size() > 0) {
            supportModes.remove("view");
        }
        this.setSupportModes(supportModes);
        return supportModes;
    }

    public void setSupportModes(List<String> supportModes) {
        this.supportModes_ = supportModes;
    }

    public boolean supportsProcessingEvent(QName name) {
        if (this.supportedProcessingEvents_ == null) {
            Portlet portlet = this.getProducedOfferedPortlet();
            if (portlet == null) {
                log.info((Object)("Could not find portlet with ID : " + this.producerOfferedPortletContext.getId()));
                return false;
            }
            Map consumedEvents = portlet.getInfo().getEventing().getConsumedEvents();
            if (consumedEvents == null) {
                return false;
            }
            this.supportedProcessingEvents_ = new ArrayList(consumedEvents.keySet());
        }
        for (QName eventName : this.supportedProcessingEvents_) {
            if (!eventName.equals(name)) continue;
            log.info((Object)("The Portlet " + this.producerOfferedPortletContext + " supports comsuming the event : " + name));
            return true;
        }
        log.info((Object)("The portlet " + this.producerOfferedPortletContext + " doesn't support consuming the event : " + name));
        return false;
    }

    public boolean supportsPublishingEvent(QName name) {
        if (this.supportedPublishingEvents_ == null) {
            Portlet portlet = this.getProducedOfferedPortlet();
            if (portlet == null) {
                log.info((Object)("Could not find portlet with ID : " + this.producerOfferedPortletContext.getId()));
                return false;
            }
            Map producedEvents = portlet.getInfo().getEventing().getProducedEvents();
            if (producedEvents == null) {
                return false;
            }
            this.supportedPublishingEvents_ = new ArrayList(producedEvents.keySet());
        }
        for (QName eventName : this.supportedPublishingEvents_) {
            if (!eventName.equals(name)) continue;
            log.info((Object)("The Portlet " + this.producerOfferedPortletContext + " supports producing the event : " + name));
            return true;
        }
        log.info((Object)("The portlet " + this.producerOfferedPortletContext + " doesn't support producing the event : " + name));
        return false;
    }

    public boolean supportsPublicParam(String supportedPublicParam) {
        if (this.supportedPublicParams_ == null) {
            if (this.producedOfferedPortlet == null) {
                log.info((Object)("Could not find portlet with ID : " + this.producerOfferedPortletContext.getId()));
                return false;
            }
            Collection parameters = this.producedOfferedPortlet.getInfo().getNavigation().getPublicParameters();
            this.supportedPublicParams_ = new ArrayList<String>();
            for (ParameterInfo parameter : parameters) {
                this.supportedPublicParams_.add(parameter.getId());
            }
        }
        for (String publicParam : this.supportedPublicParams_) {
            if (!publicParam.equals(supportedPublicParam)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("The Portlet " + this.producerOfferedPortletContext.getId() + " supports the public render parameter : " + supportedPublicParam));
            }
            return true;
        }
        return false;
    }

    public List<String> getPublicRenderParamNames() {
        UIPortal uiPortal = Util.getUIPortal();
        Map<String, String[]> publicParams = uiPortal.getPublicParameters();
        ArrayList<String> publicParamsSupportedByPortlet = new ArrayList<String>();
        if (publicParams != null) {
            Set<String> keys = publicParams.keySet();
            for (String key : keys) {
                if (!this.supportsPublicParam(key)) continue;
                publicParamsSupportedByPortlet.add(key);
            }
            return publicParamsSupportedByPortlet;
        }
        return new ArrayList<String>();
    }

    public Map<String, String[]> getPublicParameters() {
        HashMap<String, String[]> publicParamsMap = new HashMap<String, String[]>();
        UIPortal uiPortal = Util.getUIPortal();
        Map<String, String[]> publicParams = uiPortal.getPublicParameters();
        Set<String> allPublicParamsNames = publicParams.keySet();
        List<String> supportedPublicParamNames = this.getPublicRenderParamNames();
        for (String oneOfAllParams : allPublicParamsNames) {
            if (!supportedPublicParamNames.contains(oneOfAllParams)) continue;
            publicParamsMap.put(oneOfAllParams, publicParams.get(oneOfAllParams));
        }
        return publicParamsMap;
    }

    public <I extends PortletInvocation> I create(Class<I> type, PortalRequestContext prc) throws Exception {
        ExoPortletInstanceContext instanceContext;
        PortletInvocation invocation;
        ExoPortletInvocationContext pic = new ExoPortletInvocationContext(prc, this);
        HttpServletRequest servletRequest = prc.getRequest();
        HashMap<String, String[]> allParams = new HashMap<String, String[]>();
        allParams.putAll(servletRequest.getParameterMap());
        allParams.putAll(this.getPublicParameters());
        if (type.equals(ActionInvocation.class)) {
            ActionInvocation actionInvocation = new ActionInvocation((PortletInvocationContext)pic);
            actionInvocation.setForm(allParams);
            actionInvocation.setRequestContext((RequestContext)new AbstractRequestContext(servletRequest));
            String interactionState = servletRequest.getParameter("interactionstate");
            if (interactionState != null) {
                actionInvocation.setInteractionState(StateString.create((String)interactionState));
            }
            invocation = (PortletInvocation)type.cast(actionInvocation);
        } else if (type.equals(ResourceInvocation.class)) {
            String resourceState;
            String cachability;
            ResourceInvocation resourceInvocation = new ResourceInvocation((PortletInvocationContext)pic);
            resourceInvocation.setRequestContext((RequestContext)new AbstractRequestContext(servletRequest));
            String resourceId = servletRequest.getParameter("portal:resourceID");
            if (resourceId != null) {
                resourceInvocation.setResourceId(resourceId);
            }
            if ((cachability = servletRequest.getParameter("portal:cacheLevel")) != null) {
                resourceInvocation.setCacheLevel(CacheLevel.valueOf((String)cachability));
            }
            if ((resourceState = servletRequest.getParameter("resourcestate")) != null) {
                resourceInvocation.setResourceState(StateString.create((String)resourceState));
            }
            resourceInvocation.setForm(allParams);
            invocation = (PortletInvocation)type.cast(resourceInvocation);
        } else if (type.equals(EventInvocation.class)) {
            invocation = (PortletInvocation)type.cast(new EventInvocation((PortletInvocationContext)pic));
        } else if (type.equals(RenderInvocation.class)) {
            invocation = (PortletInvocation)type.cast(new RenderInvocation((PortletInvocationContext)pic));
        } else {
            throw new AssertionError();
        }
        invocation.setNavigationalState(this.navigationalState);
        invocation.setPublicNavigationalState(this.getPublicParameters());
        invocation.setMode(Mode.create((String)this.getCurrentPortletMode().toString()));
        invocation.setWindowState(WindowState.create((String)this.getCurrentWindowState().toString()));
        StatefulPortletContext<C> preferencesPortletContext = this.getPortletContext();
        if (preferencesPortletContext == null) {
            return null;
        }
        UserProfile userProfile = (UserProfile)prc.getAttribute("PortalUserProfile");
        Cookie[] cookies = servletRequest.getCookies();
        AbstractClientContext clientContext = cookies != null ? new AbstractClientContext(servletRequest, Arrays.asList(cookies)) : new AbstractClientContext(servletRequest);
        invocation.setClientContext((ClientContext)clientContext);
        if (ApplicationType.WSRP_PORTLET.equals(this.state.getApplicationType())) {
            WSRP wsrp = (WSRP)preferencesPortletContext.getState();
            AccessMode accessMode = AccessMode.CLONE_BEFORE_WRITE;
            if (wsrp.isCloned()) {
                accessMode = AccessMode.READ_WRITE;
            }
            instanceContext = new ExoPortletInstanceContext(preferencesPortletContext.getId(), accessMode);
        } else {
            instanceContext = new ExoPortletInstanceContext(preferencesPortletContext.getId());
        }
        invocation.setInstanceContext((InstanceContext)instanceContext);
        invocation.setServerContext((ServerContext)new AbstractServerContext(servletRequest, prc.getResponse()));
        invocation.setUserContext((UserContext)new ExoUserContext(servletRequest, userProfile));
        invocation.setWindowContext((WindowContext)new ExoWindowContext(this.storageName));
        invocation.setPortalContext((PortalContext)new AbstractPortalContext(Collections.singletonMap("javax.portlet.markup.head.element.support", "false")));
        invocation.setSecurityContext((SecurityContext)new AbstractSecurityContext(servletRequest));
        invocation.setTarget(preferencesPortletContext);
        return (I)invocation;
    }

    public void update(PropertyChange ... changes) throws Exception {
        StatefulPortletContext<C> portletContext = this.getPortletContext();
        PortletInvoker portletInvoker = (PortletInvoker)this.getApplicationComponent(PortletInvoker.class);
        StatefulPortletContext updatedCtx = (StatefulPortletContext)portletInvoker.setProperties(portletContext, changes);
        Serializable updateState = updatedCtx.getState();
        this.update(updateState);
    }

    public PortletState<S> getState() {
        return this.state;
    }

    public void setState(PortletState<S> state) {
        if (state != null) {
            try {
                PortletInvoker portletInvoker = (PortletInvoker)this.getApplicationComponent(PortletInvoker.class);
                DataStorage dataStorage = (DataStorage)this.getApplicationComponent(DataStorage.class);
                String applicationId = dataStorage.getId(state.getApplicationState());
                ModelAdapter adapter = ModelAdapter.getAdapter(state.getApplicationType());
                PortletContext producerOfferedPortletContext = adapter.getProducerOfferedPortletContext(applicationId);
                Portlet producedOfferedPortlet = portletInvoker.getPortlet(producerOfferedPortletContext);
                this.adapter = adapter;
                this.producerOfferedPortletContext = producerOfferedPortletContext;
                this.producedOfferedPortlet = producedOfferedPortlet;
                this.applicationId = applicationId;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.adapter = null;
            this.producedOfferedPortlet = null;
            this.producerOfferedPortletContext = null;
            this.applicationId = null;
        }
        this.state = state;
    }

    public org.exoplatform.portal.pom.spi.portlet.Portlet getPreferences() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        return this.adapter.getState(container, this.state.getApplicationState());
    }

    public StatefulPortletContext<C> getPortletContext() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        return this.adapter.getPortletContext(container, this.applicationId, this.state.getApplicationState());
    }

    public void update(C updateState) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        this.state.setApplicationState(this.adapter.update(container, updateState, this.state.getApplicationState()));
        this.setState(this.state);
    }

    public static UIPortlet getCurrentUIPortlet() {
        return currentPortlet.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
        PortletInvoker portletInvoker = (PortletInvoker)this.getApplicationComponent(PortletInvoker.class);
        currentPortlet.set(this);
        try {
            PortletInvocationResponse portletInvocationResponse = portletInvoker.invoke(invocation);
            return portletInvocationResponse;
        }
        finally {
            currentPortlet.set(null);
        }
    }

    void setNavigationalState(StateString navigationalState) {
        this.navigationalState = navigationalState;
    }
}

