/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.io.Serializable;
import java.nio.charset.Charset;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.exoplatform.commons.utils.Text;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.portlet.PortletExceptionHandleService;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ApplicationResourceResolver;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.portletcontainer.PortletContainerException;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.event.Event;
import org.gatein.common.util.MultiValuedPropertyMap;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.FragmentResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIPortletLifecycle<S, C extends Serializable, I>
extends Lifecycle<UIPortlet<S, C>> {
    protected static Log log = ExoLogger.getLogger((String)"portal:UIPortletLifecycle");

    public void processAction(UIPortlet<S, C> uicomponent, WebuiRequestContext context) throws Exception {
        String portletActionType;
        String windowState;
        String action = context.getRequestParameter("portal:action");
        if (action != null) {
            Event event = uicomponent.createEvent(action, Event.Phase.PROCESS, context);
            if (event != null) {
                event.broadcast();
            }
            return;
        }
        boolean addUpdateComponent = false;
        String portletMode = context.getRequestParameter("portal:portletMode");
        if (portletMode != null) {
            Event event = uicomponent.createEvent("ChangePortletMode", Event.Phase.PROCESS, context);
            if (event != null) {
                event.broadcast();
            }
            addUpdateComponent = true;
        }
        if ((windowState = context.getRequestParameter("portal:windowState")) != null) {
            Event event = uicomponent.createEvent("ChangeWindowState", Event.Phase.PROCESS, context);
            if (event != null) {
                event.broadcast();
            }
            addUpdateComponent = true;
        }
        if ((portletActionType = context.getRequestParameter("portal:type")) != null) {
            if (portletActionType.equals("action")) {
                Event event = uicomponent.createEvent("ProcessAction", Event.Phase.PROCESS, context);
                if (event != null) {
                    event.broadcast();
                }
                addUpdateComponent = true;
            } else if (portletActionType.equals("resource")) {
                Event event = uicomponent.createEvent("ServeResource", Event.Phase.PROCESS, context);
                if (event != null) {
                    event.broadcast();
                }
            } else {
                Event event = uicomponent.createEvent("Render", Event.Phase.PROCESS, context);
                if (event != null) {
                    event.broadcast();
                }
                addUpdateComponent = true;
            }
        }
        if (addUpdateComponent) {
            context.addUIComponentToUpdateByAjax(uicomponent);
        }
    }

    public void processRender(UIPortlet<S, C> uicomponent, WebuiRequestContext context) throws Exception {
        PortalRequestContext prcontext = (PortalRequestContext)context;
        ExoContainer container = prcontext.getApplication().getApplicationServiceContainer();
        Text markup = null;
        String portletTitle = null;
        try {
            RenderInvocation renderInvocation = uicomponent.create(RenderInvocation.class, prcontext);
            if (uicomponent.getCurrentWindowState() != WindowState.MINIMIZED) {
                String appStatus = (String)uicomponent.getProperties().get((Object)"appStatus");
                if ("Window".equals(uicomponent.getPortletStyle()) && !"SHOW".equals(appStatus) && !"HIDE".equals(appStatus)) {
                    markup = Text.create((String)"<span></span>");
                } else {
                    int portalMode = Util.getUIPortalApplication().getModeState();
                    if (portalMode % 2 == 0 || uicomponent.getCurrentPortletMode().equals((Object)PortletMode.EDIT)) {
                        PortletInvocationResponse response = uicomponent.invoke((PortletInvocation)renderInvocation);
                        if (response instanceof FragmentResponse) {
                            FragmentResponse fragmentResponse = (FragmentResponse)response;
                            switch (fragmentResponse.getType()) {
                                case 1: {
                                    markup = Text.create((String)fragmentResponse.getContent());
                                    break;
                                }
                                case 2: {
                                    markup = Text.create((byte[])fragmentResponse.getBytes(), (Charset)Charset.forName("UTF-8"));
                                    break;
                                }
                                case 0: {
                                    markup = Text.create((String)"");
                                }
                            }
                            portletTitle = fragmentResponse.getTitle();
                            if (fragmentResponse.getProperties() != null && fragmentResponse.getProperties().getTransportHeaders() != null) {
                                MultiValuedPropertyMap transportHeaders = fragmentResponse.getProperties().getTransportHeaders();
                                for (String key : transportHeaders.keySet()) {
                                    for (String value : transportHeaders.getValues(key)) {
                                        prcontext.getResponse().setHeader(key, value);
                                    }
                                }
                            }
                        } else {
                            PortletContainerException pcException;
                            if (response instanceof ErrorResponse) {
                                ErrorResponse errorResponse = (ErrorResponse)response;
                                pcException = new PortletContainerException(errorResponse.getMessage(), errorResponse.getCause());
                            } else {
                                pcException = new PortletContainerException("Unknown invocation response type [" + response.getClass() + "]. Expected a FragmentResponse or an ErrorResponse");
                            }
                            PortletExceptionHandleService portletExceptionService = (PortletExceptionHandleService)container.getComponentInstanceOfType(PortletExceptionHandleService.class);
                            portletExceptionService.handle(pcException);
                            markup = Text.create((String)"This portlet encountered an error and could not be displayed.");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            PortletContainerException pcException = new PortletContainerException((Throwable)e);
            PortletExceptionHandleService portletExceptionService = (PortletExceptionHandleService)container.getComponentInstanceOfType(PortletExceptionHandleService.class);
            portletExceptionService.handle(pcException);
            markup = Text.create((String)"This portlet encountered an error and could not be displayed.");
        }
        if (portletTitle == null) {
            portletTitle = "Portlet";
        }
        if (context.useAjax() && !prcontext.getFullRender()) {
            if (markup != null) {
                markup.writeTo(prcontext.getWriter());
            }
        } else {
            WebuiApplication app = (WebuiApplication)prcontext.getApplication();
            ApplicationResourceResolver resolver = app.getResourceResolver();
            WebuiBindingContext bcontext = new WebuiBindingContext((ResourceResolver)resolver, context.getWriter(), uicomponent, (WebuiRequestContext)prcontext);
            bcontext.put((Object)"uicomponent", uicomponent);
            bcontext.put((Object)"portletContent", (Object)markup);
            bcontext.put((Object)"portletTitle", (Object)portletTitle);
            try {
                this.renderTemplate(uicomponent.getTemplate(), bcontext);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }
}

