/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.ArrayList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE, name="ClosePopup")})
public class UIPageNavigationForm
extends UIForm {
    private PageNavigation pageNav_;
    private String ownerId;
    private String description;
    private String ownerType;
    private String priority;

    public void addFormInput() throws Exception {
        ArrayList<SelectItemOption> priorties = new ArrayList<SelectItemOption>();
        for (int i = 1; i < 11; ++i) {
            priorties.add(new SelectItemOption(String.valueOf(i), (Object)String.valueOf(i)));
        }
        this.addUIFormInput((UIFormInput)new UIFormStringInput("ownerType", "ownerType", this.getOwnerType()).setEditable(false)).addUIFormInput((UIFormInput)new UIFormStringInput("ownerId", "ownerId", this.ownerId).setEditable(false)).addUIFormInput((UIFormInput)new UIFormTextAreaInput("description", "description", this.getDescription()).addValidator(StringLengthValidator.class, new Object[]{0, 255})).addUIFormInput((UIFormInput)new UIFormSelectBox("priority", null, priorties).setValue(this.getPriority()));
    }

    public void setValues(PageNavigation pageNavigation) throws Exception {
        this.setPageNav(pageNavigation);
        this.invokeGetBindingBean(pageNavigation);
        this.removeChildById("ownerId");
        this.getUIStringInput("creator").setValue((Object)pageNavigation.getCreator());
        UIFormStringInput ownerId = new UIFormStringInput("ownerId", "ownerId", pageNavigation.getOwnerId());
        ownerId.setEditable(false);
        ownerId.setParent((UIComponent)this);
        this.getChildren().add(1, ownerId);
        UIFormSelectBox uiSelectBox = (UIFormSelectBox)this.findComponentById("priority");
        uiSelectBox.setValue(String.valueOf(pageNavigation.getPriority()));
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPageNav(PageNavigation pageNav_) {
        this.pageNav_ = pageNav_;
    }

    public PageNavigation getPageNav() {
        return this.pageNav_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIPageNavigationForm> {
        public void execute(Event<UIPageNavigationForm> event) throws Exception {
            UIPageNavigationForm uiForm = (UIPageNavigationForm)((Object)event.getSource());
            uiForm.getParent().broadcast(event, Event.Phase.ANY);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIPageNavigationForm> {
        public void execute(Event<UIPageNavigationForm> event) throws Exception {
            UIPageNavigationForm uiForm = (UIPageNavigationForm)((Object)event.getSource());
            PageNavigation pageNav = uiForm.getPageNav();
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UserPortalConfigService portalConfigService = (UserPortalConfigService)uiForm.getApplicationComponent(UserPortalConfigService.class);
            PageNavigation persistNavigation = portalConfigService.getPageNavigation(pageNav.getOwnerType(), pageNav.getOwnerId());
            if (persistNavigation == null) {
                UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UINavigationManagement.msg.NavigationNotExistAnymore", null));
                UIPortalApplication uiPortalApp = (UIPortalApplication)prContext.getUIApplication();
                UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
                UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getParent();
                uiPopup.setShow(false);
                prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
                return;
            }
            WebuiRequestContext pcontext = event.getRequestContext();
            UserPortalConfigService service = (UserPortalConfigService)uiForm.getApplicationComponent(UserPortalConfigService.class);
            if (pageNav != null) {
                uiForm.invokeSetBindingBean(pageNav);
                UIFormSelectBox uiSelectBox = (UIFormSelectBox)uiForm.findComponentById("priority");
                int priority = Integer.parseInt((String)uiSelectBox.getValue());
                pageNav.setPriority(priority);
                pageNav.setModifier(pcontext.getRemoteUser());
                service.update(pageNav);
                UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getParent();
                uiPopup.setShow(false);
                UIComponent opener = uiPopup.getParent();
                pcontext.addUIComponentToUpdateByAjax(opener);
                return;
            }
            pageNav = new PageNavigation();
            uiForm.invokeSetBindingBean(pageNav);
            UIFormStringInput uiOwnerId = (UIFormStringInput)uiForm.findComponentById("ownerId");
            UIFormStringInput uiOwnerType = (UIFormStringInput)uiForm.findComponentById("ownerType");
            UIFormSelectBox uiSelectBox = (UIFormSelectBox)uiForm.findComponentById("priority");
            int priority = Integer.parseInt((String)uiSelectBox.getValue());
            pageNav.setPriority(priority);
            pageNav.setModifiable(true);
            pageNav.setCreator(pcontext.getRemoteUser());
            pageNav.setOwnerId((String)uiOwnerId.getValue());
            pageNav.setOwnerType((String)uiOwnerType.getValue());
            UIPortalApplication uiPortalApp = (UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class);
            DataStorage dataService = (DataStorage)uiForm.getApplicationComponent(DataStorage.class);
            if (dataService.getPageNavigation(pageNav.getOwnerType(), pageNav.getOwnerId()) != null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageNavigationForm.msg.existPageNavigation", (Object[])new String[]{pageNav.getOwnerId()}));
                return;
            }
            service.create(pageNav);
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getParent();
            uiPopup.setShow(false);
            UIComponent opener = uiPopup.getParent();
            pcontext.addUIComponentToUpdateByAjax(opener);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChild(UIWorkingWorkspace.class);
            uiWorkingWS.updatePortletsByName("GroupNavigationPortlet");
        }
    }
}

