/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/portal/webui/navigation/UIPageNodeSelector.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class})})
public class UIPageNodeSelector
extends UIContainer {
    private PageNavigation selectedNavigation;
    private SelectedNode selectedNode;
    private SelectedNode copyNode;

    public UIPageNodeSelector() throws Exception {
        UITree uiTree = (UITree)this.addChild(UITree.class, null, "TreePageSelector");
        uiTree.setIcon("DefaultPageIcon");
        uiTree.setSelectedIcon("DefaultPageIcon");
        uiTree.setBeanIdField("uri");
        uiTree.setBeanLabelField("resolvedLabel");
        uiTree.setBeanIconField("icon");
        this.loadNavigations();
    }

    public void loadNavigations() throws Exception {
        PageNavigation portalSelectedNav = Util.getUIPortal().getSelectedNavigation();
        if (portalSelectedNav != null) {
            this.selectNavigation(portalSelectedNav);
            PageNode portalSelectedNode = Util.getUIPortal().getSelectedNode();
            if (portalSelectedNode != null) {
                this.selectPageNodeByUri(portalSelectedNode.getUri());
            }
            return;
        }
        this.selectNavigation();
    }

    private void selectNavigation() {
        if (this.selectedNavigation == null) {
            return;
        }
        if (this.selectedNode == null || this.selectedNavigation.getId() != this.selectedNode.getPageNavigation().getId()) {
            this.selectedNode = new SelectedNode(this.selectedNavigation, null, null);
            if (this.selectedNavigation.getNodes().size() > 0) {
                this.selectedNode.setNode((PageNode)this.selectedNavigation.getNodes().get(0));
            }
        }
        this.selectNavigation(this.selectedNode.getPageNavigation());
        if (this.selectedNode.getNode() != null) {
            this.selectPageNodeByUri(this.selectedNode.getNode().getUri());
        }
    }

    public void selectNavigation(PageNavigation pageNav) {
        this.selectedNavigation = pageNav;
        this.selectedNode = new SelectedNode(pageNav, null, null);
        this.selectPageNodeByUri(null);
        UITree uiTree = (UITree)this.getChild(UITree.class);
        uiTree.setSibbling((List)pageNav.getNodes());
    }

    public void selectPageNodeByUri(String uri) {
        if (this.selectedNode == null || this.selectedNavigation.getId() != this.selectedNode.getPageNavigation().getId()) {
            return;
        }
        UITree tree = (UITree)this.getChild(UITree.class);
        List sibbling = tree.getSibbling();
        tree.setSibbling(null);
        tree.setParentSelected(null);
        this.selectedNode.setNode(this.searchPageNodeByUri(this.selectedNode.getPageNavigation(), uri));
        if (this.selectedNode.getNode() != null) {
            tree.setSelected((Object)this.selectedNode.getNode());
            tree.setChildren(this.selectedNode.getNode().getChildren());
            return;
        }
        tree.setSelected(null);
        tree.setChildren(null);
        tree.setSibbling(sibbling);
    }

    public PageNode searchPageNodeByUri(PageNavigation pageNav, String uri) {
        if (pageNav == null || uri == null) {
            return null;
        }
        ArrayList pageNodes = pageNav.getNodes();
        UITree uiTree = (UITree)this.getChild(UITree.class);
        for (PageNode ele : pageNodes) {
            PageNode returnPageNode = this.searchPageNodeByUri(ele, uri, uiTree);
            if (returnPageNode == null) continue;
            if (uiTree.getSibbling() == null) {
                uiTree.setSibbling((List)pageNodes);
            }
            return returnPageNode;
        }
        return null;
    }

    private PageNode searchPageNodeByUri(PageNode pageNode, String uri, UITree tree) {
        if (pageNode.getUri().equals(uri)) {
            return pageNode;
        }
        List children = pageNode.getChildren();
        if (children == null) {
            return null;
        }
        for (PageNode ele : children) {
            PageNode returnPageNode = this.searchPageNodeByUri(ele, uri, tree);
            if (returnPageNode == null) continue;
            if (tree.getSibbling() == null) {
                tree.setSibbling(children);
            }
            if (tree.getParentSelected() == null) {
                tree.setParentSelected((Object)pageNode);
            }
            this.selectedNode.setParentNode(pageNode);
            return returnPageNode;
        }
        return null;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIRightClickPopupMenu uiPopupMenu = (UIRightClickPopupMenu)this.getChild(UIRightClickPopupMenu.class);
        if (uiPopupMenu != null) {
            uiPopupMenu.setRendered(true);
        }
        super.processRender(context);
    }

    public SelectedNode getCopyNode() {
        return this.copyNode;
    }

    public void setCopyNode(SelectedNode copyNode) {
        this.copyNode = copyNode;
    }

    public SelectedNode getSelectedNode() {
        return this.selectedNode;
    }

    public PageNavigation getSelectedNavigation() {
        return this.selectedNavigation;
    }

    public PageNode getSelectedPageNode() {
        return this.selectedNode == null ? null : this.selectedNode.getNode();
    }

    public String getUpLevelUri() {
        return this.selectedNode.getParentNode().getUri();
    }

    public static class SelectedNode {
        private PageNavigation nav;
        private PageNode parentNode;
        private PageNode node;
        private boolean deleteNode = false;
        private boolean cloneNode = false;

        public SelectedNode(PageNavigation nav, PageNode parentNode, PageNode node) {
            this.nav = nav;
            this.parentNode = parentNode;
            this.node = node;
        }

        public PageNavigation getPageNavigation() {
            return this.nav;
        }

        public void setPageNavigation(PageNavigation nav) {
            this.nav = nav;
        }

        public PageNode getParentNode() {
            return this.parentNode;
        }

        public void setParentNode(PageNode parentNode) {
            this.parentNode = parentNode;
        }

        public PageNode getNode() {
            return this.node;
        }

        public void setNode(PageNode node) {
            this.node = node;
        }

        public boolean isDeleteNode() {
            return this.deleteNode;
        }

        public void setDeleteNode(boolean deleteNode) {
            this.deleteNode = deleteNode;
        }

        public boolean isCloneNode() {
            return this.cloneNode;
        }

        public void setCloneNode(boolean b) {
            this.cloneNode = b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UITree> {
        public void execute(Event<UITree> event) throws Exception {
            String uri = event.getRequestContext().getRequestParameter("objectId");
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)((UITree)event.getSource()).getParent();
            uiPageNodeSelector.selectPageNodeByUri(uri);
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPageNodeSelector.getAncestorOfType(UIPortalApplication.class);
            UIPortalToolPanel uiToolPanel = Util.getUIPortalToolPanel();
            uiToolPanel.setRenderSibling(UIPortalToolPanel.class);
            uiToolPanel.setShowMaskLayer(true);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            pcontext.setFullRender(true);
            UIContainer uiParent = (UIContainer)uiPageNodeSelector.getParent();
            PageNode node = null;
            node = uiPageNodeSelector.getSelectedNode() == null ? Util.getUIPortal().getSelectedNode() : uiPageNodeSelector.getSelectedNode().getNode();
            if (node == null) {
                uiPageNodeSelector.selectNavigation(uiPageNodeSelector.getSelectedNavigation());
                uiToolPanel.setUIComponent(null);
                return;
            }
            UserPortalConfigService configService = (UserPortalConfigService)uiParent.getApplicationComponent(UserPortalConfigService.class);
            Page page = null;
            if (node.getPageReference() != null) {
                page = configService.getPage(node.getPageReference(), event.getRequestContext().getRemoteUser());
            }
            if (page == null) {
                uiToolPanel.setUIComponent(null);
                return;
            }
            UIPage uiPage = Util.toUIPage(node, (UIComponent)uiToolPanel);
            UIPageBody uiPageBody = (UIPageBody)uiPortalApp.findFirstComponentOfType(UIPageBody.class);
            if (uiPageBody.getUIComponent() != null) {
                uiPageBody.setUIComponent(null);
            }
            uiToolPanel.setUIComponent((UIComponent)uiPage);
        }
    }
}

