/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.config.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.RegistrationPolicyChangeListener;
import org.gatein.registration.RegistrationPropertyChangeListener;
import org.gatein.registration.policies.DefaultRegistrationPolicy;
import org.gatein.registration.policies.DefaultRegistrationPropertyValidator;
import org.gatein.registration.policies.RegistrationPropertyValidator;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;
import org.gatein.wsrp.registration.ValueChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerRegistrationRequirementsImpl
implements ProducerRegistrationRequirements {
    private static final Logger log = LoggerFactory.getLogger(ProducerRegistrationRequirementsImpl.class);
    private boolean requiresRegistration;
    private boolean fullServiceDescriptionRequiresRegistration;
    private RegistrationPolicy policy;
    private String policyClassName;
    private String validatorClassName;
    private Map<QName, RegistrationPropertyDescription> registrationProperties;
    private Set<RegistrationPropertyChangeListener> propertyChangeListeners = new HashSet<RegistrationPropertyChangeListener>(3);
    private Set<RegistrationPolicyChangeListener> policyChangeListeners = new HashSet<RegistrationPolicyChangeListener>(3);

    public ProducerRegistrationRequirementsImpl(boolean requiresMarshalling, boolean requiresRegistration, boolean fullServiceDescriptionRequiresRegistration) {
        this();
        this.requiresRegistration = requiresRegistration;
        this.fullServiceDescriptionRequiresRegistration = fullServiceDescriptionRequiresRegistration;
    }

    public ProducerRegistrationRequirementsImpl() {
        this.registrationProperties = new HashMap<QName, RegistrationPropertyDescription>(7);
    }

    @Override
    public boolean isRegistrationRequired() {
        return this.requiresRegistration;
    }

    @Override
    public void setRegistrationRequired(boolean requiresRegistration) {
        if (this.requiresRegistration && !requiresRegistration) {
            this.clearRegistrationProperties();
        }
        this.requiresRegistration = requiresRegistration;
    }

    @Override
    public boolean isRegistrationRequiredForFullDescription() {
        return this.fullServiceDescriptionRequiresRegistration;
    }

    @Override
    public void setRegistrationRequiredForFullDescription(boolean fullServiceDescriptionRequiresRegistration) {
        this.fullServiceDescriptionRequiresRegistration = fullServiceDescriptionRequiresRegistration;
    }

    @Override
    public Map<QName, RegistrationPropertyDescription> getRegistrationProperties() {
        return Collections.unmodifiableMap(this.registrationProperties);
    }

    @Override
    public void addRegistrationProperty(RegistrationPropertyDescription propertyDescription) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyDescription, (String)"PropertyDescription");
        QName name = propertyDescription.getName();
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"Property name");
        this.registrationProperties.put(name, propertyDescription);
        propertyDescription.setValueChangeListener((ValueChangeListener)this);
        this.notifyRegistrationPropertyChangeListeners();
    }

    @Override
    public void addEmptyRegistrationProperty(String name) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"Property name");
        RegistrationPropertyDescription reg = new RegistrationPropertyDescription(name, WSRPConstants.XSD_STRING);
        this.addRegistrationProperty(reg);
    }

    @Override
    public boolean acceptValueFor(QName propertyName, Object value) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        QName type = this.getPropertyDescription(propertyName).getType();
        return true;
    }

    @Override
    public boolean acceptValueFor(String propertyName, Object value) {
        return this.acceptValueFor(new QName(propertyName), value);
    }

    @Override
    public RegistrationPropertyDescription getRegistrationPropertyWith(String name) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"Property name", null);
        return this.getRegistrationPropertyWith(new QName(name));
    }

    @Override
    public RegistrationPropertyDescription getRegistrationPropertyWith(QName name) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"Property name");
        return this.registrationProperties.get(name);
    }

    private RegistrationPropertyDescription getPropertyDescription(QName propertyName) {
        return new RegistrationPropertyDescription(this.registrationProperties.get(propertyName));
    }

    @Override
    public void removeRegistrationProperty(QName propertyName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        this.registrationProperties.remove(propertyName);
        this.notifyRegistrationPropertyChangeListeners();
    }

    @Override
    public void clearRegistrationProperties() {
        this.registrationProperties.clear();
        this.notifyRegistrationPropertyChangeListeners();
    }

    @Override
    public void removeRegistrationProperty(String propertyName) {
        this.removeRegistrationProperty(new QName(propertyName));
    }

    public void valueHasChanged(RegistrationPropertyDescription originatingProperty, Object oldValue, Object newValue, boolean isName) {
        this.notifyRegistrationPropertyChangeListeners();
        if (isName && oldValue instanceof QName) {
            this.propertyHasBeenRenamed(originatingProperty, (QName)oldValue);
        }
    }

    @Override
    public void notifyRegistrationPropertyChangeListeners() {
        for (RegistrationPropertyChangeListener listener : this.propertyChangeListeners) {
            listener.propertiesHaveChanged(this.registrationProperties);
        }
    }

    @Override
    public void clearRegistrationPropertyChangeListeners() {
        this.propertyChangeListeners.clear();
    }

    @Override
    public void addRegistrationPropertyChangeListener(RegistrationPropertyChangeListener listener) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)listener, (String)"RegistrationPropertyChangeListener");
        this.propertyChangeListeners.add(listener);
    }

    @Override
    public void removeRegistrationPropertyChangeListener(RegistrationPropertyChangeListener listener) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)listener, (String)"RegistrationPropertyChangeListener");
        this.propertyChangeListeners.remove(listener);
    }

    @Override
    public Set<RegistrationPropertyChangeListener> getPropertyChangeListeners() {
        return this.propertyChangeListeners;
    }

    @Override
    public void addRegistrationPolicyChangeListener(RegistrationPolicyChangeListener listener) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)listener, (String)"RegistrationPolicyChangeListener");
        this.policyChangeListeners.add(listener);
    }

    @Override
    public void removeRegistrationPolicyChangeListener(RegistrationPolicyChangeListener listener) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)listener, (String)"RegistrationPolicyChangeListener");
        this.policyChangeListeners.remove(listener);
    }

    @Override
    public void clearRegistrationPolicyChangeListeners() {
        this.policyChangeListeners.clear();
    }

    public void notifyRegistrationPolicyChangeListeners() {
        for (RegistrationPolicyChangeListener listener : this.policyChangeListeners) {
            listener.policyUpdatedTo(this.policy);
        }
    }

    @Override
    public Set<RegistrationPolicyChangeListener> getPolicyChangeListeners() {
        return this.policyChangeListeners;
    }

    @Override
    public void setPolicy(RegistrationPolicy policy) {
        this.policy = policy;
        if (policy != null) {
            this.policyClassName = policy.getClass().getName();
            if (policy instanceof DefaultRegistrationPolicy) {
                DefaultRegistrationPolicy registrationPolicy = (DefaultRegistrationPolicy)policy;
                this.validatorClassName = registrationPolicy.getValidator().getClass().getName();
            }
            this.policy.setExpectations(this.registrationProperties);
        }
        this.notifyRegistrationPolicyChangeListeners();
    }

    @Override
    public RegistrationPolicy getPolicy() {
        if (this.policy == null && this.requiresRegistration) {
            this.reloadPolicyFrom(this.policyClassName, this.validatorClassName);
        }
        return this.policy;
    }

    @Override
    public void reloadPolicyFrom(String policyClassName, String validatorClassName) {
        if (policyClassName != null && !"org.gatein.registration.policies.DefaultRegistrationPolicy".equals(policyClassName)) {
            log.debug("Using registration policy: " + policyClassName);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> policyClass = loader.loadClass(policyClassName);
                if (!RegistrationPolicy.class.isAssignableFrom(policyClass)) {
                    throw new IllegalArgumentException("Policy class does not implement RegistrationPolicy!");
                }
                RegistrationPolicy policy = (RegistrationPolicy)policyClass.newInstance();
                this.setPolicy(policy);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Couldn't find policy class " + policyClassName + ".", e);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Couldn't instantiate policy class.", e);
            }
        } else {
            RegistrationPropertyValidator validator;
            log.debug("Using default registration policy: org.gatein.registration.policies.DefaultRegistrationPolicy");
            if (validatorClassName != null) {
                log.debug("Using registration property validator: " + validatorClassName);
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> validatorClass = loader.loadClass(validatorClassName);
                    if (!RegistrationPropertyValidator.class.isAssignableFrom(validatorClass)) {
                        throw new IllegalArgumentException("Validator class does not implement RegistrationPropertyValidator!");
                    }
                    validator = (RegistrationPropertyValidator)validatorClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Couldn't find validator class " + validatorClassName + ".", e);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Couldn't instantiate validator class.", e);
                }
            } else {
                log.debug("Using default registration property validator: org.gatein.registration.policies.DefaultRegistrationPropertyValidator");
                validator = new DefaultRegistrationPropertyValidator();
            }
            DefaultRegistrationPolicy policy = new DefaultRegistrationPolicy();
            policy.setValidator(validator);
            this.setPolicy(policy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyHasBeenRenamed(RegistrationPropertyDescription propertyDescription, QName oldName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyDescription, (String)"RegistrationPropertyDescription");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)oldName, (String)"property old name");
        if (this.registrationProperties.containsKey(oldName)) {
            ProducerRegistrationRequirementsImpl producerRegistrationRequirementsImpl = this;
            synchronized (producerRegistrationRequirementsImpl) {
                this.registrationProperties.remove(oldName);
                this.registrationProperties.put(propertyDescription.getName(), propertyDescription);
            }
        }
    }

    public void setPolicyClassName(String policyClassName) {
        this.policyClassName = policyClassName;
    }

    public String getPolicyClassName() {
        if (this.policyClassName == null) {
            return "org.gatein.registration.policies.DefaultRegistrationPolicy";
        }
        return this.policyClassName;
    }

    public void setValidatorClassName(String validatorClassName) {
        this.validatorClassName = validatorClassName;
    }

    public String getValidatorClassName() {
        return this.validatorClassName;
    }
}

