/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.exoplatform.groovyscript.GroovyScript;
import org.exoplatform.groovyscript.GroovyScriptBuilder;
import org.exoplatform.groovyscript.TemplateCompilationException;
import org.exoplatform.groovyscript.TemplateRuntimeException;

public class GroovyTemplate {
    private final String templateText;
    private final GroovyScript script;

    private static String read(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        char[] chars = new char[256];
        int s = reader.read(chars);
        while (s != -1) {
            builder.append(chars, 0, s);
            s = reader.read(chars);
        }
        return builder.toString();
    }

    public GroovyTemplate(String id, String name, Reader scriptReader) throws IOException, TemplateCompilationException {
        this(id, name, GroovyTemplate.read(scriptReader));
    }

    public GroovyTemplate(Reader scriptReader) throws IOException, TemplateCompilationException {
        this(GroovyTemplate.read(scriptReader));
    }

    public GroovyTemplate(String templateText) throws TemplateCompilationException {
        this(null, null, templateText);
    }

    public GroovyTemplate(String templateId, String templateName, String templateText) throws TemplateCompilationException {
        if (templateName == null) {
            templateName = "fic";
        }
        GroovyScriptBuilder compiler = new GroovyScriptBuilder(templateId, templateName, templateText);
        this.script = compiler.build();
        this.templateText = templateText;
    }

    public String getId() {
        return this.script.getTemplateId();
    }

    public String getClassName() {
        return this.script.getScriptClass().getName();
    }

    public String getText() {
        return this.templateText;
    }

    public String getGroovy() {
        return this.script.getGroovyText();
    }

    public void render(Writer writer) throws IOException, TemplateRuntimeException {
        this.render(writer, null);
    }

    public void render(Writer writer, Map binding) throws IOException, TemplateRuntimeException {
        this.script.render(binding, writer);
    }

    public String render() throws IOException, TemplateRuntimeException {
        return this.render((Map)null);
    }

    public String render(Map binding) throws IOException, TemplateRuntimeException {
        StringWriter buffer = new StringWriter();
        this.render(buffer, binding);
        buffer.close();
        return buffer.toString();
    }
}

