/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.util.ArrayList;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEServerMBean;

public class J2EEServer
extends J2EEManagedObject
implements J2EEServerMBean {
    private List deployedObjectNames = new ArrayList();
    private List resourceNames = new ArrayList();
    private List mJVMs = new ArrayList();
    private String mServerVendor = null;
    private String mServerVersion = null;

    public J2EEServer(String pName, ObjectName pDomain, String pServerVendor, String pServerVersion) throws MalformedObjectNameException, InvalidParentException {
        super("J2EEServer", pName, pDomain);
        this.mServerVendor = pServerVendor;
        this.mServerVersion = pServerVersion;
    }

    public String[] getdeployedObjects() {
        String[] deployedObjects = new String[this.deployedObjectNames.size()];
        this.deployedObjectNames.toArray(deployedObjects);
        return deployedObjects;
    }

    public String getdeployedObject(int pIndex) {
        if (pIndex >= 0 && pIndex < this.deployedObjectNames.size()) {
            return (String)this.deployedObjectNames.get(pIndex);
        }
        return null;
    }

    public String[] getresources() {
        String[] resources = new String[this.resourceNames.size()];
        this.resourceNames.toArray(resources);
        return resources;
    }

    public String getresource(int pIndex) {
        if (pIndex >= 0 && pIndex < this.resourceNames.size()) {
            return (String)this.resourceNames.get(pIndex);
        }
        return null;
    }

    public String[] getjavaVMs() {
        String[] jvms = new String[this.mJVMs.size()];
        this.mJVMs.toArray(jvms);
        return jvms;
    }

    public String getjavaVM(int pIndex) {
        if (pIndex >= 0 && pIndex < this.mJVMs.size()) {
            return (String)this.mJVMs.get(pIndex);
        }
        return null;
    }

    public String getserverVendor() {
        return this.mServerVendor;
    }

    public String getserverVersion() {
        return this.mServerVersion;
    }

    public void addChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("J2EEApplication".equals(lType) || "EJBModule".equals(lType) || "ResourceAdapterModule".equals(lType) || "WebModule".equals(lType) || "ServiceModule".equals(lType)) {
            this.deployedObjectNames.add(pChild.getCanonicalName());
        } else if ("JVM".equals(lType)) {
            this.mJVMs.add(pChild.getCanonicalName());
        } else if ("JNDIResource".equals(lType) || "JMSResource".equals(lType) || "URLResource".equals(lType) || "JTAResource".equals(lType) || "JavaMailResource".equals(lType) || "JDBCResource".equals(lType) || "RMI_IIOPResource".equals(lType) || "JCAResource".equals(lType)) {
            this.resourceNames.add(pChild.getCanonicalName());
        }
    }

    public void removeChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("J2EEApplication".equals(lType) || "EJBModule".equals(lType) || "ResourceAdapterModule".equals(lType) || "WebModule".equals(lType) || "ServiceModule".equals(lType)) {
            this.deployedObjectNames.remove(pChild.getCanonicalName());
        } else if ("JVM".equals(lType)) {
            this.mJVMs.remove(pChild.getCanonicalName());
        } else if ("JNDIResource".equals(lType) || "JMSResource".equals(lType) || "URLResource".equals(lType) || "JTAResource".equals(lType) || "JavaMailResource".equals(lType) || "JDBCResource".equals(lType) || "RMI_IIOPResource".equals(lType) || "JCAResource".equals(lType)) {
            this.resourceNames.remove(pChild.getCanonicalName());
        }
    }

    public String toString() {
        return "J2EEServer { " + super.toString() + " } [ " + "depoyed objects: " + this.deployedObjectNames + ", resources: " + this.resourceNames + ", JVMs: " + this.mJVMs + ", J2EE vendor: " + this.mServerVendor + " ]";
    }
}

