/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.serialization;

import java.io.IOException;
import java.io.InputStream;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectWriter;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.serialization.SerializationSpoolFile;
import org.exoplatform.services.jcr.util.IdGenerator;

public class TransientValueDataWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ObjectWriter out, TransientValueData vd) throws IOException {
        out.writeInt(1);
        out.writeInt(vd.getOrderNumber());
        boolean isByteArray = vd.isByteArray();
        out.writeBoolean(isByteArray);
        if (isByteArray) {
            byte[] data = vd.getAsByteArray();
            int f = data.length;
            out.writeInt(f);
            out.write(data);
        } else {
            InputStream in = vd.getAsStream();
            if (vd.getSpoolFile() instanceof SerializationSpoolFile) {
                SerializationSpoolFile ssf = (SerializationSpoolFile)vd.getSpoolFile();
                out.writeString(ssf.getId());
                out.writeLong(0L);
            } else {
                String id = IdGenerator.generate();
                out.writeString(id);
                out.writeLong(vd.getLength());
                try {
                    byte[] buf = new byte[2048];
                    int l = 0;
                    while ((l = in.read(buf)) >= 0) {
                        out.write(buf, 0, l);
                    }
                }
                finally {
                    in.close();
                }
            }
        }
    }
}

