/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.init;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.DBInitializerException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DBInitializer {
    public static String SQL_DELIMITER = ";";
    public static String SQL_DELIMITER_COMMENT_PREFIX = "/*$DELIMITER:";
    public static String SQL_CREATETABLE = "^(CREATE(\\s)+TABLE(\\s)+(IF(\\s)+NOT(\\s)+EXISTS(\\s)+)*){1}";
    public static String SQL_CREATEVIEW = "^(CREATE(\\s)+VIEW(\\s)+(IF(\\s)+NOT(\\s)+EXISTS(\\s)+)*){1}";
    public static String SQL_OBJECTNAME = "((JCR_[A-Z_]+){1}(\\s*?|(\\(\\))*?)+)+?";
    public static String SQL_CREATEINDEX = "^(CREATE(\\s)+(UNIQUE(\\s)+)*INDEX(\\s)+){1}";
    public static String SQL_ONTABLENAME = "(ON(\\s)+(JCR_[A-Z_]+){1}(\\s*?|(\\(\\))*?)+){1}";
    public static String SQL_CREATESEQUENCE = "^(CREATE(\\s)+SEQUENCE(\\s)+){1}";
    public static String SQL_CREATETRIGGER = "^(CREATE(\\s)+(OR(\\s){1}REPLACE(\\s)+)*TRIGGER(\\s)+){1}";
    public static String SQL_TRIGGERNAME = "(([A-Z_]+JCR_[A-Z_]+){1}(\\s*?|(\\(\\))*?)+)+?";
    protected final Log log = ExoLogger.getLogger((String)"jcr.DBInitializer");
    protected final Connection connection;
    protected final String containerName;
    protected final String script;
    protected final boolean multiDb;
    protected final Pattern creatTablePattern;
    protected final Pattern creatViewPattern;
    protected final Pattern dbObjectNamePattern;
    protected final Pattern creatIndexPattern;
    protected final Pattern onTableNamePattern;
    protected final Pattern creatSequencePattern;
    protected final Pattern creatTriggerPattern;
    protected final Pattern dbTriggerNamePattern;

    public DBInitializer(String containerName, Connection connection, String scriptPath, boolean multiDb) throws IOException {
        this.connection = connection;
        this.containerName = containerName;
        this.script = this.script(scriptPath);
        this.multiDb = multiDb;
        this.creatTablePattern = Pattern.compile(SQL_CREATETABLE, 2);
        this.creatViewPattern = Pattern.compile(SQL_CREATEVIEW, 2);
        this.dbObjectNamePattern = Pattern.compile(SQL_OBJECTNAME, 2);
        this.creatIndexPattern = Pattern.compile(SQL_CREATEINDEX, 2);
        this.onTableNamePattern = Pattern.compile(SQL_ONTABLENAME, 2);
        this.creatSequencePattern = Pattern.compile(SQL_CREATESEQUENCE, 2);
        this.creatTriggerPattern = Pattern.compile(SQL_CREATETRIGGER, 2);
        this.dbTriggerNamePattern = Pattern.compile(SQL_TRIGGERNAME, 2);
    }

    protected String script(String scriptPath) throws IOException {
        return this.readScriptResource(scriptPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readScriptResource(String path) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(path);
        InputStreamReader isr = new InputStreamReader(is);
        try {
            StringBuilder sbuff = new StringBuilder();
            char[] buff = new char[is.available()];
            int r = 0;
            while ((r = isr.read(buff)) > 0) {
                sbuff.append(buff, 0, r);
            }
            String string = sbuff.toString();
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    public String cleanWhitespaces(String string) {
        if (string != null) {
            char[] cc = string.toCharArray();
            for (int ci = cc.length - 1; ci > 0; --ci) {
                if (!Character.isWhitespace(cc[ci])) continue;
                cc[ci] = 32;
            }
            return new String(cc);
        }
        return string;
    }

    protected boolean isTableExists(Connection conn, String tableName) throws SQLException {
        ResultSet trs = conn.getMetaData().getTables(null, null, tableName, null);
        boolean res = false;
        while (trs.next()) {
            res = true;
        }
        return res;
    }

    protected boolean isIndexExists(Connection conn, String tableName, String indexName) throws SQLException {
        ResultSet irs = conn.getMetaData().getIndexInfo(null, null, tableName, false, true);
        boolean res = false;
        while (irs.next()) {
            if (irs.getShort("TYPE") == 0 || !irs.getString("INDEX_NAME").equalsIgnoreCase(indexName)) continue;
            res = true;
        }
        return res;
    }

    protected boolean isSequenceExists(Connection conn, String sequenceName) throws SQLException {
        return false;
    }

    protected boolean isTriggerExists(Connection conn, String triggerName) throws SQLException {
        return false;
    }

    public boolean isObjectExists(Connection conn, String sql) throws SQLException {
        Matcher tMatcher = this.creatTablePattern.matcher(sql);
        if (tMatcher.find()) {
            String tableName;
            tMatcher = this.dbObjectNamePattern.matcher(sql);
            if (tMatcher.find() && this.isTableExists(conn, tableName = sql.substring(tMatcher.start(), tMatcher.end()))) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Table is already exists " + tableName));
                }
                return true;
            }
        } else {
            tMatcher = this.creatViewPattern.matcher(sql);
            if (tMatcher.find()) {
                String tableName;
                tMatcher = this.dbObjectNamePattern.matcher(sql);
                if (tMatcher.find() && this.isTableExists(conn, tableName = sql.substring(tMatcher.start(), tMatcher.end()))) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("View is already exists " + tableName));
                    }
                    return true;
                }
            } else {
                tMatcher = this.creatIndexPattern.matcher(sql);
                if (tMatcher.find()) {
                    tMatcher = this.dbObjectNamePattern.matcher(sql);
                    if (tMatcher.find()) {
                        String indexName = sql.substring(tMatcher.start(), tMatcher.end());
                        tMatcher = this.onTableNamePattern.matcher(sql);
                        if (tMatcher.find()) {
                            String onTableName = sql.substring(tMatcher.start(), tMatcher.end());
                            if ((tMatcher = this.dbObjectNamePattern.matcher(onTableName)).find()) {
                                String tableName = onTableName.substring(tMatcher.start(), tMatcher.end());
                                if (this.isIndexExists(conn, tableName, indexName)) {
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug((Object)("Index is already exists " + indexName));
                                    }
                                    return true;
                                }
                            } else {
                                this.log.warn((Object)("Index found but $TABLE_NAME is not detected '" + sql + "'"));
                            }
                        } else {
                            this.log.warn((Object)("Index found but ON $TABLE_NAME clause is not detected '" + sql + "'"));
                        }
                    } else {
                        this.log.warn((Object)("Create index clause found but $INDEX_NAME is not detected '" + sql + "'"));
                    }
                } else {
                    tMatcher = this.creatSequencePattern.matcher(sql);
                    if (tMatcher.find()) {
                        String sequenceName;
                        tMatcher = this.dbObjectNamePattern.matcher(sql);
                        if (tMatcher.find() && this.isSequenceExists(conn, sequenceName = sql.substring(tMatcher.start(), tMatcher.end()))) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Sequence is already exists " + sequenceName));
                            }
                            return true;
                        }
                    } else {
                        tMatcher = this.creatTriggerPattern.matcher(sql);
                        if (tMatcher.find()) {
                            String triggerName;
                            tMatcher = this.dbTriggerNamePattern.matcher(sql);
                            if (tMatcher.find() && this.isTriggerExists(conn, triggerName = sql.substring(tMatcher.start(), tMatcher.end()))) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)("Trigger is already exists " + triggerName));
                                }
                                return true;
                            }
                        } else if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Command is not detected for check '" + sql + "'"));
                        }
                    }
                }
            }
        }
        return false;
    }

    public void init() throws DBInitializerException {
        String[] scripts = null;
        if (this.script.startsWith(SQL_DELIMITER_COMMENT_PREFIX)) {
            try {
                String s = this.script.substring(SQL_DELIMITER_COMMENT_PREFIX.length());
                int endOfDelimIndex = s.indexOf("*/");
                String delim = s.substring(0, endOfDelimIndex).trim();
                s = s.substring(endOfDelimIndex + 2).trim();
                scripts = s.split(delim);
            }
            catch (IndexOutOfBoundsException e) {
                this.log.warn((Object)("Error of parse SQL-script file. Invalid DELIMITER configuration. Valid format is '" + SQL_DELIMITER_COMMENT_PREFIX + "XXX*/' at begin of the SQL-script file, where XXX - DELIMITER string." + " Spaces will be trimed. "), (Throwable)e);
                this.log.info((Object)("Using DELIMITER:[" + SQL_DELIMITER + "]"));
                scripts = this.script.split(SQL_DELIMITER);
            }
        } else {
            scripts = this.script.split(SQL_DELIMITER);
        }
        String sql = null;
        try {
            this.connection.setAutoCommit(false);
            for (String scr : scripts) {
                String s = this.cleanWhitespaces(scr.trim());
                if (s.length() <= 0 || this.isObjectExists(this.connection, sql = s)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Execute script: \n[" + sql + "]"));
                }
                this.connection.createStatement().executeUpdate(sql);
            }
            this.rootInit(this.connection);
            this.optionalInit();
            this.connection.commit();
            this.log.info((Object)("DB schema of DataSource: '" + this.containerName + "' initialized succesfully"));
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException re) {
                this.log.error((Object)("Rollback error " + e), (Throwable)e);
            }
            SQLException next = e.getNextException();
            String errorTrace = "";
            while (next != null) {
                errorTrace = errorTrace + next.getMessage() + "; ";
                next = e.getNextException();
            }
            Throwable cause = e.getCause();
            String msg = "Could not create db schema of DataSource: '" + this.containerName + "'. Reason: " + e.getMessage() + "; " + errorTrace + (cause != null ? " (Cause: " + cause.getMessage() + ")" : "") + ". Last command: " + sql;
            throw new DBInitializerException(msg, e);
        }
        finally {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                this.log.error((Object)("Error of a connection closing. " + e), (Throwable)e);
            }
        }
    }

    protected void optionalInit() throws DBInitializerException {
    }

    protected void rootInit(Connection connection) throws SQLException {
        String MDB = this.multiDb ? "M" : "S";
        String select = "select * from JCR_" + MDB + "ITEM where ID='" + Constants.ROOT_PARENT_UUID + "' and PARENT_ID='" + Constants.ROOT_PARENT_UUID + "'";
        if (!connection.createStatement().executeQuery(select).next()) {
            String insert = "insert into JCR_" + MDB + "ITEM(ID, PARENT_ID, NAME, " + (this.multiDb ? "" : "CONTAINER_NAME, ") + "VERSION, I_CLASS, I_INDEX, N_ORDER_NUM)" + " VALUES('" + Constants.ROOT_PARENT_UUID + "', '" + Constants.ROOT_PARENT_UUID + "', '__root_parent', " + (this.multiDb ? "" : "'__root_parent_container', ") + "0, 0, 0, 0)";
            connection.createStatement().executeUpdate(insert);
        }
    }
}

