/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private Map<String, String> groupTypeMappings = new HashMap<String, String>();
    private boolean useParentIdAsGroupType = false;
    private boolean passwordAsAttribute = false;
    private String defaultGroupType = "GTN_GROUP_TYPE";
    private String rootGroupName = "GTN_ROOT_GROUP";
    private String pathSeparator = ".";
    private boolean forceMembershipOfMappedTypes = false;

    public String getGroupType(String parentId) {
        if (parentId == null || parentId.length() == 0) {
            parentId = "/";
        }
        if (!this.useParentIdAsGroupType) {
            String type = this._getGroupType(parentId, true, true, true);
            if (type != null) {
                return type;
            }
            return this.getDefaultGroupType();
        }
        String type = this._getGroupType(parentId, false, true, true);
        if (type == null) {
            type = this._getGroupType(parentId, true, false, true);
        }
        if (type == null) {
            type = this.convertType(parentId);
        }
        return type;
    }

    private String _getGroupType(String parentId, boolean checkParents, boolean matchExact, boolean matchInherited) {
        String id;
        if (matchExact && this.getGroupTypeMappings().keySet().contains(parentId)) {
            return this.getGroupTypeMappings().get(parentId);
        }
        String string = id = !parentId.equals("/") ? parentId + "/*" : "/*";
        if (matchInherited && this.getGroupTypeMappings().keySet().contains(id)) {
            return this.getGroupTypeMappings().get(id);
        }
        if (checkParents && !parentId.equals("/") && parentId.contains("/")) {
            String newParentId = parentId.substring(0, parentId.lastIndexOf("/"));
            return this.getGroupType(newParentId);
        }
        return null;
    }

    public String getParentId(String type) {
        for (Map.Entry<String, String> entry : this.groupTypeMappings.entrySet()) {
            if (!entry.getValue().equals(type)) continue;
            return entry.getKey();
        }
        return null;
    }

    Set<String> getTypes(String id) {
        HashSet<String> types = new HashSet<String>();
        for (String key : this.groupTypeMappings.keySet()) {
            if (!key.startsWith("id")) continue;
            types.add(this.groupTypeMappings.get(key));
        }
        return types;
    }

    Set<String> getAllTypes() {
        HashSet<String> types = new HashSet<String>(this.groupTypeMappings.values());
        return types;
    }

    private String convertType(String type) {
        return type.replaceAll("/", this.pathSeparator);
    }

    public boolean isUseParentIdAsGroupType() {
        return this.useParentIdAsGroupType;
    }

    public void setUseParentIdAsGroupType(boolean useParentIdAsGroupType) {
        this.useParentIdAsGroupType = useParentIdAsGroupType;
    }

    public String getDefaultGroupType() {
        return this.defaultGroupType;
    }

    public void setDefaultGroupType(String defaultGroupType) {
        this.defaultGroupType = defaultGroupType;
    }

    public String getRootGroupName() {
        return this.rootGroupName;
    }

    public void setRootGroupName(String rootGroupName) {
        this.rootGroupName = rootGroupName;
    }

    public void setGroupTypeMappings(Map<String, String> groupTypeMappings) {
        this.groupTypeMappings = groupTypeMappings;
    }

    public Map<String, String> getGroupTypeMappings() {
        return this.groupTypeMappings;
    }

    public boolean isPasswordAsAttribute() {
        return this.passwordAsAttribute;
    }

    public void setPasswordAsAttribute(boolean passwordAsAttribute) {
        this.passwordAsAttribute = passwordAsAttribute;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public void setPathSeparator(String pathSeparator) {
        this.pathSeparator = pathSeparator;
    }

    public boolean isForceMembershipOfMappedTypes() {
        return this.forceMembershipOfMappedTypes;
    }

    public void setForceMembershipOfMappedTypes(boolean forceMembershipOfMappedTypes) {
        this.forceMembershipOfMappedTypes = forceMembershipOfMappedTypes;
    }
}

