/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.idm.ExtGroup;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.impl.api.SimpleAttribute;

public class GroupDAOImpl
implements GroupHandler {
    public static final String GROUP_LABEL = "label";
    public static final String GROUP_DESCRIPTION = "description";
    private PicketLinkIDMService service_;
    private List<GroupEventListener> listeners_;
    private PicketLinkIDMOrganizationServiceImpl orgService;

    public GroupDAOImpl(PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService service) {
        this.service_ = service;
        this.orgService = orgService;
        this.listeners_ = new ArrayList<GroupEventListener>();
    }

    public void addGroupEventListener(GroupEventListener listener) {
        this.listeners_.add(listener);
    }

    public final Group createGroupInstance() {
        return new ExtGroup();
    }

    public void createGroup(Group group, boolean broadcast) throws Exception {
        this.addChild(null, group, broadcast);
    }

    public void addChild(Group parent, Group child, boolean broadcast) throws Exception {
        org.picketlink.idm.api.Group parentGroup = null;
        if (parent != null) {
            parentGroup = this.getIdentitySession().getPersistenceManager().findGroup(parent.getGroupName(), this.orgService.getConfiguration().getGroupType(parent.getParentId()));
            ((ExtGroup)child).setId(parent.getId() + "/" + child.getGroupName());
        } else {
            ((ExtGroup)child).setId("/" + child.getGroupName());
        }
        if (broadcast) {
            this.preSave(child, true);
        }
        if (parentGroup != null) {
            ((ExtGroup)child).setParentId(parent.getId());
        }
        org.picketlink.idm.api.Group childGroup = this.persistGroup(child);
        if (parentGroup != null) {
            this.getIdentitySession().getRelationshipManager().associateGroups(parentGroup, childGroup);
        } else {
            this.getIdentitySession().getRelationshipManager().associateGroups(this.getRootGroup(), childGroup);
        }
        if (broadcast) {
            this.postSave(child, true);
        }
    }

    public void saveGroup(Group group, boolean broadcast) throws Exception {
        if (broadcast) {
            this.preSave(group, false);
        }
        this.persistGroup(group);
        if (broadcast) {
            this.postSave(group, false);
        }
    }

    public Group removeGroup(Group group, boolean broadcast) throws Exception {
        org.picketlink.idm.api.Group jbidGroup;
        if (broadcast) {
            this.preDelete(group);
        }
        if ((jbidGroup = this.getIdentitySession().getPersistenceManager().findGroup(group.getGroupName(), this.orgService.getConfiguration().getGroupType(group.getParentId()))) == null) {
            return group;
        }
        Collection oneLevelChilds = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, null, true, false);
        Collection allChilds = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, null, true, true);
        this.getIdentitySession().getRelationshipManager().disassociateGroups(jbidGroup, oneLevelChilds);
        for (org.picketlink.idm.api.Group child : allChilds) {
            this.getIdentitySession().getPersistenceManager().removeGroup(child, true);
        }
        this.getIdentitySession().getPersistenceManager().removeGroup(jbidGroup, true);
        if (broadcast) {
            this.postDelete(group);
        }
        return group;
    }

    public Collection findGroupByMembership(String userName, String membershipType) throws Exception {
        Collection allRoles = this.getIdentitySession().getRoleManager().findRoles(userName, membershipType);
        HashSet<Group> exoGroups = new HashSet<Group>();
        for (Role role : allRoles) {
            exoGroups.add(this.convertGroup(role.getGroup()));
        }
        return new LinkedList(exoGroups);
    }

    public Group findGroupById(String groupId) throws Exception {
        org.picketlink.idm.api.Group jbidGroup = this.orgService.getJBIDMGroup(groupId);
        if (jbidGroup == null) {
            return null;
        }
        return this.convertGroup(jbidGroup);
    }

    public Collection findGroups(Group parent) throws Exception {
        org.picketlink.idm.api.Group jbidGroup = null;
        jbidGroup = parent == null ? this.getRootGroup() : this.getIdentitySession().getPersistenceManager().findGroup(parent.getGroupName(), this.orgService.getConfiguration().getGroupType(parent.getParentId()));
        if (jbidGroup == null) {
            return Collections.emptyList();
        }
        String parentId = parent == null ? null : parent.getParentId();
        HashSet plGroups = new HashSet();
        plGroups.addAll(this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, null, true, false));
        if (this.orgService.getConfiguration().isForceMembershipOfMappedTypes()) {
            String id = parent != null ? parent.getId() : "/";
            for (String type : this.orgService.getConfiguration().getTypes(id)) {
                plGroups.addAll(this.getIdentitySession().getPersistenceManager().findGroup(type));
            }
        }
        HashSet<Group> exoGroups = new HashSet<Group>();
        for (org.picketlink.idm.api.Group group : plGroups) {
            exoGroups.add(this.convertGroup(group));
        }
        return new LinkedList(exoGroups);
    }

    public Collection findGroupsOfUser(String user) throws Exception {
        if (user == null) {
            return Collections.emptyList();
        }
        Collection allGroups = this.getIdentitySession().getRelationshipManager().findRelatedGroups(user, null, null);
        LinkedList<Group> exoGroups = new LinkedList<Group>();
        for (org.picketlink.idm.api.Group group : allGroups) {
            exoGroups.add(this.convertGroup(group));
        }
        return exoGroups;
    }

    public Collection getAllGroups() throws Exception {
        HashSet plGroups = new HashSet();
        plGroups.addAll(this.getIdentitySession().getRelationshipManager().findAssociatedGroups(this.getRootGroup(), null, true, true));
        if (this.orgService.getConfiguration().isForceMembershipOfMappedTypes()) {
            for (String type : this.orgService.getConfiguration().getAllTypes()) {
                plGroups.addAll(this.getIdentitySession().getPersistenceManager().findGroup(type));
            }
        }
        HashSet<Group> exoGroups = new HashSet<Group>();
        for (org.picketlink.idm.api.Group group : plGroups) {
            exoGroups.add(this.convertGroup(group));
        }
        return new LinkedList(exoGroups);
    }

    private void preSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.preSave(group, isNew);
        }
    }

    private void postSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.postSave(group, isNew);
        }
    }

    private void preDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.preDelete(group);
        }
    }

    private void postDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.postDelete(group);
        }
    }

    protected Group convertGroup(org.picketlink.idm.api.Group jbidGroup) throws Exception {
        Map attrs = this.getIdentitySession().getAttributesManager().getAttributes((IdentityType)jbidGroup);
        ExtGroup exoGroup = new ExtGroup(jbidGroup.getName());
        if (attrs.containsKey(GROUP_DESCRIPTION) && ((Attribute)attrs.get(GROUP_DESCRIPTION)).getValue() != null) {
            exoGroup.setDescription(((Attribute)attrs.get(GROUP_DESCRIPTION)).getValue().toString());
        }
        if (attrs.containsKey(GROUP_LABEL) && ((Attribute)attrs.get(GROUP_LABEL)).getValue() != null) {
            exoGroup.setLabel(((Attribute)attrs.get(GROUP_LABEL)).getValue().toString());
        }
        String id = this.getGroupId(jbidGroup);
        exoGroup.setId(id);
        if (id.length() == jbidGroup.getName().length() + 1) {
            exoGroup.setParentId(null);
        } else if (!id.equals("") && !id.equals("/")) {
            exoGroup.setParentId(id.substring(0, id.lastIndexOf("/")));
        }
        return exoGroup;
    }

    private String getGroupId(org.picketlink.idm.api.Group jbidGroup) throws Exception {
        if (jbidGroup.getName().equals(this.orgService.getConfiguration().getRootGroupName())) {
            return "";
        }
        Collection parents = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, null, false, false);
        if (parents.size() > 1) {
            throw new IllegalStateException("Group has more than one parent: " + jbidGroup.getName());
        }
        if (parents.size() == 0) {
            throw new IllegalStateException("Group present that is not connected to the root: " + jbidGroup.getName());
        }
        String parentGroupId = this.getGroupId((org.picketlink.idm.api.Group)parents.iterator().next());
        return parentGroupId + "/" + jbidGroup.getName();
    }

    private org.picketlink.idm.api.Group persistGroup(Group exoGroup) throws Exception {
        org.picketlink.idm.api.Group jbidGroup = this.getIdentitySession().getPersistenceManager().findGroup(exoGroup.getGroupName(), this.orgService.getConfiguration().getGroupType(exoGroup.getParentId()));
        if (jbidGroup == null) {
            jbidGroup = this.getIdentitySession().getPersistenceManager().createGroup(exoGroup.getGroupName(), this.orgService.getConfiguration().getGroupType(exoGroup.getParentId()));
        }
        String description = exoGroup.getDescription();
        String label = exoGroup.getLabel();
        ArrayList<SimpleAttribute> attrsList = new ArrayList<SimpleAttribute>();
        if (description != null) {
            attrsList.add(new SimpleAttribute(GROUP_DESCRIPTION, (Object)description));
        }
        if (label != null) {
            attrsList.add(new SimpleAttribute(GROUP_LABEL, (Object)label));
        }
        if (attrsList.size() > 0) {
            Attribute[] attrs = new Attribute[attrsList.size()];
            attrs = attrsList.toArray(attrs);
            this.getIdentitySession().getAttributesManager().updateAttributes((IdentityType)jbidGroup, attrs);
        }
        return jbidGroup;
    }

    private IdentitySession getIdentitySession() throws Exception {
        return this.service_.getIdentitySession();
    }

    private org.picketlink.idm.api.Group getRootGroup() throws Exception {
        org.picketlink.idm.api.Group rootGroup = this.getIdentitySession().getPersistenceManager().findGroup(this.orgService.getConfiguration().getRootGroupName(), this.orgService.getConfiguration().getGroupType("/"));
        if (rootGroup == null) {
            rootGroup = this.getIdentitySession().getPersistenceManager().createGroup(this.orgService.getConfiguration().getRootGroupName(), this.orgService.getConfiguration().getGroupType("/"));
        }
        return rootGroup;
    }
}

