/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.UserDAOImpl;
import org.exoplatform.services.organization.impl.UserProfileImpl;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.User;
import org.picketlink.idm.impl.api.SimpleAttribute;

public class UserProfileDAOImpl
implements UserProfileHandler {
    private static UserProfile NOT_FOUND = new UserProfileImpl();
    private PicketLinkIDMService service_;
    private ExoCache cache_;
    private List<UserProfileEventListener> listeners_;
    private PicketLinkIDMOrganizationServiceImpl orgService;

    public UserProfileDAOImpl(PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService service, CacheService cservice) throws Exception {
        this.service_ = service;
        this.cache_ = cservice.getCacheInstance(this.getClass().getName());
        this.listeners_ = new ArrayList<UserProfileEventListener>(3);
        this.orgService = orgService;
    }

    public void addUserProfileEventListener(UserProfileEventListener listener) {
        this.listeners_.add(listener);
    }

    public final UserProfile createUserProfileInstance() {
        return new UserProfileImpl();
    }

    public UserProfile createUserProfileInstance(String userName) {
        return new UserProfileImpl(userName);
    }

    public void saveUserProfile(UserProfile profile, boolean broadcast) throws Exception {
        if (broadcast) {
            this.preSave(profile, true);
        }
        this.setProfile(profile.getUserName(), profile);
        if (broadcast) {
            this.postSave(profile, true);
        }
        this.cache_.put((Serializable)((Object)profile.getUserName()), (Object)profile);
    }

    public UserProfile removeUserProfile(String userName, boolean broadcast) throws Exception {
        UserProfile profile = this.getProfile(userName);
        if (profile != null) {
            try {
                if (broadcast) {
                    this.preDelete(profile);
                }
                this.removeProfile(userName, profile);
                if (broadcast) {
                    this.postDelete(profile);
                }
                this.cache_.remove((Serializable)((Object)userName));
                return profile;
            }
            catch (Exception exp) {
                return null;
            }
        }
        this.cache_.remove((Serializable)((Object)userName));
        return null;
    }

    public UserProfile findUserProfileByName(String userName) throws Exception {
        User foundUser = this.getIdentitySession().getPersistenceManager().findUser(userName);
        if (foundUser == null) {
            return null;
        }
        UserProfile up = (UserProfile)this.cache_.get((Serializable)((Object)userName));
        if (up == null) {
            up = this.getProfile(userName);
        }
        if (up == null) {
            up = NOT_FOUND;
        }
        this.cache_.put((Serializable)((Object)userName), (Object)up);
        if (up == NOT_FOUND) {
            UserProfileImpl profile = new UserProfileImpl();
            profile.setUserName(userName);
            return profile;
        }
        return up;
    }

    public Collection findUserProfiles() throws Exception {
        return null;
    }

    private void preSave(UserProfile profile, boolean isNew) throws Exception {
        for (UserProfileEventListener listener : this.listeners_) {
            listener.preSave(profile, isNew);
        }
    }

    private void postSave(UserProfile profile, boolean isNew) throws Exception {
        for (UserProfileEventListener listener : this.listeners_) {
            listener.postSave(profile, isNew);
        }
    }

    private void preDelete(UserProfile profile) throws Exception {
        for (UserProfileEventListener listener : this.listeners_) {
            listener.preDelete(profile);
        }
    }

    private void postDelete(UserProfile profile) throws Exception {
        for (UserProfileEventListener listener : this.listeners_) {
            listener.postDelete(profile);
        }
    }

    public UserProfile getProfile(String userName) throws Exception {
        if (this.getIdentitySession().getPersistenceManager().findUser(userName) == null) {
            return null;
        }
        Map attrs = this.getIdentitySession().getAttributesManager().getAttributes(userName);
        if (attrs == null || attrs.isEmpty()) {
            return null;
        }
        HashMap<String, String> filteredAttrs = new HashMap<String, String>();
        for (String key : attrs.keySet()) {
            if (UserDAOImpl.USER_NON_PROFILE_KEYS.contains(key)) continue;
            filteredAttrs.put(key, ((Attribute)attrs.get(key)).getValue().toString());
        }
        if (filteredAttrs.isEmpty()) {
            return null;
        }
        UserProfileImpl profile = new UserProfileImpl(userName, filteredAttrs);
        return profile;
    }

    public void setProfile(String userName, UserProfile profile) throws Exception {
        Map profileAttrs = profile.getUserInfoMap();
        HashSet<SimpleAttribute> attrs = new HashSet<SimpleAttribute>();
        for (Map.Entry entry : profileAttrs.entrySet()) {
            attrs.add(new SimpleAttribute((String)entry.getKey(), entry.getValue()));
        }
        Attribute[] attrArray = new Attribute[attrs.size()];
        attrArray = attrs.toArray(attrArray);
        this.getIdentitySession().getAttributesManager().updateAttributes(userName, attrArray);
    }

    public void removeProfile(String userName, UserProfile profile) throws Exception {
        Map profileAttrs = profile.getUserInfoMap();
        String[] attrKeys = new String[profileAttrs.keySet().size()];
        attrKeys = profileAttrs.keySet().toArray(attrKeys);
        this.getIdentitySession().getAttributesManager().removeAttributes(userName, attrKeys);
    }

    private IdentitySession getIdentitySession() throws Exception {
        return this.service_.getIdentitySession();
    }
}

