/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.lindfors.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class StreamReaderThread
extends Thread {
    private transient Reader input = null;
    private transient boolean running = true;
    private int bufferSize = 1024;
    private boolean exitOnError = true;
    private boolean readStrings = false;
    protected int timeToLive = 500;

    public StreamReaderThread(Reader reader, int n) {
        this.setInputStream(reader);
        this.setBufferSize(n);
        this.setDaemon(true);
    }

    public StreamReaderThread(Reader reader) {
        this(reader, true);
    }

    public StreamReaderThread(Reader reader, boolean bl) {
        this.input = reader;
        if (bl) {
            this.setDaemon(true);
        }
    }

    public StreamReaderThread() {
        this.setDaemon(true);
        this.readStrings = true;
    }

    public void stopReading() {
        if (!this.isAlive()) {
            return;
        }
        this.setExitOnError(true);
        this.running = false;
        try {
            this.join(this.timeToLive);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.isAlive()) {
            this.interrupt();
        }
    }

    public void setExitOnError(boolean bl) {
        this.exitOnError = bl;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setInputStream(Reader reader) {
        this.input = reader;
    }

    public Reader getInputStream() {
        return this.input;
    }

    public void run() {
        BufferedReader bufferedReader = null;
        if (this.readStrings) {
            bufferedReader = new BufferedReader(this.input);
        }
        while (this.running) {
            try {
                int n;
                Object object;
                if (!this.readStrings) {
                    object = new char[this.bufferSize];
                    n = this.input.read((char[])object);
                    if (n < 0 && this.exitOnError) {
                        this.running = false;
                        continue;
                    }
                    if (n <= 0) continue;
                    this.handleInput((char[])object, n);
                    continue;
                }
                object = bufferedReader.readLine();
                if (object == null && this.exitOnError) {
                    this.running = false;
                    continue;
                }
                n = ((String)object).length();
                char[] cArray = new char[n];
                ((String)object).getChars(0, n, cArray, 0);
                this.handleInput(cArray, n);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                if (!this.exitOnError) continue;
                this.running = false;
            }
        }
        this.cleanup();
    }

    public void cleanup() {
    }

    public void handleIOException(IOException iOException) {
    }

    public void handleInput(char[] cArray, int n) {
    }
}

