/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application.replication.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.exoplatform.webui.application.replication.model.FieldModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeModel {
    private final Class<?> javaType;
    private final TypeModel superType;
    private final Map<String, FieldModel> fields;
    private final Map<String, FieldModel> immutableFields;

    TypeModel(Class<?> javaType, TypeModel superType, Map<String, FieldModel> fields) {
        this.javaType = javaType;
        this.superType = superType;
        this.fields = fields;
        this.immutableFields = Collections.unmodifiableMap(fields);
    }

    public Collection<FieldModel> getFields() {
        return this.immutableFields.values();
    }

    public Map<String, FieldModel> getFieldMap() {
        return this.immutableFields;
    }

    public String getName() {
        return this.javaType.getName();
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public TypeModel getSuperType() {
        return this.superType;
    }

    public String toString() {
        return "TypeModel[name=" + this.javaType.getName() + "]";
    }
}

