/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.Writer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIFormInputBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIFormTextAreaInput
extends UIFormInputBase<String> {
    private int rows = 10;
    private int columns = 30;

    public UIFormTextAreaInput(String name, String bindingExpression, String value) {
        super(name, bindingExpression, String.class);
        this.value_ = value;
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) throws Exception {
        String val = (String)input;
        this.value_ = val;
        if (this.value_ != null && ((String)this.value_).length() == 0) {
            this.value_ = null;
        }
    }

    @Override
    public void processRender(WebuiRequestContext context) throws Exception {
        Writer w = context.getWriter();
        String value = (String)this.getValue();
        if (value == null) {
            value = (String)this.getDefaultValue();
        }
        w.append("<textarea class='textarea' name='").append(this.getName()).append("' id='").append(this.getId()).append("'");
        if (this.readonly_) {
            w.write(" readonly ");
        }
        if (!this.enable_) {
            w.write(" disabled ");
        }
        w.append(" rows=\"").append(String.valueOf(this.rows)).append("\"");
        w.append(" cols=\"").append(String.valueOf(this.columns)).append("\"");
        w.write(">");
        if (value != null) {
            w.write(value);
        }
        w.write("</textarea>");
        if (this.isMandatory()) {
            w.write(" *");
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }
}

