/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy.ejb;

import java.util.List;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.invocation.InvokerHA;
import org.jboss.invocation.InvokerProxyHA;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;
import org.jboss.proxy.ejb.ClusterProxyFactory;
import org.jboss.proxy.ejb.ProxyFactory;
import org.jboss.system.Registry;

public class ProxyFactoryHA
extends ProxyFactory
implements DistributedReplicantManager.ReplicantListener,
ClusterProxyFactory {
    protected static Logger log = Logger.getLogger(ProxyFactory.class);
    protected String replicantName = null;
    protected InvokerHA jrmp;
    protected HATarget target;
    protected DistributedReplicantManager drm = null;

    public void create() throws Exception {
        super.create();
        AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
        filter.enableAttribute("State");
        this.container.getServer().addNotificationListener(this.container.getEjbModule().getServiceName(), new StateChangeListener(), (NotificationFilter)filter, null);
    }

    public void start() throws Exception {
        super.start();
    }

    protected void setupInvokers() throws Exception {
        String partitionName = this.container.getBeanMetaData().getClusterConfigMetaData().getPartitionName();
        InitialContext ctx = new InitialContext();
        HAPartition partition = (HAPartition)ctx.lookup("/HAPartition/" + partitionName);
        this.drm = partition.getDistributedReplicantManager();
        this.replicantName = this.jmxName.toString();
        ObjectName oname = new ObjectName(this.invokerMetaData.getInvokerMBean());
        this.jrmp = (InvokerHA)Registry.lookup((Object)oname);
        if (this.jrmp == null) {
            throw new RuntimeException("home JRMPInvokerHA is null: " + oname);
        }
        this.target = new HATarget(partition, this.replicantName, this.jrmp.getStub(), 1);
        this.jrmp.registerBean(this.jmxName, this.target);
        String clusterFamilyName = partitionName + "/" + this.jmxName + "/";
        this.drm.registerListener(this.replicantName, this);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = cl.loadClass(this.container.getBeanMetaData().getClusterConfigMetaData().getHomeLoadBalancePolicy());
        LoadBalancePolicy policy = (LoadBalancePolicy)clazz.newInstance();
        this.homeInvoker = this.jrmp.createProxy(this.jmxName, policy, clusterFamilyName + "H");
        String homeName = this.jndiBinding + "-HomeInvoker";
        log.debug((Object)("(re-)Binding Home invoker under: " + homeName));
        Util.rebind((Context)ctx, (String)homeName, (Object)this.homeInvoker);
        clazz = cl.loadClass(this.container.getBeanMetaData().getClusterConfigMetaData().getBeanLoadBalancePolicy());
        policy = (LoadBalancePolicy)clazz.newInstance();
        this.beanInvoker = this.jrmp.createProxy(this.jmxName, policy, clusterFamilyName + "R");
        String beanName = this.jndiBinding + "-RemoteInvoker";
        log.debug((Object)("(re-)Binding Remote invoker under: " + beanName));
        Util.rebind((Context)ctx, (String)beanName, (Object)this.beanInvoker);
    }

    public void destroy() {
        InitialContext ctx;
        super.destroy();
        try {
            this.jrmp.unregisterBean(this.jmxName);
            this.target.destroy();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            ctx = new InitialContext();
            String homeInvokerName = this.jndiBinding + "-HomeInvoker";
            ctx.unbind(homeInvokerName);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            ctx = new InitialContext();
            String beanInvokerName = this.jndiBinding + "-RemoteInvoker";
            ctx.unbind(beanInvokerName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.drm != null) {
            this.drm.unregisterListener(this.replicantName, this);
        }
    }

    protected void containerIsFullyStarted() {
        if (this.target != null) {
            this.target.setInvocationsAuthorization(2);
        }
    }

    protected void containerIsAboutToStop() {
        if (this.target != null) {
            this.target.setInvocationsAuthorization(0);
            this.target.disable();
        }
    }

    public synchronized void replicantsChanged(String key, List newReplicants, int newReplicantsViewId) {
        try {
            if (this.homeInvoker instanceof InvokerProxyHA) {
                ((InvokerProxyHA)this.homeInvoker).updateClusterInfo(this.target.getReplicants(), this.target.getCurrentViewId());
            }
            if (this.beanInvoker instanceof InvokerProxyHA) {
                ((InvokerProxyHA)this.beanInvoker).updateClusterInfo(this.target.getReplicants(), this.target.getCurrentViewId());
            }
            log.debug((Object)("Rebinding in JNDI... " + key));
            this.rebindHomeProxy();
        }
        catch (Exception none) {
            log.debug((Object)none);
        }
    }

    class StateChangeListener
    implements NotificationListener {
        StateChangeListener() {
        }

        public void handleNotification(Notification notification, Object handback) {
            if (notification instanceof AttributeChangeNotification) {
                AttributeChangeNotification notif = (AttributeChangeNotification)notification;
                int value = (Integer)notif.getNewValue();
                if (value == 3) {
                    log.debug((Object)"Container fully started: enabling HA-RMI access to bean");
                    ProxyFactoryHA.this.containerIsFullyStarted();
                } else if (value == 1) {
                    log.debug((Object)"Container about to stop: disabling HA-RMI access to bean");
                    ProxyFactoryHA.this.containerIsAboutToStop();
                }
            }
        }
    }
}

