/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.util.Calendar;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.SharedDataManager;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLInheritanceSupportedWorkspaceDataManager
implements SharedDataManager {
    private static Log log = ExoLogger.getLogger((String)"jcr.ACLInheritanceSupportedWorkspaceDataManager");
    protected final CacheableWorkspaceDataManager persistentManager;

    public ACLInheritanceSupportedWorkspaceDataManager(CacheableWorkspaceDataManager persistentManager) {
        this.persistentManager = persistentManager;
    }

    private AccessControlList getNearestACAncestorAcl(NodeData node) throws RepositoryException {
        if (node.getParentIdentifier() != null) {
            NodeData parent = (NodeData)this.getItemData(node.getParentIdentifier());
            while (parent != null) {
                if (parent.getACL() != null) {
                    return parent.getACL();
                }
                parent = (NodeData)this.getItemData(parent.getParentIdentifier());
            }
        }
        return new AccessControlList();
    }

    private ItemData initACL(NodeData parent, NodeData node) throws RepositoryException {
        if (node != null) {
            AccessControlList acl = node.getACL();
            if (acl == null) {
                if (parent != null) {
                    node.setACL(parent.getACL());
                } else {
                    node.setACL(this.getNearestACAncestorAcl(node));
                }
            } else if (!acl.hasPermissions()) {
                AccessControlList ancestorAcl = this.getNearestACAncestorAcl(node);
                node.setACL(new AccessControlList(acl.getOwner(), ancestorAcl.getPermissionEntries()));
            } else if (!acl.hasOwner()) {
                AccessControlList ancestorAcl = this.getNearestACAncestorAcl(node);
                node.setACL(new AccessControlList(ancestorAcl.getOwner(), acl.getPermissionEntries()));
            }
        }
        return node;
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException {
        List<NodeData> nodes = this.persistentManager.getChildNodesData(parent);
        for (NodeData node : nodes) {
            this.initACL(parent, node);
        }
        return nodes;
    }

    @Override
    public int getChildNodesCount(NodeData parent) throws RepositoryException {
        return this.persistentManager.getChildNodesCount(parent);
    }

    @Override
    public ItemData getItemData(NodeData parent, QPathEntry name) throws RepositoryException {
        ItemData item = this.persistentManager.getItemData(parent, name);
        return item != null && item.isNode() ? this.initACL(parent, (NodeData)item) : item;
    }

    @Override
    public ItemData getItemData(String identifier) throws RepositoryException {
        ItemData item = this.persistentManager.getItemData(identifier);
        return item != null && item.isNode() ? this.initACL(null, (NodeData)item) : item;
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException {
        return this.persistentManager.getChildPropertiesData(parent);
    }

    @Override
    public List<PropertyData> listChildPropertiesData(NodeData parent) throws RepositoryException {
        return this.persistentManager.listChildPropertiesData(parent);
    }

    @Override
    public List<PropertyData> getReferencesData(String identifier, boolean skipVersionStorage) throws RepositoryException {
        return this.persistentManager.getReferencesData(identifier, skipVersionStorage);
    }

    @Override
    public void save(ItemStateChangesLog changes) throws InvalidItemStateException, UnsupportedOperationException, RepositoryException {
        this.persistentManager.save(changes);
    }

    @Override
    public Calendar getCurrentTime() {
        return this.persistentManager.getCurrentTime();
    }
}

