/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.serialization;

import java.io.IOException;
import java.util.List;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectWriter;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.serialization.TransientValueDataWriter;

public class TransientPropertyDataWriter {
    public void write(ObjectWriter out, TransientPropertyData propData) throws IOException {
        out.writeInt(8);
        out.writeString(propData.getQPath().getAsString());
        out.writeString(propData.getIdentifier());
        if (propData.getParentIdentifier() != null) {
            out.writeByte((byte)1);
            out.writeString(propData.getParentIdentifier());
        } else {
            out.writeByte((byte)0);
        }
        out.writeInt(propData.getPersistedVersion());
        out.writeInt(propData.getType());
        out.writeBoolean(propData.isMultiValued());
        List<ValueData> values = propData.getValues();
        if (values != null) {
            out.writeByte((byte)1);
            int listSize = values.size();
            out.writeInt(listSize);
            TransientValueDataWriter wr = new TransientValueDataWriter();
            for (int i = 0; i < listSize; ++i) {
                wr.write(out, (TransientValueData)values.get(i));
            }
        } else {
            out.writeByte((byte)0);
        }
    }
}

