/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.common.util.Tools;
import org.gatein.pc.api.ActionURL;
import org.gatein.pc.api.ContainerURL;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.OpaqueStateString;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.PortletURL;
import org.gatein.pc.api.RenderURL;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.StatefulPortletContext;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPUtils;
import org.oasis.wsrp.v1.BlockingInteractionResponse;
import org.oasis.wsrp.v1.CacheControl;
import org.oasis.wsrp.v1.ClientData;
import org.oasis.wsrp.v1.ClonePortlet;
import org.oasis.wsrp.v1.DestroyFailed;
import org.oasis.wsrp.v1.DestroyPortlets;
import org.oasis.wsrp.v1.DestroyPortletsResponse;
import org.oasis.wsrp.v1.GetMarkup;
import org.oasis.wsrp.v1.GetPortletDescription;
import org.oasis.wsrp.v1.GetPortletProperties;
import org.oasis.wsrp.v1.GetPortletPropertyDescription;
import org.oasis.wsrp.v1.GetServiceDescription;
import org.oasis.wsrp.v1.InitCookie;
import org.oasis.wsrp.v1.InteractionParams;
import org.oasis.wsrp.v1.LocalizedString;
import org.oasis.wsrp.v1.MarkupContext;
import org.oasis.wsrp.v1.MarkupParams;
import org.oasis.wsrp.v1.MarkupResponse;
import org.oasis.wsrp.v1.MarkupType;
import org.oasis.wsrp.v1.ModelDescription;
import org.oasis.wsrp.v1.ModifyRegistration;
import org.oasis.wsrp.v1.PerformBlockingInteraction;
import org.oasis.wsrp.v1.PortletContext;
import org.oasis.wsrp.v1.PortletDescription;
import org.oasis.wsrp.v1.PortletDescriptionResponse;
import org.oasis.wsrp.v1.PortletPropertyDescriptionResponse;
import org.oasis.wsrp.v1.Property;
import org.oasis.wsrp.v1.PropertyDescription;
import org.oasis.wsrp.v1.PropertyList;
import org.oasis.wsrp.v1.RegistrationContext;
import org.oasis.wsrp.v1.RegistrationData;
import org.oasis.wsrp.v1.ReleaseSessions;
import org.oasis.wsrp.v1.ResetProperty;
import org.oasis.wsrp.v1.RuntimeContext;
import org.oasis.wsrp.v1.ServiceDescription;
import org.oasis.wsrp.v1.SessionContext;
import org.oasis.wsrp.v1.SetPortletProperties;
import org.oasis.wsrp.v1.StateChange;
import org.oasis.wsrp.v1.Templates;
import org.oasis.wsrp.v1.UpdateResponse;
import org.oasis.wsrp.v1.UploadContext;
import org.oasis.wsrp.v1.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPTypeFactory {
    private static final ActionURL ACTION_URL = new ActionURL(){

        public StateString getInteractionState() {
            return new OpaqueStateString("{wsrp-interactionState}");
        }

        public StateString getNavigationalState() {
            return new OpaqueStateString("{wsrp-navigationalState}");
        }

        public Mode getMode() {
            return Mode.create((String)"{wsrp-mode}", (boolean)true);
        }

        public WindowState getWindowState() {
            return WindowState.create((String)"{wsrp-windowState}", (boolean)true);
        }
    };
    private static final RenderURL RENDER_URL = new RenderURL(){

        public StateString getNavigationalState() {
            return new OpaqueStateString("{wsrp-navigationalState}");
        }

        public Map<String, String[]> getPublicNavigationalStateChanges() {
            return null;
        }

        public Mode getMode() {
            return Mode.create((String)"{wsrp-mode}", (boolean)true);
        }

        public WindowState getWindowState() {
            return WindowState.create((String)"{wsrp-windowState}", (boolean)true);
        }
    };

    private WSRPTypeFactory() {
    }

    public static GetServiceDescription createGetServiceDescription() {
        return new GetServiceDescription();
    }

    public static GetMarkup createDefaultMarkupRequest(String handle) {
        return WSRPTypeFactory.createMarkupRequest(WSRPTypeFactory.createPortletContext(handle), WSRPTypeFactory.createDefaultRuntimeContext(), WSRPTypeFactory.createDefaultMarkupParams());
    }

    public static GetMarkup createMarkupRequest(PortletContext portletContext, RuntimeContext runtimeContext, MarkupParams markupParams) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)runtimeContext, (String)"RuntimeContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)markupParams, (String)"MarkupParams");
        GetMarkup getMarkup = new GetMarkup();
        getMarkup.setPortletContext(portletContext);
        getMarkup.setRuntimeContext(runtimeContext);
        getMarkup.setMarkupParams(markupParams);
        return getMarkup;
    }

    public static PerformBlockingInteraction createDefaultPerformBlockingInteraction(String portletHandle) {
        return WSRPTypeFactory.createPerformBlockingInteraction(WSRPTypeFactory.createPortletContext(portletHandle), WSRPTypeFactory.createDefaultRuntimeContext(), WSRPTypeFactory.createDefaultMarkupParams(), WSRPTypeFactory.createDefaultInteractionParams());
    }

    public static PerformBlockingInteraction createPerformBlockingInteraction(PortletContext portletContext, RuntimeContext runtimeContext, MarkupParams markupParams, InteractionParams interactionParams) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletContext.getPortletHandle(), (String)"portlet handle", (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)runtimeContext, (String)"RuntimeContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)markupParams, (String)"MarkupParams");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)interactionParams, (String)"InteractionParams");
        PerformBlockingInteraction performBlockingInteraction = new PerformBlockingInteraction();
        performBlockingInteraction.setPortletContext(portletContext);
        performBlockingInteraction.setRuntimeContext(runtimeContext);
        performBlockingInteraction.setMarkupParams(markupParams);
        performBlockingInteraction.setInteractionParams(interactionParams);
        return performBlockingInteraction;
    }

    public static GetPortletDescription createGetPortletDescription(RegistrationContext registrationContext, String portletHandle) {
        GetPortletDescription description = new GetPortletDescription();
        description.setPortletContext(WSRPTypeFactory.createPortletContext(portletHandle));
        description.setRegistrationContext(registrationContext);
        return description;
    }

    public static GetPortletDescription createGetPortletDescription(RegistrationContext registrationContext, org.gatein.pc.api.PortletContext portletContext) {
        StatefulPortletContext context;
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"portlet context");
        PortletContext wsrpPC = WSRPTypeFactory.createPortletContext(portletContext.getId());
        if (portletContext instanceof StatefulPortletContext && PortletStateType.OPAQUE.equals((context = (StatefulPortletContext)portletContext).getType())) {
            wsrpPC.setPortletState((byte[])context.getState());
        }
        GetPortletDescription getPortletDescription = new GetPortletDescription();
        getPortletDescription.setRegistrationContext(registrationContext);
        getPortletDescription.setPortletContext(wsrpPC);
        return getPortletDescription;
    }

    public static GetPortletProperties createGetPortletProperties(RegistrationContext registrationContext, PortletContext portletContext) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        GetPortletProperties properties = new GetPortletProperties();
        properties.setRegistrationContext(registrationContext);
        properties.setPortletContext(portletContext);
        return properties;
    }

    public static BlockingInteractionResponse createBlockingInteractionResponse(UpdateResponse updateResponse) {
        if (updateResponse == null) {
            throw new IllegalArgumentException("BlockingInteractionResponse requires either an UpdateResponse or a redirect URL.");
        }
        BlockingInteractionResponse interactionResponse = new BlockingInteractionResponse();
        interactionResponse.setUpdateResponse(updateResponse);
        return interactionResponse;
    }

    public static BlockingInteractionResponse createBlockingInteractionResponse(String redirectURL) {
        if (redirectURL == null || redirectURL.length() == 0) {
            throw new IllegalArgumentException("BlockingInteractionResponse requires either an UpdateResponse or a redirect URL.");
        }
        BlockingInteractionResponse interactionResponse = new BlockingInteractionResponse();
        interactionResponse.setRedirectURL(redirectURL);
        return interactionResponse;
    }

    public static UpdateResponse createUpdateResponse() {
        return new UpdateResponse();
    }

    public static PortletDescription createPortletDescription(org.gatein.pc.api.PortletContext portletContext, List<MarkupType> markupTypes) {
        PortletContext context = WSRPUtils.convertToWSRPPortletContext(portletContext);
        ParameterValidation.throwIllegalArgExceptionIfNull(markupTypes, (String)"MarkupType");
        if (markupTypes.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a PortletDescription with an empty list of MarkupTypes!");
        }
        PortletDescription portletDescription = new PortletDescription();
        portletDescription.setPortletHandle(context.getPortletHandle());
        portletDescription.getMarkupTypes().addAll(markupTypes);
        return portletDescription;
    }

    private static void checkPortletHandle(String portletHandle) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletHandle, (String)"portlet handle", (String)"PortletDescription");
        if (portletHandle.length() > 255) {
            throw new IllegalArgumentException("Portlet handles must be less than 255 characters long. Was " + portletHandle.length() + " long.");
        }
    }

    public static MarkupParams createDefaultMarkupParams() {
        return WSRPTypeFactory.createMarkupParams(false, WSRPConstants.getDefaultLocales(), WSRPConstants.getDefaultMimeTypes(), "wsrp:view", "wsrp:normal");
    }

    public static MarkupParams createMarkupParams(boolean secureClientCommunication, List<String> locales, List<String> mimeTypes, String mode, String windowState) {
        ParameterValidation.throwIllegalArgExceptionIfNull(locales, (String)"locales");
        if (locales.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a MarkupParams with an empty list of locales!");
        }
        ParameterValidation.throwIllegalArgExceptionIfNull(mimeTypes, (String)"MIME types");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)mode, (String)"mode", (String)"MarkupParams");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)windowState, (String)"window state", (String)"MarkupParams");
        MarkupParams markupParams = new MarkupParams();
        markupParams.setSecureClientCommunication(secureClientCommunication);
        markupParams.setMode(mode);
        markupParams.setWindowState(windowState);
        if (ParameterValidation.existsAndIsNotEmpty(locales)) {
            markupParams.getLocales().addAll(locales);
        }
        if (ParameterValidation.existsAndIsNotEmpty(mimeTypes)) {
            markupParams.getMimeTypes().addAll(mimeTypes);
        }
        return markupParams;
    }

    public static RuntimeContext createDefaultRuntimeContext() {
        return WSRPTypeFactory.createRuntimeContext("wsrp:none");
    }

    public static RuntimeContext createRuntimeContext(String userAuthentication) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)userAuthentication, (String)"user authentication", (String)"RuntimeContext");
        RuntimeContext runtimeContext = new RuntimeContext();
        runtimeContext.setUserAuthentication(userAuthentication);
        return runtimeContext;
    }

    public static PortletContext createPortletContext(String portletHandle) {
        WSRPTypeFactory.checkPortletHandle(portletHandle);
        PortletContext portletContext = new PortletContext();
        portletContext.setPortletHandle(portletHandle);
        return portletContext;
    }

    public static PortletContext createPortletContext(String portletHandle, byte[] portletState) {
        PortletContext pc = WSRPTypeFactory.createPortletContext(portletHandle);
        pc.setPortletState(portletState);
        return pc;
    }

    public static InteractionParams createDefaultInteractionParams() {
        return WSRPTypeFactory.createInteractionParams(StateChange.READ_ONLY);
    }

    public static InteractionParams createInteractionParams(StateChange portletStateChange) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletStateChange, (String)"portletStateChange");
        InteractionParams interactionParams = new InteractionParams();
        interactionParams.setPortletStateChange(portletStateChange);
        return interactionParams;
    }

    public static InitCookie createInitCookie(RegistrationContext registrationContext) {
        InitCookie initCookie = new InitCookie();
        initCookie.setRegistrationContext(registrationContext);
        return initCookie;
    }

    public static ServiceDescription createServiceDescription(boolean requiresRegistration) {
        ServiceDescription serviceDescription = new ServiceDescription();
        serviceDescription.setRequiresRegistration(requiresRegistration);
        return serviceDescription;
    }

    public static MarkupResponse createMarkupResponse(MarkupContext markupContext) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)markupContext, (String)"MarkupContext");
        MarkupResponse markupResponse = new MarkupResponse();
        markupResponse.setMarkupContext(markupContext);
        return markupResponse;
    }

    public static MarkupContext createMarkupContext(String mediaType, String markupString) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)mediaType, (String)"Media type", (String)"MarkupContext");
        if (markupString == null) {
            throw new IllegalArgumentException("MarkupContext requires either a non-null markup string or binary markup.");
        }
        MarkupContext markupContext = new MarkupContext();
        markupContext.setMimeType(mediaType);
        markupContext.setMarkupString(markupString);
        return markupContext;
    }

    public static MarkupContext createMarkupContext(String mediaType, byte[] markupBinary) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)mediaType, (String)"MIME type", (String)"MarkupContext");
        if (markupBinary == null || markupBinary.length == 0) {
            throw new IllegalArgumentException("MarkupContext requires either a non-null markup string or binary markup.");
        }
        MarkupContext markupContext = new MarkupContext();
        markupContext.setMimeType(mediaType);
        markupContext.setMarkupBinary(markupBinary);
        return markupContext;
    }

    public static SessionContext createSessionContext(String sessionID, int expires) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)sessionID, (String)"session Id", (String)"SessionContext");
        if (expires < 0) {
            throw new IllegalArgumentException("SessionContext requires a positive expiration time.");
        }
        SessionContext sessionContext = new SessionContext();
        sessionContext.setSessionID(sessionID);
        sessionContext.setExpires(expires);
        return sessionContext;
    }

    public static UserContext createUserContext(String userContextKey) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)userContextKey, (String)"user context key", (String)"UserContext");
        UserContext userContext = new UserContext();
        userContext.setUserContextKey(userContextKey);
        return userContext;
    }

    public static RegistrationData createRegistrationData(String consumerName, boolean methodGetSupported) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerName, (String)"consumer name", (String)"RegistrationData");
        RegistrationData regData = WSRPTypeFactory.createDefaultRegistrationData();
        regData.setConsumerName(consumerName);
        regData.setMethodGetSupported(methodGetSupported);
        return regData;
    }

    public static RegistrationData createDefaultRegistrationData() {
        RegistrationData registrationData = new RegistrationData();
        registrationData.setConsumerName(WSRPConstants.DEFAULT_CONSUMER_NAME);
        registrationData.setConsumerAgent(WSRPConstants.CONSUMER_AGENT);
        registrationData.setMethodGetSupported(false);
        return registrationData;
    }

    public static Property createProperty(String name, String lang, String stringValue) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"name", (String)"Property");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)lang, (String)"language", (String)"Property");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)stringValue, (String)"String value", (String)"Property");
        Property property = new Property();
        property.setName(name);
        property.setLang(lang);
        property.setStringValue(stringValue);
        return property;
    }

    public static Templates createTemplates(PortletInvocationContext context) {
        Templates templates = new Templates();
        templates.setBlockingActionTemplate(WSRPTypeFactory.createTemplate(context, (PortletURL)ACTION_URL, Boolean.FALSE));
        templates.setRenderTemplate(WSRPTypeFactory.createTemplate(context, (PortletURL)RENDER_URL, Boolean.FALSE));
        templates.setSecureBlockingActionTemplate(WSRPTypeFactory.createTemplate(context, (PortletURL)ACTION_URL, Boolean.TRUE));
        templates.setSecureRenderTemplate(WSRPTypeFactory.createTemplate(context, (PortletURL)RENDER_URL, Boolean.TRUE));
        templates.setResourceTemplate("JBP_RES_REW={wsrp-url}JBP_REQ_REW{wsrp-requiresRewrite}");
        templates.setSecureResourceTemplate("JBP_RES_REW={wsrp-url}JBP_REQ_REW{wsrp-requiresRewrite}");
        return templates;
    }

    private static String createTemplate(PortletInvocationContext context, PortletURL url, Boolean secure) {
        String template = context.renderURL((ContainerURL)url, new URLFormat(secure, null, null, Boolean.valueOf(true)));
        template = Tools.replace((String)template, (String)"%7B", (String)"{");
        template = Tools.replace((String)template, (String)"%7D", (String)"}");
        return template;
    }

    public static ClientData createClientData(String userAgent) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)userAgent, (String)"user agent", (String)"ClientData");
        ClientData clientData = new ClientData();
        clientData.setUserAgent(userAgent);
        return clientData;
    }

    public static CacheControl createCacheControl(int expires, String userScope) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)userScope, (String)"user scope", (String)"CacheControl");
        if (expires < -1) {
            throw new IllegalArgumentException("Cache expiration time must be greater than -1, -1 indicating that the cache will never expire.");
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setExpires(expires);
        cacheControl.setUserScope(userScope);
        return cacheControl;
    }

    public static RegistrationContext createRegistrationContext(String registrationHandle) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)registrationHandle, (String)"Registration handle");
        RegistrationContext registrationContext = new RegistrationContext();
        registrationContext.setRegistrationHandle(registrationHandle);
        return registrationContext;
    }

    public static ModelDescription createModelDescription(List<PropertyDescription> propertyDescriptions) {
        ModelDescription description = new ModelDescription();
        if (ParameterValidation.existsAndIsNotEmpty(propertyDescriptions)) {
            description.getPropertyDescriptions().addAll(propertyDescriptions);
        }
        return description;
    }

    public static PropertyDescription createPropertyDescription(String name, QName type) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"PropertyDescription name");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)type, (String)"PropertyDescription type");
        PropertyDescription description = new PropertyDescription();
        description.setName(name);
        description.setType(type);
        return description;
    }

    public static LocalizedString createLocalizedString(String lang, String resourceName, String value) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)lang, (String)"LocalizedString language");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)value, (String)"LocalizedString value");
        LocalizedString localizedString = new LocalizedString();
        localizedString.setLang(lang);
        localizedString.setResourceName(resourceName);
        localizedString.setValue(value);
        return localizedString;
    }

    public static LocalizedString createLocalizedString(String value) {
        return WSRPTypeFactory.createLocalizedString("en", null, value);
    }

    public static PortletDescriptionResponse createPortletDescriptionResponse(PortletDescription portletDescription) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletDescription, (String)"PortletDescription");
        PortletDescriptionResponse response = new PortletDescriptionResponse();
        response.setPortletDescription(portletDescription);
        return response;
    }

    public static PortletPropertyDescriptionResponse createPortletPropertyDescriptionResponse(List<PropertyDescription> propertyDescriptions) {
        ModelDescription modelDescription = propertyDescriptions == null ? null : WSRPTypeFactory.createModelDescription(propertyDescriptions);
        PortletPropertyDescriptionResponse portletPropertyDescriptionResponse = new PortletPropertyDescriptionResponse();
        portletPropertyDescriptionResponse.setModelDescription(modelDescription);
        return portletPropertyDescriptionResponse;
    }

    public static GetPortletPropertyDescription createGetPortletPropertyDescription(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, List<String> desiredLocales) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        GetPortletPropertyDescription description = new GetPortletPropertyDescription();
        description.setRegistrationContext(registrationContext);
        description.setPortletContext(portletContext);
        description.setUserContext(userContext);
        if (ParameterValidation.existsAndIsNotEmpty(desiredLocales)) {
            description.getDesiredLocales().addAll(desiredLocales);
        }
        return description;
    }

    public static GetPortletPropertyDescription createSimpleGetPortletPropertyDescription(String portletHandle) {
        return WSRPTypeFactory.createGetPortletPropertyDescription(null, WSRPTypeFactory.createPortletContext(portletHandle), null, null);
    }

    public static DestroyFailed createDestroyFailed(String portletHandle, String reason) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletHandle, (String)"Portlet handle", (String)"DestroyFailed");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)reason, (String)"Reason for failure", (String)"DestroyFailed");
        DestroyFailed destroyFailed = new DestroyFailed();
        destroyFailed.setPortletHandle(portletHandle);
        destroyFailed.setReason(reason);
        return destroyFailed;
    }

    public static DestroyPortletsResponse createDestroyPortletsResponse(List<DestroyFailed> destroyFailed) {
        DestroyPortletsResponse destroyPortletsResponse = new DestroyPortletsResponse();
        if (ParameterValidation.existsAndIsNotEmpty(destroyFailed)) {
            destroyPortletsResponse.getDestroyFailed().addAll(destroyFailed);
        }
        return destroyPortletsResponse;
    }

    public static SetPortletProperties createSetPortletProperties(RegistrationContext registrationContext, PortletContext portletContext, PropertyList propertyList) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyList, (String)"PropertyList");
        SetPortletProperties properties = new SetPortletProperties();
        properties.setRegistrationContext(registrationContext);
        properties.setPortletContext(portletContext);
        properties.setPropertyList(propertyList);
        return properties;
    }

    public static ClonePortlet createSimpleClonePortlet(String portletHandle) {
        return WSRPTypeFactory.createClonePortlet(null, WSRPTypeFactory.createPortletContext(portletHandle), null);
    }

    public static ClonePortlet createClonePortlet(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        ClonePortlet clonePortlet = new ClonePortlet();
        clonePortlet.setPortletContext(portletContext);
        clonePortlet.setRegistrationContext(registrationContext);
        clonePortlet.setUserContext(userContext);
        return clonePortlet;
    }

    public static DestroyPortlets createDestroyPortlets(RegistrationContext registrationContext, List<String> portletHandles) {
        ParameterValidation.throwIllegalArgExceptionIfNull(portletHandles, (String)"Portlet handles");
        if (portletHandles.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a DestroyPortlets with an empty list of portlet handles!");
        }
        DestroyPortlets destroyPortlets = new DestroyPortlets();
        destroyPortlets.setRegistrationContext(registrationContext);
        if (ParameterValidation.existsAndIsNotEmpty(portletHandles)) {
            destroyPortlets.getPortletHandles().addAll(portletHandles);
        }
        return destroyPortlets;
    }

    public static PropertyList createPropertyList() {
        return new PropertyList();
    }

    public static ResetProperty createResetProperty(String name) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"Property name", (String)"ResetProperty");
        ResetProperty resetProperty = new ResetProperty();
        resetProperty.setName(name);
        return resetProperty;
    }

    public static ReleaseSessions createReleaseSessions(RegistrationContext registrationContext, List<String> sessionIDs) {
        ParameterValidation.throwIllegalArgExceptionIfNull(sessionIDs, (String)"Session IDs");
        if (sessionIDs.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a ReleaseSessions with an empty list of session IDs!");
        }
        ReleaseSessions sessions = new ReleaseSessions();
        sessions.setRegistrationContext(registrationContext);
        if (ParameterValidation.existsAndIsNotEmpty(sessionIDs)) {
            sessions.getSessionIDs().addAll(sessionIDs);
        }
        return sessions;
    }

    public static ModifyRegistration createModifyRegistration(RegistrationContext registrationContext, RegistrationData registrationData) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)registrationData, (String)"RegistrationData");
        ModifyRegistration registration = new ModifyRegistration();
        registration.setRegistrationContext(registrationContext);
        registration.setRegistrationData(registrationData);
        return registration;
    }

    public static UploadContext createUploadContext(String mimeType, byte[] uploadData) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)mimeType, (String)"MIME Type", (String)"UploadContext");
        if (uploadData == null || uploadData.length == 0) {
            throw new IllegalArgumentException("Must pass non-null, non-empty upload data");
        }
        UploadContext uploadContext = new UploadContext();
        uploadContext.setMimeType(mimeType);
        uploadContext.setUploadData(uploadData);
        return uploadContext;
    }

    public static MarkupType createMarkupType(String mimeType, List<String> modeNames, List<String> windowStateNames, List<String> localeNames) {
        MarkupType markupType = new MarkupType();
        markupType.setMimeType(mimeType);
        if (ParameterValidation.existsAndIsNotEmpty(modeNames)) {
            markupType.getModes().addAll(modeNames);
        }
        if (ParameterValidation.existsAndIsNotEmpty(windowStateNames)) {
            markupType.getWindowStates().addAll(windowStateNames);
        }
        if (ParameterValidation.existsAndIsNotEmpty(localeNames)) {
            markupType.getLocales().addAll(localeNames);
        }
        return markupType;
    }
}

