/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer;

import javax.servlet.http.HttpServletRequest;
import org.gatein.common.net.URLTools;

public class AbsoluteURLReplacementGenerator
extends URLTools.URLReplacementGenerator {
    private String serverAddress;
    public static final String SCH_END = "://";
    public static final String PORT_END = ":";
    public static final String SLASH = "/";

    public AbsoluteURLReplacementGenerator(HttpServletRequest request) {
        String scheme = request.getScheme();
        String host = request.getServerName();
        int port = request.getServerPort();
        this.serverAddress = scheme + SCH_END + host + PORT_END + port;
    }

    public String getReplacementFor(int i, URLTools.URLMatch urlMatch) {
        return this.getAbsoluteURLFor(urlMatch.getURLAsString());
    }

    public String getAbsoluteURLFor(String url) {
        return this.getAbsoluteURLFor(url, true);
    }

    String getAbsoluteURLFor(String url, boolean checkWSRPToken) {
        if (checkWSRPToken && url.startsWith("wsrp_rewrite?")) {
            return url;
        }
        if (!URLTools.isNetworkURL((String)url) && url.startsWith(SLASH)) {
            return this.serverAddress + url;
        }
        return url;
    }
}

