/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer;

import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.StateEvent;
import org.gatein.pc.api.StatefulPortletContext;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.state.AccessMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WSRPInstanceContext
implements InstanceContext {
    private PortletContext context;
    private String instanceId;
    private final AccessMode accessMode;
    private boolean wasModified = false;

    public WSRPInstanceContext(PortletContext portletContext, AccessMode accessMode, String instanceId) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"portlet context");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)accessMode, (String)"AccessMode");
        this.context = portletContext;
        this.accessMode = accessMode;
        this.instanceId = instanceId != null && instanceId.length() > 0 ? instanceId : portletContext.getId();
    }

    public String getId() {
        return this.instanceId;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public void onStateEvent(StateEvent event) {
        PortletContext portletContext = event.getPortletContext();
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        this.wasModified = true;
        this.context = portletContext;
    }

    public boolean wasModified() {
        return this.wasModified;
    }

    public PortletContext getPortletContext() {
        return this.context;
    }

    public PortletStateType<?> getStateType() {
        if (this.context instanceof StatefulPortletContext) {
            StatefulPortletContext spc = (StatefulPortletContext)this.context;
            return spc.getType();
        }
        return PortletStateType.OPAQUE;
    }
}

