/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Timeout;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.annotation.ejb.Clustered;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.annotation.ejb.RemoteBindingImpl;
import org.jboss.annotation.ejb.RemoteBindings;
import org.jboss.annotation.ejb.RemoteBindingsImpl;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassContainer;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.annotation.AnnotationElement;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.util.MethodHashing;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.InitialContextFactory;
import org.jboss.ejb3.Pool;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.ThreadLocalENCFactory;
import org.jboss.ejb3.entity.PersistenceUnitDeployment;
import org.jboss.ejb3.interceptor.InterceptorInfo;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.interceptor.InterceptorInjector;
import org.jboss.ejb3.interceptor.LifecycleInterceptorHandler;
import org.jboss.ejb3.metamodel.AssemblyDescriptor;
import org.jboss.ejb3.metamodel.EnterpriseBean;
import org.jboss.ejb3.security.JaccHelper;
import org.jboss.ejb3.statistics.InvocationStatistics;
import org.jboss.ejb3.tx.UserTransactionImpl;
import org.jboss.injection.DependsHandler;
import org.jboss.injection.EJBHandler;
import org.jboss.injection.EncInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.injection.JndiInjectHandler;
import org.jboss.injection.PersistenceContextHandler;
import org.jboss.injection.PersistenceUnitHandler;
import org.jboss.injection.ResourceHandler;
import org.jboss.injection.WebServiceRefHandler;
import org.jboss.logging.Logger;
import org.jboss.metamodel.descriptor.EnvironmentRefGroup;
import org.jboss.naming.Util;
import org.jboss.util.StringPropertyReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EJBContainer
extends ClassContainer
implements Container,
InjectionContainer {
    private static final Logger log = Logger.getLogger(EJBContainer.class);
    protected Pool pool;
    protected String ejbName;
    protected ObjectName objectName;
    protected int defaultConstructorIndex;
    protected String beanClassName;
    protected ClassLoader classloader;
    protected List<Injector> injectors = new ArrayList<Injector>();
    protected Context enc;
    protected Class beanContextClass;
    protected LifecycleInterceptorHandler callbackHandler;
    protected Hashtable initialContextProperties;
    protected Map<String, EncInjector> encInjectors = new HashMap<String, EncInjector>();
    protected EnterpriseBean xml;
    protected AssemblyDescriptor assembly;
    protected Map<String, Map<AccessibleObject, Injector>> encInjections = new HashMap<String, Map<AccessibleObject, Injector>>();
    protected InterceptorInfoRepository interceptorRepository;
    protected List<InterceptorInfo> classInterceptors = new ArrayList<InterceptorInfo>();
    protected LinkedHashSet<InterceptorInfo> applicableInterceptors;
    private HashMap<Class, InterceptorInjector> interceptorInjectors = new HashMap();
    private Ejb3Deployment deployment;
    private DependencyPolicy dependencyPolicy;
    private String jaccContextId;
    protected HashMap invokedMethod = new HashMap();
    protected InvocationStatistics invokeStats = new InvocationStatistics();
    private String partitionName;
    public static final String MANAGED_ENTITY_MANAGER_FACTORY = "ManagedEntityManagerFactory";
    public static final String ENTITY_MANAGER_FACTORY = "EntityManagerFactory";

    public EJBContainer(String name, AspectManager manager, ClassLoader cl, String beanClassName, String ejbName, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment) {
        super(name, manager);
        this.deployment = deployment;
        this.beanClassName = beanClassName;
        this.classloader = cl;
        super.setChainOverridingForInheritedMethods(true);
        try {
            this.clazz = this.classloader.loadClass(beanClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.ejbName = ejbName;
        String on = "jboss.j2ee:service=EJB3," + this.getDeploymentQualifiedName();
        try {
            this.objectName = new ObjectName(on);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("failed to create object name for: " + on, e);
        }
        this.initialContextProperties = ctxProperties;
        InitialContext ctx = this.getInitialContext();
        try {
            this.enc = ThreadLocalENCFactory.create(ctx);
            Util.createSubcontext(this.enc, "env");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.interceptorRepository = interceptorRepository;
        this.interceptorRepository.addBeanClass(this.clazz.getName());
    }

    public void pushEnc() {
        ThreadLocalENCFactory.push(this.enc);
    }

    public void popEnc() {
        ThreadLocalENCFactory.pop();
    }

    @Override
    public EnvironmentRefGroup getEnvironmentRefGroup() {
        return this.xml;
    }

    @Override
    public List<Injector> getInjectors() {
        return this.injectors;
    }

    public String getJaccContextId() {
        return this.jaccContextId;
    }

    public void setJaccContextId(String jaccContextId) {
        this.jaccContextId = jaccContextId;
    }

    public String getDeploymentQualifiedName() {
        DeploymentScope ear = this.deployment.getEar();
        DeploymentUnit unit = this.deployment.getDeploymentUnit();
        StringBuilder sb = new StringBuilder();
        if (ear != null) {
            sb.append("ear=");
            sb.append(ear.getShortName());
            sb.append(",");
        }
        sb.append("jar=");
        sb.append(unit.getShortName());
        sb.append(",name=");
        sb.append(this.getEjbName());
        return sb.toString();
    }

    public DeploymentUnit getDeploymentUnit() {
        return this.deployment.getDeploymentUnit();
    }

    public Ejb3Deployment getDeployment() {
        return this.deployment;
    }

    @Override
    public DependencyPolicy getDependencyPolicy() {
        return this.dependencyPolicy;
    }

    public void instantiated() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMetadata(DependencyPolicy dependencyPolicy) {
        this.dependencyPolicy = dependencyPolicy;
        ArrayList<InjectionHandler> handlers = new ArrayList<InjectionHandler>();
        handlers.add(new EJBHandler());
        handlers.add(new DependsHandler());
        handlers.add(new JndiInjectHandler());
        handlers.add(new PersistenceContextHandler());
        handlers.add(new PersistenceUnitHandler());
        handlers.add(new ResourceHandler());
        handlers.add(new WebServiceRefHandler());
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classloader);
        try {
            for (InjectionHandler handler : handlers) {
                handler.loadXml(this.xml, this);
            }
            Map<AccessibleObject, Injector> tmp = InjectionUtil.processAnnotations(this, handlers, this.getBeanClass());
            this.injectors.addAll(tmp.values());
            this.initialiseInterceptors();
            for (InterceptorInfo interceptorInfo : this.applicableInterceptors) {
                for (InjectionHandler handler : handlers) {
                    handler.loadXml(interceptorInfo.getXml(), this);
                }
            }
            for (InterceptorInfo interceptorInfo : this.applicableInterceptors) {
                Map<AccessibleObject, Injector> tmpInterceptor = InjectionUtil.processAnnotations(this, handlers, interceptorInfo.getClazz());
                InterceptorInjector injector = new InterceptorInjector((Container)this, interceptorInfo, tmpInterceptor);
                this.interceptorInjectors.put(interceptorInfo.getClazz(), injector);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public EnterpriseBean getXml() {
        return this.xml;
    }

    public void setXml(EnterpriseBean xml) {
        this.xml = xml;
    }

    public AssemblyDescriptor getAssemblyDescriptor() {
        return this.assembly;
    }

    public void setAssemblyDescriptor(AssemblyDescriptor assembly) {
        this.assembly = assembly;
    }

    public InterceptorInfoRepository getInterceptorRepository() {
        return this.interceptorRepository;
    }

    public List<InterceptorInfo> getClassInterceptors() {
        this.initialiseInterceptors();
        return this.classInterceptors;
    }

    public HashSet<InterceptorInfo> getApplicableInterceptors() {
        this.initialiseInterceptors();
        return this.applicableInterceptors;
    }

    public HashMap<Class, InterceptorInjector> getInterceptorInjectors() {
        this.initialiseInterceptors();
        return this.interceptorInjectors;
    }

    @Override
    public Map<String, EncInjector> getEncInjectors() {
        return this.encInjectors;
    }

    @Override
    public ClassLoader getClassloader() {
        return this.classloader;
    }

    @Override
    public InitialContext getInitialContext() {
        try {
            return InitialContextFactory.getInitialContext(this.initialContextProperties);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Map<AccessibleObject, Injector>> getEncInjections() {
        return this.encInjections;
    }

    @Override
    public Context getEnc() {
        return this.enc;
    }

    @Override
    public Hashtable getInitialContextProperties() {
        return this.initialContextProperties;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public String getEjbName() {
        return this.ejbName;
    }

    public String getBeanClassName() {
        return this.beanClassName;
    }

    @Override
    public Class getBeanClass() {
        return this.clazz;
    }

    @Override
    public Pool getPool() {
        return this.pool;
    }

    public String getPartitionName() {
        if (this.partitionName == null) {
            this.findPartitionName();
        }
        return this.partitionName;
    }

    @Override
    public Object construct() {
        Interceptor[] cInterceptors = this.constructorInterceptors[this.defaultConstructorIndex];
        if (cInterceptors == null) {
            try {
                return this.constructors[this.defaultConstructorIndex].newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        ConstructorInvocation invocation = new ConstructorInvocation(cInterceptors);
        invocation.setAdvisor((Advisor)((Object)this));
        invocation.setConstructor(this.constructors[this.defaultConstructorIndex]);
        try {
            return invocation.invokeNext();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public void create() throws Exception {
        this.initializeClassContainer();
        for (int i = 0; i < this.constructors.length; ++i) {
            if (this.constructors[i].getParameterTypes().length != 0) continue;
            this.defaultConstructorIndex = i;
            break;
        }
    }

    @Override
    public void start() throws Exception {
        this.initializePool();
        for (EncInjector injector : this.encInjectors.values()) {
            injector.inject(this);
        }
        Injector[] injectors2 = this.injectors.toArray(new Injector[this.injectors.size()]);
        if (this.pool != null) {
            this.pool.setInjectors(injectors2);
        }
        this.createCallbackHandler();
        JaccHelper.configureContainer((String)this.jaccContextId, (EJBContainer)this);
        this.findPartitionName();
        log.info("STARTED EJB: " + this.clazz.getName() + " ejbName: " + this.ejbName);
    }

    @Override
    public void stop() throws Exception {
        if (this.pool != null) {
            this.pool.destroy();
            this.pool = null;
        }
        log.info("STOPPED EJB: " + this.clazz.getName() + " ejbName: " + this.ejbName);
    }

    @Override
    public void destroy() throws Exception {
        super.cleanup();
    }

    protected void initializePool() throws Exception {
        PoolClass poolClass = (PoolClass)this.resolveAnnotation(PoolClass.class);
        Class poolClazz = poolClass.value();
        int maxSize = poolClass.maxSize();
        long timeout = poolClass.timeout();
        this.pool = (Pool)poolClazz.newInstance();
        this.pool.initialize((Container)this, this.beanContextClass, this.clazz, maxSize, timeout);
        this.resolveInjectors();
        this.pool.setInjectors(this.injectors.toArray(new Injector[this.injectors.size()]));
    }

    @Override
    public void invokePostConstruct(BeanContext beanContext) {
        this.callbackHandler.postConstruct(beanContext);
    }

    @Override
    public void invokePreDestroy(BeanContext beanContext) {
        this.callbackHandler.preDestroy(beanContext);
    }

    @Override
    public void invokePostActivate(BeanContext beanContext) {
        throw new RuntimeException("PostActivate not implemented for container");
    }

    @Override
    public void invokePrePassivate(BeanContext beanContext) {
        throw new RuntimeException("PrePassivate not implemented for container");
    }

    @Override
    public void invokeInit(Object bean) {
    }

    @Override
    public void invokeInit(Object bean, Class[] initParameterTypes, Object[] initParameterValues) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveInjectors() throws Exception {
        this.pushEnc();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            try {
                Util.rebind(this.getEnc(), "UserTransaction", (Object)new UserTransactionImpl());
            }
            catch (NamingException e) {
                NamingException namingException = new NamingException("Could not bind user transaction for ejb name " + this.ejbName + " into JNDI under jndiName: " + this.getEnc().getNameInNamespace() + "/" + "UserTransaction");
                namingException.setRootCause(e);
                throw namingException;
            }
        }
        finally {
            this.popEnc();
        }
    }

    protected void createCallbackHandler() {
        try {
            this.callbackHandler = new LifecycleInterceptorHandler(this, this.getHandledCallbacks());
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating callback handler for bean " + this.beanClassName, e);
        }
    }

    protected Class[] getHandledCallbacks() {
        return new Class[]{PostConstruct.class, PreDestroy.class, Timeout.class};
    }

    private void initialiseInterceptors() {
        if (this.applicableInterceptors == null) {
            log.debug("Initialising interceptors for " + this.getEjbName() + "...");
            HashSet defaultInterceptors = this.interceptorRepository.getDefaultInterceptors();
            log.debug("Default interceptors: " + defaultInterceptors);
            this.classInterceptors = this.interceptorRepository.getClassInterceptors(this);
            log.debug("Class interceptors: " + this.classInterceptors);
            this.applicableInterceptors = new LinkedHashSet();
            if (defaultInterceptors != null) {
                this.applicableInterceptors.addAll(defaultInterceptors);
            }
            if (this.classInterceptors != null) {
                this.applicableInterceptors.addAll(this.classInterceptors);
            }
            Method[] methods = this.clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                ArrayList methodIcptrs = this.interceptorRepository.getMethodInterceptors(this, methods[i]);
                if (methodIcptrs == null || methodIcptrs.size() <= 0) continue;
                log.debug("Method interceptors for  " + methods[i] + ": " + methodIcptrs);
                this.applicableInterceptors.addAll(methodIcptrs);
            }
            log.debug("All applicable interceptor classes: " + this.applicableInterceptors);
        }
    }

    protected void findPartitionName() {
        Clustered clustered = (Clustered)this.resolveAnnotation(Clustered.class);
        if (clustered == null) {
            this.partitionName = null;
            return;
        }
        String value = clustered.partition();
        try {
            String replacedValue = StringPropertyReplacer.replaceProperties(value);
            if (value != replacedValue) {
                log.debug("Replacing @Clustered partition attribute " + value + " with " + replacedValue);
                value = replacedValue;
            }
        }
        catch (Exception e) {
            log.warn("Unable to replace @Clustered partition attribute " + value + ". Caused by " + e.getClass() + " " + e.getMessage());
        }
        this.partitionName = value;
    }

    public Object getBusinessObject(BeanContext beanContext, Class businessObject) throws IllegalStateException {
        throw new IllegalStateException("Not implemented");
    }

    public Object getInvokedBusinessInterface(BeanContext beanContext) throws IllegalStateException {
        throw new IllegalStateException("Not implemented");
    }

    private Class loadPublicAnnotation(String annotation) {
        try {
            Class<?> ann = this.classloader.loadClass(annotation);
            if (!ann.isAnnotation()) {
                return null;
            }
            Retention retention = ann.getAnnotation(Retention.class);
            if (retention != null && retention.value() == RetentionPolicy.RUNTIME) {
                return ann;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public boolean hasAnnotation(Class tgt, String annotation) {
        if (this.annotations.hasClassAnnotation(annotation)) {
            return true;
        }
        if (tgt == null) {
            return false;
        }
        try {
            Class ann = this.loadPublicAnnotation(annotation);
            if (ann == null) {
                return AnnotationElement.isAnyAnnotationPresent((Class)tgt, (String)annotation);
            }
            return tgt.isAnnotationPresent(ann);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasAnnotation(Method m, String annotation) {
        if (this.annotations.hasAnnotation((Member)m, annotation)) {
            return true;
        }
        try {
            Class ann = this.loadPublicAnnotation(annotation);
            if (ann == null) {
                return AnnotationElement.isAnyAnnotationPresent((Method)m, (String)annotation);
            }
            return m.isAnnotationPresent(ann);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasAnnotation(Field m, String annotation) {
        if (this.annotations.hasAnnotation((Member)m, annotation)) {
            return true;
        }
        try {
            Class ann = this.loadPublicAnnotation(annotation);
            if (ann == null) {
                return AnnotationElement.isAnyAnnotationPresent((Field)m, (String)annotation);
            }
            return m.isAnnotationPresent(ann);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasAnnotation(Constructor m, String annotation) {
        if (this.annotations.hasAnnotation((Member)m, annotation)) {
            return true;
        }
        try {
            Class ann = this.loadPublicAnnotation(annotation);
            if (ann == null) {
                return AnnotationElement.isAnyAnnotationPresent((Constructor)m, (String)annotation);
            }
            return m.isAnnotationPresent(ann);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Container resolveEjbContainer(String link, Class businessIntf) {
        return this.deployment.getEjbContainer(link, businessIntf);
    }

    @Override
    public Container resolveEjbContainer(Class businessIntf) throws NameNotFoundException {
        return this.deployment.getEjbContainer(businessIntf);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz) {
        if (clazz == this.getBeanClass()) {
            return (T)((Annotation)this.resolveAnnotation(annotationType));
        }
        return clazz.getAnnotation(annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz, Method method) {
        if (clazz == this.getBeanClass()) {
            return (T)((Annotation)this.resolveAnnotation(method, annotationType));
        }
        return method.getAnnotation(annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Method method) {
        return (T)((Annotation)this.resolveAnnotation(method, annotationType));
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz, Field field) {
        if (clazz == this.getBeanClass()) {
            return (T)((Annotation)this.resolveAnnotation(field, annotationType));
        }
        return field.getAnnotation(annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Field field) {
        return (T)((Annotation)this.resolveAnnotation(field, annotationType));
    }

    public Object resolveAnnotation(Method m, Class annotation) {
        Object value = super.resolveAnnotation(m, annotation);
        if (value == null && m.isBridge()) {
            value = this.getBridgedAnnotation(m, annotation);
        }
        return value;
    }

    protected Object getBridgedAnnotation(Method bridgeMethod, Class annotation) {
        Method[] methods = bridgeMethod.getDeclaringClass().getMethods();
        boolean found = false;
        Class<?>[] bridgeParams = bridgeMethod.getParameterTypes();
        for (int i = 0; i < methods.length && !found; ++i) {
            Class<?>[] params;
            if (methods[i].isBridge() || !methods[i].getName().equals(bridgeMethod.getName()) || (params = methods[i].getParameterTypes()).length != bridgeParams.length) continue;
            boolean matches = true;
            for (int j = 0; j < params.length && matches; ++j) {
                if (bridgeParams[j].isAssignableFrom(params[j])) continue;
                matches = false;
            }
            if (!matches) continue;
            return this.resolveAnnotation(methods[i], annotation);
        }
        return null;
    }

    public Object resolveAnnotation(Method m, Class[] annotationChoices) {
        Object value = null;
        int i = 0;
        while (value == null && i < annotationChoices.length) {
            value = this.resolveAnnotation(m, annotationChoices[i++]);
        }
        return value;
    }

    @Override
    public String getIdentifier() {
        return this.getEjbName();
    }

    @Override
    public String getDeploymentDescriptorType() {
        return "ejb-jar.xml";
    }

    @Override
    public PersistenceUnitDeployment getPersistenceUnitDeployment(String unitName) throws NameNotFoundException {
        return this.deployment.getPersistenceUnitDeployment(unitName);
    }

    @Override
    public String getEjbJndiName(Class businessInterface) throws NameNotFoundException {
        return this.deployment.getEjbJndiName(businessInterface);
    }

    @Override
    public String getEjbJndiName(String link, Class businessInterface) {
        return this.deployment.getEjbJndiName(link, businessInterface);
    }

    @Override
    public InvocationStatistics getInvokeStats() {
        return this.invokeStats;
    }

    public MethodInfo getMethodInfo(Method method) {
        long hash = MethodHashing.calculateHash(method);
        MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
        if (info == null) {
            throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
        }
        return info;
    }

    @Override
    public boolean isClustered() {
        return false;
    }

    public RemoteBindings getRemoteBindings() {
        RemoteBindings bindings = (RemoteBindings)this.resolveAnnotation(RemoteBindings.class);
        if (bindings != null) {
            return bindings;
        }
        RemoteBinding[] newBindings = new RemoteBinding[1];
        RemoteBinding binding = (RemoteBinding)this.resolveAnnotation(RemoteBinding.class);
        if (binding != null) {
            newBindings[0] = binding;
        } else {
            String jndiName = ProxyFactoryHelper.getDefaultRemoteJndiName((Container)this);
            RemoteBindingImpl defaultBinding = new RemoteBindingImpl();
            defaultBinding.setJndiBinding(jndiName);
            newBindings[0] = defaultBinding;
        }
        RemoteBindingsImpl bindingsImpl = new RemoteBindingsImpl(newBindings);
        return bindingsImpl;
    }
}

