/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.ejb.EJBException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.Container;
import org.jboss.ejb.StatefulSessionContainer;
import org.jboss.ejb.StatefulSessionEnterpriseContext;
import org.jboss.ejb.StatefulSessionPersistenceManager;
import org.jboss.ejb.plugins.SessionObjectInputStream;
import org.jboss.ejb.plugins.SessionObjectOutputStream;
import org.jboss.ejb.plugins.StatefulSessionFilePersistenceManagerMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.id.UID;

public class StatefulSessionFilePersistenceManager
extends ServiceMBeanSupport
implements StatefulSessionPersistenceManager,
StatefulSessionFilePersistenceManagerMBean {
    public static final String DEFAULT_STORE_DIRECTORY_NAME = "sessions";
    private StatefulSessionContainer con;
    private String storeDirName = "sessions";
    private File storeDir;
    private boolean purgeEnabled = true;

    public void setContainer(Container con) {
        this.con = (StatefulSessionContainer)con;
    }

    public void setStoreDirectoryName(String dirName) {
        this.storeDirName = dirName;
    }

    public String getStoreDirectoryName() {
        return this.storeDirName;
    }

    public void setPurgeEnabled(boolean flag) {
        this.purgeEnabled = flag;
    }

    public boolean getPurgeEnabled() {
        return this.purgeEnabled;
    }

    public File getStoreDirectory() {
        return this.storeDir;
    }

    protected void createService() throws Exception {
        String ejbName = this.con.getBeanMetaData().getEjbName();
        File dir = ServerConfigLocator.locate().getServerTempDir();
        dir = new File(dir, this.storeDirName);
        this.storeDir = dir = new File(dir, ejbName + "-" + new UID().toString());
        this.log.debug((Object)("Storing sessions for '" + ejbName + "' in: " + this.storeDir));
        if (!this.storeDir.exists() && !MkdirsFileAction.mkdirs(this.storeDir)) {
            throw new IOException("Failed to create directory: " + this.storeDir);
        }
        if (!this.storeDir.isDirectory()) {
            throw new IOException("File exists where directory expected: " + this.storeDir);
        }
        if (!this.storeDir.canWrite() || !this.storeDir.canRead()) {
            throw new IOException("Directory must be readable and writable: " + this.storeDir);
        }
        this.purgeAllSessionData();
    }

    private void purgeAllSessionData() {
        if (!this.purgeEnabled) {
            return;
        }
        this.log.debug((Object)("Purging all session data in: " + this.storeDir));
        File[] sessions = this.storeDir.listFiles();
        for (int i = 0; i < sessions.length; ++i) {
            if (!sessions[i].delete()) {
                this.log.warn((Object)("Failed to delete session state file: " + sessions[i]));
                continue;
            }
            this.log.debug((Object)("Removed stale session state: " + sessions[i]));
        }
    }

    protected void destroyService() throws Exception {
        this.purgeAllSessionData();
        if (this.purgeEnabled && !this.storeDir.delete()) {
            this.log.warn((Object)("Failed to delete session state storage directory: " + this.storeDir));
        }
    }

    private File getFile(Object id) {
        return new File(this.storeDir, String.valueOf(id) + ".ser");
    }

    public Object createId(StatefulSessionEnterpriseContext ctx) throws Exception {
        return new UID();
    }

    public void createdSession(StatefulSessionEnterpriseContext ctx) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateSession(StatefulSessionEnterpriseContext ctx) throws RemoteException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Attempting to activate; ctx=" + ctx));
        }
        Object id = ctx.getId();
        File file = this.getFile(id);
        if (trace) {
            this.log.trace((Object)("Reading session state from: " + file));
        }
        try {
            FileInputStream fis = FISAction.open(file);
            SessionObjectInputStream in = new SessionObjectInputStream(ctx, new BufferedInputStream(fis));
            try {
                Object obj = in.readObject();
                if (trace) {
                    this.log.trace((Object)("Session state: " + obj));
                }
                ctx.setInstance(obj);
            }
            finally {
                in.close();
            }
        }
        catch (Exception e) {
            throw new EJBException("Could not activate; failed to restore state", e);
        }
        this.removePassivated(id);
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_ACTIVATE);
            SessionBean bean = (SessionBean)ctx.getInstance();
            bean.ejbActivate();
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
        if (trace) {
            this.log.trace((Object)("Activation complete; ctx=" + ctx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivateSession(StatefulSessionEnterpriseContext ctx) throws RemoteException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Attempting to passivate; ctx=" + ctx));
        }
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_PASSIVATE);
            SessionBean bean = (SessionBean)ctx.getInstance();
            bean.ejbPassivate();
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
        File file = this.getFile(ctx.getId());
        if (trace) {
            this.log.trace((Object)("Saving session state to: " + file));
        }
        try {
            FileOutputStream fos = FOSAction.open(file);
            SessionObjectOutputStream out = new SessionObjectOutputStream(new BufferedOutputStream(fos));
            Object obj = ctx.getInstance();
            if (trace) {
                this.log.trace((Object)("Writing session state: " + obj));
            }
            try {
                out.writeObject(obj);
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            throw new EJBException("Could not passivate; failed to save state", e);
        }
        if (trace) {
            this.log.trace((Object)("Passivation complete; ctx=" + ctx));
        }
    }

    public void removeSession(StatefulSessionEnterpriseContext ctx) throws RemoteException, RemoveException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Attempting to remove; ctx=" + ctx));
        }
        SessionBean bean = (SessionBean)ctx.getInstance();
        bean.ejbRemove();
        if (trace) {
            this.log.trace((Object)("Removal complete; ctx=" + ctx));
        }
    }

    public void removePassivated(Object id) {
        boolean trace = this.log.isTraceEnabled();
        File file = this.getFile(id);
        if (file.exists()) {
            if (trace) {
                this.log.trace((Object)("Removing passivated state file: " + file));
            }
            if (!DeleteFileAction.delete(file)) {
                this.log.warn((Object)("Failed to delete passivated state file: " + file));
            }
        }
    }

    static class FOSAction
    implements PrivilegedExceptionAction {
        File file;

        FOSAction(File file) {
            this.file = file;
        }

        public Object run() throws Exception {
            FileOutputStream fis = new FileOutputStream(this.file);
            return fis;
        }

        static FileOutputStream open(File file) throws FileNotFoundException {
            FOSAction action = new FOSAction(file);
            FileOutputStream fos = null;
            try {
                fos = (FileOutputStream)AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                throw (FileNotFoundException)e.getException();
            }
            return fos;
        }
    }

    static class FISAction
    implements PrivilegedExceptionAction {
        File file;

        FISAction(File file) {
            this.file = file;
        }

        public Object run() throws Exception {
            FileInputStream fis = new FileInputStream(this.file);
            return fis;
        }

        static FileInputStream open(File file) throws FileNotFoundException {
            FISAction action = new FISAction(file);
            FileInputStream fis = null;
            try {
                fis = (FileInputStream)AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                throw (FileNotFoundException)e.getException();
            }
            return fis;
        }
    }

    static class MkdirsFileAction
    implements PrivilegedAction {
        File file;

        MkdirsFileAction(File file) {
            this.file = file;
        }

        public Object run() {
            boolean ok = this.file.mkdirs();
            return new Boolean(ok);
        }

        static boolean mkdirs(File file) {
            MkdirsFileAction action = new MkdirsFileAction(file);
            Boolean ok = (Boolean)AccessController.doPrivileged(action);
            return ok;
        }
    }

    static class DeleteFileAction
    implements PrivilegedAction {
        File file;

        DeleteFileAction(File file) {
            this.file = file;
        }

        public Object run() {
            boolean deleted = this.file.delete();
            return new Boolean(deleted);
        }

        static boolean delete(File file) {
            DeleteFileAction action = new DeleteFileAction(file);
            Boolean deleted = (Boolean)AccessController.doPrivileged(action);
            return deleted;
        }
    }
}

