/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.asf;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.Session;
import javax.jms.XASession;
import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.jms.asf.StdServerSessionPool;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionManagerService;
import org.jboss.tm.XidFactoryMBean;
import org.jboss.tm.XidImpl;

public class StdServerSession
implements Runnable,
ServerSession,
MessageListener {
    static Logger log = Logger.getLogger(StdServerSession.class);
    private StdServerSessionPool serverSessionPool;
    private Session session;
    private XASession xaSession;
    private TransactionManager tm;
    private boolean useLocalTX;
    private MessageListener delegateListener;
    private XidFactoryMBean xidFactory;

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.tm = transactionManager;
    }

    StdServerSession(StdServerSessionPool pool, Session session, XASession xaSession, MessageListener delegateListener, boolean useLocalTX, XidFactoryMBean xidFactory, TransactionManager tm) throws JMSException {
        this.serverSessionPool = pool;
        this.session = session;
        this.xaSession = xaSession;
        this.delegateListener = delegateListener;
        if (xaSession == null) {
            useLocalTX = false;
        }
        this.useLocalTX = useLocalTX;
        this.xidFactory = xidFactory;
        this.tm = tm;
        log.debug((Object)("initializing (pool, session, xaSession, useLocalTX): " + pool + ", " + session + ", " + xaSession + ", " + useLocalTX));
        if (xaSession != null) {
            xaSession.setMessageListener((MessageListener)this);
        } else {
            session.setMessageListener((MessageListener)this);
        }
        if (tm == null) {
            InitialContext ctx = null;
            try {
                ctx = new InitialContext();
                this.tm = (TransactionManager)ctx.lookup(TransactionManagerService.JNDI_NAME);
            }
            catch (Exception e) {
                throw new JMSException("Transation manager was not found");
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Exception ignore) {}
                }
            }
        }
    }

    public Session getSession() throws JMSException {
        if (this.xaSession != null) {
            return this.xaSession;
        }
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"running...");
        }
        try {
            if (this.xaSession != null) {
                this.xaSession.run();
            } else {
                this.session.run();
            }
        }
        finally {
            if (trace) {
                log.trace((Object)"recycling...");
            }
            this.recycle();
            if (trace) {
                log.trace((Object)"finished run");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void onMessage(Message msg) {
        boolean trace;
        block72: {
            trace = log.isTraceEnabled();
            if (trace) {
                log.trace((Object)("onMessage running (pool, session, xaSession, useLocalTX): , " + this.session + ", " + this.xaSession + ", " + this.useLocalTX));
            }
            XidImpl localXid = null;
            boolean localRollbackFlag = false;
            Transaction trans = null;
            if (this.useLocalTX) {
                localXid = this.xidFactory.newXid();
                XAResource res = this.xaSession.getXAResource();
                res.start((Xid)localXid, 0);
                if (trace) {
                    log.trace((Object)"Using optimized 1p commit to control TX.");
                }
            } else {
                this.tm.begin();
                trans = this.tm.getTransaction();
                if (this.xaSession != null) {
                    XAResource res = this.xaSession.getXAResource();
                    if (!trans.enlistResource(res)) {
                        throw new JMSException("could not enlist resource");
                    }
                    if (trace) {
                        log.trace((Object)("XAResource '" + res + "' enlisted."));
                    }
                }
            }
            this.delegateListener.onMessage(msg);
            Object var9_9 = null;
            try {
                if (this.useLocalTX) {
                    if (localRollbackFlag) {
                        if (trace) {
                            log.trace((Object)"Using optimized 1p commit to rollback TX.");
                        }
                        XAResource res = this.xaSession.getXAResource();
                        res.end((Xid)localXid, 0x4000000);
                        res.rollback((Xid)localXid);
                    } else {
                        if (trace) {
                            log.trace((Object)"Using optimized 1p commit to commit TX.");
                        }
                        XAResource res = this.xaSession.getXAResource();
                        res.end((Xid)localXid, 0x4000000);
                        res.commit((Xid)localXid, true);
                    }
                } else {
                    Transaction currentTx = this.tm.getTransaction();
                    if (!trans.equals(currentTx)) {
                        throw new IllegalStateException("Wrong tx association: expected " + trans + " was " + currentTx);
                    }
                    if (trans.getStatus() == 1) {
                        if (trace) {
                            log.trace((Object)"Rolling back JMS transaction");
                        }
                        this.tm.rollback();
                        if (this.xaSession == null && this.serverSessionPool.isTransacted()) {
                            this.session.rollback();
                        }
                    } else if (trans.getStatus() == 0) {
                        if (trace) {
                            log.trace((Object)"Commiting the JMS transaction");
                        }
                        this.tm.commit();
                        if (this.xaSession == null && this.serverSessionPool.isTransacted()) {
                            this.session.commit();
                        }
                    } else {
                        if (trace) {
                            log.trace((Object)(this + "transaction already ended"));
                        }
                        this.tm.suspend();
                        if (this.xaSession == null && this.serverSessionPool.isTransacted()) {
                            this.session.rollback();
                        }
                    }
                }
                break block72;
            }
            catch (Exception e2) {
                log.error((Object)"failed to commit/rollback", (Throwable)e2);
            }
            break block72;
            {
                catch (Exception e) {
                    log.error((Object)"session failed to run; setting rollback only", (Throwable)e);
                    if (this.useLocalTX) {
                        localRollbackFlag = true;
                    } else {
                        try {
                            if (trace) {
                                log.trace((Object)"Using TM to mark TX for rollback.");
                            }
                            trans.setRollbackOnly();
                        }
                        catch (Exception x) {
                            log.error((Object)"failed to set rollback only", (Throwable)x);
                        }
                    }
                    Object var9_10 = null;
                    try {
                        if (this.useLocalTX) {
                            if (localRollbackFlag) {
                                if (trace) {
                                    log.trace((Object)"Using optimized 1p commit to rollback TX.");
                                }
                                XAResource res = this.xaSession.getXAResource();
                                res.end((Xid)localXid, 0x4000000);
                                res.rollback((Xid)localXid);
                            } else {
                                if (trace) {
                                    log.trace((Object)"Using optimized 1p commit to commit TX.");
                                }
                                XAResource res = this.xaSession.getXAResource();
                                res.end((Xid)localXid, 0x4000000);
                                res.commit((Xid)localXid, true);
                            }
                        } else {
                            Transaction currentTx = this.tm.getTransaction();
                            if (!trans.equals(currentTx)) {
                                throw new IllegalStateException("Wrong tx association: expected " + trans + " was " + currentTx);
                            }
                            if (trans.getStatus() == 1) {
                                if (trace) {
                                    log.trace((Object)"Rolling back JMS transaction");
                                }
                                this.tm.rollback();
                                if (this.xaSession == null && this.serverSessionPool.isTransacted()) {
                                    this.session.rollback();
                                }
                            } else if (trans.getStatus() == 0) {
                                if (trace) {
                                    log.trace((Object)"Commiting the JMS transaction");
                                }
                                this.tm.commit();
                                if (this.xaSession == null && this.serverSessionPool.isTransacted()) {
                                    this.session.commit();
                                }
                            } else {
                                if (trace) {
                                    log.trace((Object)(this + "transaction already ended"));
                                }
                                this.tm.suspend();
                                if (this.xaSession == null && this.serverSessionPool.isTransacted()) {
                                    this.session.rollback();
                                }
                            }
                        }
                        break block72;
                    }
                    catch (Exception e2) {
                        log.error((Object)"failed to commit/rollback", (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (this.useLocalTX) {
                        if (localRollbackFlag) {
                            if (trace) {
                                log.trace((Object)"Using optimized 1p commit to rollback TX.");
                            }
                            XAResource res = this.xaSession.getXAResource();
                            res.end((Xid)localXid, 0x4000000);
                            res.rollback((Xid)localXid);
                        } else {
                            if (trace) {
                                log.trace((Object)"Using optimized 1p commit to commit TX.");
                            }
                            XAResource res = this.xaSession.getXAResource();
                            res.end((Xid)localXid, 0x4000000);
                            res.commit((Xid)localXid, true);
                        }
                    } else {
                        Transaction currentTx = this.tm.getTransaction();
                        if (!trans.equals(currentTx)) {
                            throw new IllegalStateException("Wrong tx association: expected " + trans + " was " + currentTx);
                        }
                        if (trans.getStatus() == 1) {
                            if (trace) {
                                log.trace((Object)"Rolling back JMS transaction");
                            }
                            this.tm.rollback();
                            if (this.xaSession == null && this.serverSessionPool.isTransacted()) {
                                this.session.rollback();
                            }
                        } else if (trans.getStatus() == 0) {
                            if (trace) {
                                log.trace((Object)"Commiting the JMS transaction");
                            }
                            this.tm.commit();
                            if (this.xaSession == null && this.serverSessionPool.isTransacted()) {
                                this.session.commit();
                            }
                        } else {
                            if (trace) {
                                log.trace((Object)(this + "transaction already ended"));
                            }
                            this.tm.suspend();
                            if (this.xaSession == null && this.serverSessionPool.isTransacted()) {
                                this.session.rollback();
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    log.error((Object)"failed to commit/rollback", (Throwable)e2);
                }
                throw throwable;
            }
        }
        if (trace) {
            log.trace((Object)"onMessage done");
        }
    }

    public void start() throws JMSException {
        log.trace((Object)"starting invokes on server session");
        if (this.session != null) {
            try {
                this.serverSessionPool.getExecutor().execute((Runnable)this);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            throw new JMSException("No listener has been specified");
        }
    }

    void close() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            this.session = null;
        }
        if (this.xaSession != null) {
            try {
                this.xaSession.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.xaSession = null;
        }
        log.debug((Object)"closed");
    }

    void recycle() {
        this.serverSessionPool.recycle(this);
    }
}

