/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.util.MarkupInfo;
import org.gatein.pc.api.ActionURL;
import org.gatein.pc.api.ContainerURL;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.RenderURL;
import org.gatein.pc.api.ResourceURL;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.pc.portlet.impl.spi.AbstractPortletInvocationContext;

class ExoPortletInvocationContext
extends AbstractPortletInvocationContext {
    private HttpServletResponse response;
    private HttpServletRequest request;
    private String portalRequestURI;
    private String portletId;
    static final String INTERACTION_STATE_PARAM_NAME = "interactionstate";
    static final String NAVIGATIONAL_STATE_PARAM_NAME = "navigationalstate";
    static final String RESOURCE_STATE_PARAM_NAME = "resourcestate";

    public ExoPortletInvocationContext(PortalRequestContext portalRequestContext, UIPortlet portlet) {
        super(new MarkupInfo(MediaType.create((String)"text/html"), "UTF-8"));
        this.request = portalRequestContext.getRequest();
        this.response = portalRequestContext.getResponse();
        this.portalRequestURI = portalRequestContext.getRequestURI();
        this.portletId = portlet.getId();
    }

    public HttpServletRequest getClientRequest() throws IllegalStateException {
        return this.request;
    }

    public HttpServletResponse getClientResponse() throws IllegalStateException {
        return this.response;
    }

    public String encodeResourceURL(String url) throws IllegalArgumentException {
        return this.response.encodeURL(url);
    }

    public MarkupInfo getMarkupInfo() {
        return this.markupInfo;
    }

    public String renderURL(ContainerURL containerURL, URLFormat format) {
        String type;
        StringBuilder baseURL = new StringBuilder(this.portalRequestURI).append("?").append("portal:componentId").append("=").append(this.portletId);
        if (containerURL instanceof RenderURL) {
            type = "render";
        } else if (containerURL instanceof ResourceURL) {
            type = "resource";
        } else if (containerURL instanceof ActionURL) {
            type = "action";
        } else {
            throw new Error("Unrecognized containerURL type");
        }
        this.appendParameter(baseURL, "portal:type", type);
        this.appendParameter(baseURL, "portal:isSecure", "" + format.getWantSecure());
        if (containerURL instanceof ActionURL) {
            Mode mode;
            WindowState windowState;
            ActionURL actionURL = (ActionURL)containerURL;
            StateString state = actionURL.getInteractionState();
            if (state != null) {
                this.appendParameter(baseURL, INTERACTION_STATE_PARAM_NAME, state.getStringValue());
            }
            if ((state = actionURL.getNavigationalState()) != null) {
                this.appendParameter(baseURL, NAVIGATIONAL_STATE_PARAM_NAME, state.getStringValue());
            }
            if ((windowState = actionURL.getWindowState()) != null) {
                this.appendParameter(baseURL, "portal:windowState", windowState.toString());
            }
            if ((mode = actionURL.getMode()) != null) {
                this.appendParameter(baseURL, "portal:portletMode", mode.toString());
            }
        } else if (containerURL instanceof ResourceURL) {
            Mode mode;
            WindowState windowState;
            StateString resourceState;
            ResourceURL resourceURL = (ResourceURL)containerURL;
            this.appendParameter(baseURL, "portal:resourceID", resourceURL.getResourceId());
            CacheLevel cachability = resourceURL.getCacheability();
            if (cachability != null) {
                this.appendParameter(baseURL, "portal:cacheLevel", cachability.name());
            }
            if ((resourceState = resourceURL.getResourceState()) != null) {
                this.appendParameter(baseURL, RESOURCE_STATE_PARAM_NAME, resourceState.getStringValue());
            }
            if ((resourceState = resourceURL.getNavigationalState()) != null) {
                this.appendParameter(baseURL, NAVIGATIONAL_STATE_PARAM_NAME, resourceState.getStringValue());
            }
            if ((windowState = resourceURL.getWindowState()) != null) {
                this.appendParameter(baseURL, "portal:windowState", windowState.toString());
            }
            if ((mode = resourceURL.getMode()) != null) {
                this.appendParameter(baseURL, "portal:portletMode", mode.toString());
            }
        } else {
            StateString state;
            Map publicNSChanges;
            Mode mode;
            RenderURL renderURL = (RenderURL)containerURL;
            WindowState windowState = renderURL.getWindowState();
            if (windowState != null) {
                this.appendParameter(baseURL, "portal:windowState", windowState.toString());
            }
            if ((mode = renderURL.getMode()) != null) {
                this.appendParameter(baseURL, "portal:portletMode", mode.toString());
            }
            if ((publicNSChanges = renderURL.getPublicNavigationalStateChanges()) != null) {
                for (String key : publicNSChanges.keySet()) {
                    String[] values;
                    for (String value : values = (String[])publicNSChanges.get(key)) {
                        this.appendParameter(baseURL, key, value);
                    }
                }
            }
            if ((state = renderURL.getNavigationalState()) != null) {
                this.appendParameter(baseURL, NAVIGATIONAL_STATE_PARAM_NAME, state.getStringValue());
            }
        }
        return baseURL.toString();
    }

    private void appendParameter(StringBuilder builder, String name, String value) {
        if (value != null) {
            builder.append("&").append(name).append("=").append(value);
        }
    }
}

