/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.jboss.cache.Fqn;

public class Modification
implements Externalizable {
    public static final byte PUT_KEY_VALUE = 1;
    public static final byte PUT_DATA = 2;
    public static final byte PUT_DATA_ERASE = 3;
    public static final byte REMOVE_NODE = 4;
    public static final byte REMOVE_KEY_VALUE = 5;
    public static final byte REMOVE_DATA = 6;
    public static final byte STORE_STATE = 7;
    private static final long serialVersionUID = -3074622985730129009L;
    private byte type = 0;
    private Fqn fqn = null;
    private Object key = null;
    private Object value = null;
    private Object old_value = null;
    private Map data = null;

    public Modification() {
    }

    public Modification(byte type, Fqn fqn, Object key, Object value) {
        this.type = type;
        this.fqn = fqn;
        this.key = key;
        this.value = value;
    }

    public Modification(byte type, Fqn fqn, Object key) {
        this.type = type;
        this.fqn = fqn;
        this.key = key;
    }

    public Modification(byte type, Fqn fqn, Map data) {
        this.type = type;
        this.fqn = fqn;
        this.data = data;
    }

    public Modification(byte type, Fqn fqn) {
        this.type = type;
        this.fqn = fqn;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public Fqn getFqn() {
        return this.fqn;
    }

    public void setFqn(Fqn fqn) {
        this.fqn = fqn;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getOldValue() {
        return this.old_value;
    }

    public void setOldValue(Object old_value) {
        this.old_value = old_value;
    }

    public Map getData() {
        return this.data;
    }

    public void setData(Map data) {
        this.data = data;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.type);
        out.writeBoolean(this.fqn != null);
        if (this.fqn != null) {
            this.fqn.writeExternal(out);
        }
        out.writeObject(this.key);
        out.writeObject(this.value);
        out.writeObject(this.old_value);
        out.writeBoolean(this.data != null);
        if (this.data != null) {
            out.writeObject(this.data);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readByte();
        if (in.readBoolean()) {
            this.fqn = new Fqn();
            this.fqn.readExternal(in);
        }
        this.key = in.readObject();
        this.value = in.readObject();
        this.old_value = in.readObject();
        if (in.readBoolean()) {
            this.data = (Map)in.readObject();
        }
    }

    private String typeToString(int type) {
        switch (type) {
            case 1: {
                return "PUT_KEY_VALUE";
            }
            case 2: {
                return "PUT_DATA";
            }
            case 3: {
                return "PUT_DATA_ERASE";
            }
            case 4: {
                return "REMOVE_NODE";
            }
            case 5: {
                return "REMOVE_KEY_VALUE";
            }
            case 6: {
                return "REMOVE_DATA";
            }
            case 7: {
                return "STORE_STATE";
            }
        }
        return "<unknown>";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.typeToString(this.type)).append(": ").append(this.fqn);
        if (this.key != null) {
            sb.append("\nkey=").append(this.key);
        }
        if (this.value != null) {
            sb.append("\nvalue=").append(this.value);
        }
        if (this.old_value != null) {
            sb.append("\nold_value=").append(this.old_value);
        }
        if (this.data != null) {
            sb.append("\ndata=").append(this.data);
        }
        return sb.toString();
    }
}

