/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop.util;

import java.io.Serializable;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.Advised;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.BaseInterceptor;
import org.jboss.cache.aop.CacheInterceptor;
import org.jboss.cache.aop.PojoCache;

public class AopUtil {
    static Log log = LogFactory.getLog((String)AopUtil.class.getName());

    public static Interceptor findCacheInterceptor(InstanceAdvisor advisor, Fqn fqn) {
        Interceptor[] interceptors = advisor.getInterceptors();
        for (int i = 0; i < interceptors.length; ++i) {
            CacheInterceptor inter;
            Interceptor interceptor = interceptors[i];
            if (!(interceptor instanceof CacheInterceptor) || (inter = (CacheInterceptor)interceptor) == null || !inter.getFqn().equals(fqn)) continue;
            return interceptor;
        }
        return null;
    }

    public static Interceptor findCacheInterceptor(InstanceAdvisor advisor) {
        Interceptor[] interceptors = advisor.getInterceptors();
        for (int i = 0; i < interceptors.length; ++i) {
            Interceptor interceptor = interceptors[i];
            if (!(interceptor instanceof CacheInterceptor)) continue;
            return interceptor;
        }
        return null;
    }

    public static Interceptor findCollectionInterceptor(InstanceAdvisor advisor) {
        Interceptor[] interceptors = advisor.getInterceptors();
        for (int i = 0; i < interceptors.length; ++i) {
            Interceptor interceptor = interceptors[i];
            if (!(interceptor instanceof BaseInterceptor)) continue;
            return interceptor;
        }
        return null;
    }

    public static void checkObjectType(Object obj) {
        if (obj == null) {
            return;
        }
        if (!(obj instanceof Advised)) {
            boolean allowedType;
            boolean bl = allowedType = obj instanceof Serializable || obj.getClass().isArray() && obj.getClass().getComponentType().isPrimitive();
            if (!allowedType) {
                throw new IllegalArgumentException("PojoCache.putObject(): Object type is neither  aspectized nor Serializable nor an array of primitives. Object class name is " + obj.getClass().getName());
            }
        }
    }

    public static Fqn constructFqn(Fqn baseFqn, Object relative) {
        return new Fqn(baseFqn, relative.toString());
    }

    public static DataNode get(PojoCache cache, Fqn fqn) throws CacheException {
        if (cache.getCacheLoader() != null) {
            return cache.get(fqn);
        }
        return cache._get(fqn);
    }

    public static Set getNodeChildren(PojoCache cache, Fqn fqn) throws CacheException {
        if (cache.getCacheLoader() != null) {
            return cache.getChildrenNames(fqn);
        }
        return cache._getChildrenNames(fqn);
    }
}

