/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.container;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.managed.ManagedObject;
import org.gatein.pc.portlet.container.managed.ManagedObjectLifeCycleEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.gatein.pc.portlet.impl.container.DependencyNotResolvedException;

public abstract class LifeCycle
implements ManagedObject {
    private Logger log = Logger.getLogger(LifeCycle.class);
    private LifeCycleStatus status = LifeCycleStatus.STOPPED;
    private boolean active = false;
    private static final ThreadLocal<Set<Object>> faileds = new ThreadLocal();

    public final LifeCycleStatus getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void managedStart() throws IllegalStateException {
        if (this.active) {
            throw new IllegalStateException("Reentrancy detected");
        }
        this.active = true;
        boolean clearFaileds = false;
        try {
            if (faileds.get() == null) {
                clearFaileds = true;
                faileds.set(new HashSet());
            } else if (faileds.get().contains(this)) {
                return;
            }
            LifeCycleStatus previousStatus = this.status;
            if (this.status != LifeCycleStatus.STARTED) {
                LifeCycleStatus status = LifeCycleStatus.FAILED;
                try {
                    this.invokeStart();
                    status = LifeCycleStatus.STARTED;
                }
                catch (DependencyNotResolvedException ignore) {
                    status = LifeCycleStatus.STOPPED;
                }
                catch (Exception e) {
                    this.log.error((Object)"Cannot start object", (Throwable)e);
                }
                catch (Error e) {
                    this.log.error((Object)"Cannot start object", (Throwable)e);
                }
                finally {
                    this.status = status;
                    if (status == LifeCycleStatus.FAILED) {
                        faileds.get().add(this);
                    }
                }
            }
            if (this.status != previousStatus) {
                this.getListener().onEvent(new ManagedObjectLifeCycleEvent(this, this.status));
            }
            if (this.status == LifeCycleStatus.STARTED) {
                this.startDependents();
            }
        }
        finally {
            if (clearFaileds) {
                faileds.set(null);
            }
            this.active = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void managedStop() {
        block11: {
            if (this.active) {
                throw new IllegalStateException("Reentrancy detected");
            }
            this.active = true;
            try {
                this.stopDependents();
                if (this.status != LifeCycleStatus.STARTED) break block11;
                try {
                    this.invokeStop();
                }
                catch (Exception e) {
                    this.log.error((Object)"Error during object stop", (Throwable)e);
                }
                catch (Error e) {
                    this.log.error((Object)"Error during object stop", (Throwable)e);
                }
                finally {
                    this.status = LifeCycleStatus.STOPPED;
                }
                this.getListener().onEvent(new ManagedObjectLifeCycleEvent(this, LifeCycleStatus.STOPPED));
            }
            finally {
                this.active = false;
            }
        }
    }

    protected void startDependents() {
    }

    protected void stopDependents() {
    }

    protected abstract void invokeStart() throws Exception;

    protected abstract void invokeStop();

    protected abstract ManagedObjectRegistryEventListener getListener();
}

