/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application.replication.model;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.exoplatform.webui.application.replication.annotations.ReplicatedType;
import org.exoplatform.webui.application.replication.model.ClassTypeModel;
import org.exoplatform.webui.application.replication.model.FieldModel;
import org.exoplatform.webui.application.replication.model.ReplicatableTypeModel;
import org.exoplatform.webui.application.replication.model.TypeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeDomain {
    private final Map<String, TypeModel> typeModelMap;
    private final Map<String, TypeModel> immutableTypeModelMap;
    private final Set<TypeModel> typeModelSet;
    private final Set<TypeModel> immutableTypeModelSet;

    public TypeDomain() {
        HashMap<String, TypeModel> typeModelMap = new HashMap<String, TypeModel>();
        Map immutableTypeModelMap = Collections.unmodifiableMap(typeModelMap);
        HashSet<TypeModel> typeModelSet = new HashSet<TypeModel>();
        Set immutableTypeModelSet = Collections.unmodifiableSet(typeModelSet);
        this.typeModelMap = typeModelMap;
        this.immutableTypeModelMap = immutableTypeModelMap;
        this.typeModelSet = typeModelSet;
        this.immutableTypeModelSet = immutableTypeModelSet;
    }

    public Map<String, TypeModel> getTypeModelMap() {
        return this.immutableTypeModelMap;
    }

    public Set<TypeModel> getTypeModels() {
        return this.immutableTypeModelSet;
    }

    public TypeModel getTypeModel(String typeName) {
        if (typeName == null) {
            throw new NullPointerException();
        }
        return this.typeModelMap.get(typeName);
    }

    public TypeModel getTypeModel(Class<?> javaType) {
        if (javaType == null) {
            throw new NullPointerException();
        }
        return this.typeModelMap.get(javaType.getName());
    }

    public TypeModel add(Class<?> javaType) {
        if (javaType == null) {
            throw new NullPointerException();
        }
        HashMap<String, TypeModel> addedTypeModels = new HashMap<String, TypeModel>();
        TypeModel model = this.build(javaType, addedTypeModels);
        this.typeModelMap.putAll(addedTypeModels);
        this.typeModelSet.addAll(addedTypeModels.values());
        return model;
    }

    public int getSize() {
        return this.typeModelMap.size();
    }

    private <O> TypeModel build(Class<O> javaType, Map<String, TypeModel> addedTypeModels) {
        TypeModel typeModel = this.get(javaType, addedTypeModels);
        if (typeModel == null) {
            boolean replicated = javaType.getAnnotation(ReplicatedType.class) != null;
            TypeModel superTypeModel = null;
            for (Class<O> ancestor = javaType.getSuperclass(); ancestor != null && (superTypeModel = this.build(ancestor, addedTypeModels)) == null; ancestor = ancestor.getSuperclass()) {
            }
            TreeMap<String, FieldModel> fieldModels = new TreeMap<String, FieldModel>();
            typeModel = replicated ? new ReplicatableTypeModel<O>(javaType, superTypeModel, (Map<String, FieldModel>)fieldModels) : new ClassTypeModel(javaType, superTypeModel, fieldModels);
            addedTypeModels.put(javaType.getName(), typeModel);
            for (Field field : javaType.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                Class<?> fieldJavaType = field.getType();
                TypeModel fieldTypeModel = this.build(fieldJavaType, addedTypeModels);
                if (fieldTypeModel == null) continue;
                fieldModels.put(field.getName(), new FieldModel(field, fieldTypeModel));
            }
        }
        return typeModel;
    }

    private TypeModel get(Class<?> javaType, Map<String, TypeModel> addedTypeModels) {
        TypeModel typeModel = this.typeModelMap.get(javaType.getName());
        if (typeModel == null) {
            typeModel = addedTypeModels.get(javaType.getName());
        }
        return typeModel;
    }
}

