/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.util.Digest;
import org.jgroups.util.Promise;

public class ParticipantGmsImpl
extends GmsImpl {
    private final Vector suspected_mbrs = new Vector(11);
    private final Promise leave_promise = new Promise();

    public ParticipantGmsImpl(GMS g) {
        super(g);
    }

    public void init() throws Exception {
        super.init();
        this.suspected_mbrs.removeAllElements();
        this.leave_promise.reset();
    }

    public void join(Address mbr) {
        this.wrongMethod("join");
    }

    public void leave(Address mbr) {
        Address coord;
        int max_tries = 3;
        this.leave_promise.reset();
        if (mbr.equals(this.gms.local_addr)) {
            this.leaving = true;
        }
        while ((coord = this.gms.determineCoordinator()) != null && max_tries-- > 0) {
            if (this.gms.local_addr.equals(coord)) {
                this.gms.becomeCoordinator();
                this.gms.getImpl().leave(mbr);
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("sending LEAVE request to " + coord + " (local_addr=" + this.gms.local_addr + ")"));
            }
            this.sendLeaveMessage(coord, mbr);
            Object result = this.leave_promise.getResult(this.gms.leave_timeout);
            if (result == null) continue;
        }
        this.gms.becomeClient();
    }

    public void handleJoinResponse(JoinRsp join_rsp) {
        ViewId tmp_vid;
        View v = join_rsp.getView();
        ViewId viewId = tmp_vid = v != null ? v.getVid() : null;
        if (tmp_vid != null && this.gms.view_id != null && tmp_vid.compareTo(this.gms.view_id) > 0) {
            this.gms.installView(v);
        }
    }

    public void handleLeaveResponse() {
        if (this.leave_promise == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"leave_promise is null");
            }
            return;
        }
        this.leave_promise.setResult(Boolean.TRUE);
    }

    public void suspect(Address mbr) {
        LinkedHashSet emptyVector = new LinkedHashSet(0);
        LinkedHashSet<Address> suspected = new LinkedHashSet<Address>(1);
        suspected.add(mbr);
        this.handleMembershipChange(emptyVector, emptyVector, suspected);
    }

    public void unsuspect(Address mbr) {
        if (mbr != null) {
            this.suspected_mbrs.remove(mbr);
        }
    }

    public void handleMembershipChange(Collection newMembers, Collection leavingMembers, Collection suspectedMembers) {
        if (suspectedMembers == null || suspectedMembers.isEmpty()) {
            return;
        }
        for (Address mbr : suspectedMembers) {
            if (this.suspected_mbrs.contains(mbr)) continue;
            this.suspected_mbrs.addElement(mbr);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("suspected members=" + suspectedMembers + ", suspected_mbrs=" + this.suspected_mbrs));
        }
        if (this.wouldIBeCoordinator()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("members are " + this.gms.members + ", coord=" + this.gms.local_addr + ": I'm the new coord !"));
            }
            this.suspected_mbrs.removeAllElements();
            this.gms.becomeCoordinator();
            for (Address mbr : suspectedMembers) {
                this.gms.getViewHandler().add(new GMS.Request(3, mbr, true, null));
                this.gms.ack_collector.suspect(mbr);
            }
        }
    }

    public void handleViewChange(View new_view, Digest digest) {
        Vector<Address> mbrs = new_view.getMembers();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("view=" + new_view));
        }
        this.suspected_mbrs.removeAllElements();
        if (this.leaving && !mbrs.contains(this.gms.local_addr)) {
            return;
        }
        this.gms.installView(new_view, digest);
    }

    public void handleMergeRequest(Address sender, ViewId merge_id) {
        this.sendMergeRejectedResponse(sender, merge_id);
    }

    boolean wouldIBeCoordinator() {
        Vector<Address> mbrs = this.gms.members.getMembers();
        mbrs.removeAll(this.suspected_mbrs);
        if (mbrs.size() < 1) {
            return false;
        }
        Address new_coord = mbrs.elementAt(0);
        return this.gms.local_addr.equals(new_coord);
    }

    void sendLeaveMessage(Address coord, Address mbr) {
        Message msg = new Message(coord, null, null);
        GMS.GmsHeader hdr = new GMS.GmsHeader(3, mbr);
        msg.putHeader(this.gms.getName(), hdr);
        this.gms.getDownProtocol().down(new Event(1, msg));
    }
}

