/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.common.collection;

import java.lang.reflect.Array;
import java.util.AbstractList;
import org.chromattic.common.collection.BooleanWrappedArrayList;
import org.chromattic.common.collection.DoubleWrappedArrayList;
import org.chromattic.common.collection.FloatWrappedArrayList;
import org.chromattic.common.collection.GenericWrappedArrayList;
import org.chromattic.common.collection.IntWrappedArrayList;
import org.chromattic.common.collection.LongWrappedArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WrappedArrayList<E, A>
extends AbstractList<E> {
    private final A array;
    private final int size;

    public static <E, A> WrappedArrayList<E, A> create(Class<E> elementType, Class<?> componentType, int size) {
        if (elementType == null) {
            throw new NullPointerException("No null element type can be provided");
        }
        if (size < 0) {
            throw new IllegalArgumentException("No negative sized array can be created (" + size + ")");
        }
        return WrappedArrayList.wrap(elementType, Array.newInstance(componentType, size));
    }

    public static <E, A> WrappedArrayList<E, A> wrap(Class<E> elementType, Object array) {
        if (elementType == null) {
            throw new NullPointerException("No null element type can be provided");
        }
        Class<?> arrayClass = array.getClass();
        if (!arrayClass.isArray()) {
            throw new IllegalArgumentException("Provided array is not an array");
        }
        Class<?> componentType = arrayClass.getComponentType();
        if (componentType.isPrimitive()) {
            if (elementType == Integer.class) {
                if (!arrayClass.getComponentType().equals(Integer.TYPE)) {
                    throw new IllegalArgumentException("Cannot wrap array with component type " + componentType.getName() + " to int");
                }
                IntWrappedArrayList list = new IntWrappedArrayList((int[])array);
                return list;
            }
            if (elementType == Boolean.class) {
                if (!componentType.equals(Boolean.TYPE)) {
                    throw new IllegalArgumentException("Cannot wrap array with component type " + componentType.getName() + " to boolean");
                }
                BooleanWrappedArrayList list = new BooleanWrappedArrayList((boolean[])array);
                return list;
            }
            if (elementType == Long.class) {
                if (!componentType.equals(Long.TYPE)) {
                    throw new IllegalArgumentException("Cannot wrap array with component type " + componentType.getName() + " to long");
                }
                LongWrappedArrayList list = new LongWrappedArrayList((long[])array);
                return list;
            }
            if (elementType == Double.class) {
                if (!componentType.equals(Double.TYPE)) {
                    throw new IllegalArgumentException("Cannot wrap array with component type " + componentType.getName() + " to double");
                }
                DoubleWrappedArrayList list = new DoubleWrappedArrayList((double[])array);
                return list;
            }
            if (elementType == Float.class) {
                if (!componentType.equals(Float.TYPE)) {
                    throw new IllegalArgumentException("Cannot wrap array with component type " + componentType.getName() + " to float");
                }
                FloatWrappedArrayList list = new FloatWrappedArrayList((float[])array);
                return list;
            }
            throw new UnsupportedOperationException("Cannot create wrapper of class " + elementType);
        }
        if (!componentType.equals(elementType)) {
            throw new IllegalArgumentException("Cannot wrap array with component type " + componentType.getName() + " to " + elementType.getName());
        }
        GenericWrappedArrayList<Object> list = new GenericWrappedArrayList<Object>((Object[])array);
        return list;
    }

    protected WrappedArrayList(A array) throws NullPointerException {
        this.array = array;
        this.size = this.size(array);
    }

    protected abstract E get(A var1, int var2);

    protected abstract void set(A var1, int var2, E var3);

    protected abstract int size(A var1);

    public final A getArray() {
        return this.array;
    }

    @Override
    public final E get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("No negative index " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("No index greater than the list size " + index);
        }
        return this.get(this.array, index);
    }

    @Override
    public final E set(int index, E element) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("No negative index " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("No index greater than the list size " + index);
        }
        E previous = this.get(this.array, index);
        this.set(this.array, index, element);
        return previous;
    }

    @Override
    public final int size() {
        return this.size;
    }
}

