/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application.replication.serial;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.IdentityHashMap;
import org.exoplatform.webui.application.replication.SerializationContext;
import org.exoplatform.webui.application.replication.model.FieldModel;
import org.exoplatform.webui.application.replication.model.ReplicatableTypeModel;
import org.exoplatform.webui.application.replication.model.TypeModel;
import org.exoplatform.webui.application.replication.serial.DataContainer;
import org.exoplatform.webui.application.replication.serial.SerializationStatus;

public class ObjectWriter
extends ObjectOutputStream {
    private final SerializationContext context;
    private final IdentityHashMap<Object, Integer> objectToId;

    public ObjectWriter(SerializationContext context, OutputStream out) throws IOException {
        super(out);
        this.enableReplaceObject(true);
        this.context = context;
        this.objectToId = new IdentityHashMap();
    }

    private int register(Object o) {
        int nextId = this.objectToId.size();
        this.objectToId.put(o, nextId);
        return nextId;
    }

    protected Object replaceObject(Object obj) throws IOException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Serializable) {
            return obj;
        }
        DataContainer output = new DataContainer();
        Integer id = this.objectToId.get(obj);
        if (id != null) {
            output.writeInt(2);
            output.writeObject(id);
        } else {
            Class<?> objClass = obj.getClass();
            TypeModel typeModel = this.context.getTypeDomain().getTypeModel(objClass);
            if (typeModel == null) {
                throw new NotSerializableException("Object " + obj + " does not have its type described");
            }
            output.writeInt(0);
            output.writeInt(this.register(obj));
            output.writeObject(objClass);
            SerializationStatus status = SerializationStatus.NONE;
            for (TypeModel currentTypeModel = typeModel; currentTypeModel != null; currentTypeModel = currentTypeModel.getSuperType()) {
                if (currentTypeModel instanceof ReplicatableTypeModel) {
                    for (FieldModel fieldModel : currentTypeModel.getFields()) {
                        if (fieldModel.isTransient()) continue;
                        Object fieldValue = fieldModel.getValue(obj);
                        if (fieldValue == null) {
                            output.writeObject(1);
                            continue;
                        }
                        Integer fieldValueId = this.objectToId.get(fieldValue);
                        if (fieldValueId != null) {
                            output.writeObject(2);
                            output.writeInt(fieldValueId);
                            continue;
                        }
                        output.writeObject(0);
                        output.writeObject(fieldValue);
                    }
                    switch (status) {
                        case NONE: {
                            status = SerializationStatus.FULL;
                        }
                    }
                    continue;
                }
                if (currentTypeModel.getFields().isEmpty()) continue;
                switch (status) {
                    case FULL: {
                        status = SerializationStatus.PARTIAL;
                    }
                }
            }
            switch (status) {
                case FULL: {
                    break;
                }
                case PARTIAL: {
                    System.out.println("Partial serialization of object " + obj);
                    break;
                }
                case NONE: {
                    throw new NotSerializableException("Type " + objClass.getName() + " is not serializable");
                }
            }
        }
        return output;
    }
}

