/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.bean;

import java.lang.reflect.Method;
import java.util.List;
import org.exoplatform.util.ReflectionUtil;
import org.exoplatform.webui.bean.BeanDataMapping;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormInputSet;

public class ReflectionDataMapping
implements BeanDataMapping {
    public void mapBean(Object bean, UIForm uiForm) throws Exception {
        List<UIComponent> children = uiForm.getChildren();
        for (UIComponent uichild : children) {
            if (uichild instanceof UIFormInput) {
                this.invokeSetBindingField(bean, (UIFormInput)((Object)uichild));
                continue;
            }
            if (!(uichild instanceof UIFormInputSet)) continue;
            this.mapBean(bean, (UIFormInputSet)uichild);
        }
    }

    public void mapBean(Object bean, UIFormInputSet uiFormInputSet) throws Exception {
        List<UIComponent> children = uiFormInputSet.getChildren();
        for (UIComponent uichild : children) {
            if (!(uichild instanceof UIFormInput)) continue;
            this.invokeSetBindingField(bean, (UIFormInput)((Object)uichild));
        }
    }

    public void mapField(UIForm uiForm, Object bean) throws Exception {
        List<UIComponent> children = uiForm.getChildren();
        for (UIComponent uichild : children) {
            if (uichild instanceof UIFormInput) {
                this.invokeGetBindingField((UIFormInput)((Object)uichild), bean);
                continue;
            }
            if (!(uichild instanceof UIFormInputSet)) continue;
            this.mapField((UIFormInputSet)uichild, bean);
        }
    }

    public void mapField(UIFormInputSet uiFormInputSet, Object bean) throws Exception {
        List<UIComponent> children = uiFormInputSet.getChildren();
        for (UIComponent uichild : children) {
            if (!(uichild instanceof UIFormInput)) continue;
            this.invokeGetBindingField((UIFormInput)((Object)uichild), bean);
        }
    }

    private void invokeGetBindingField(UIFormInput uiFormInput, Object bean) throws Exception {
        String bindingField = uiFormInput.getBindingField();
        if (bindingField == null) {
            return;
        }
        Method method = ReflectionUtil.getGetBindingMethod((Object)bean, (String)bindingField);
        Object value = method.invoke(bean, ReflectionUtil.EMPTY_ARGS);
        if (value == null) {
            return;
        }
        uiFormInput.setValue(value);
    }

    private void invokeSetBindingField(Object bean, UIFormInput uiFormInput) throws Exception {
        UIFormInputBase uiStringBase;
        if (uiFormInput instanceof UIFormInputBase && !(uiStringBase = (UIFormInputBase)uiFormInput).isEditable()) {
            return;
        }
        String bindingField = uiFormInput.getBindingField();
        if (bindingField == null) {
            return;
        }
        Class[] classes = new Class[]{uiFormInput.getTypeValue()};
        Method method = ReflectionUtil.getSetBindingMethod((Object)bean, (String)bindingField, (Class[])classes);
        method.invoke(bean, uiFormInput.getValue());
    }
}

