/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.web.application.URLBuilder;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.Component;
import org.exoplatform.webui.config.Event;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.renderers.ValueRenderer;
import org.exoplatform.webui.core.renderers.ValueRendererRegistry;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.event.MonitorEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIComponent {
    public static final String OBJECTID = "objectId";
    public static final String UICOMPONENT = "uicomponent";
    public static final String AJAX_ASYNC = "ajax_async";
    private String id;
    private boolean rendered = true;
    protected transient UIComponent uiparent;
    protected transient Component config;
    private transient ValueRendererRegistry rendererRegistry = new ValueRendererRegistry();

    public String getId() {
        return this.id;
    }

    public UIComponent setId(String id) {
        this.id = id == null ? Integer.toString(this.hashCode()) : id;
        return this;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public <T extends UIComponent> T getParent() {
        return (T)this.uiparent;
    }

    public void setParent(UIComponent uicomponent) {
        this.uiparent = uicomponent;
    }

    public boolean isRendered() {
        return this.rendered;
    }

    public <T extends UIComponent> T setRendered(boolean b) {
        this.rendered = b;
        return (T)this;
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        MonitorEvent<UIComponent> mevent = this.createMonitorEvent(Event.Phase.DECODE, context);
        this.config.getUIComponentLifecycle().processDecode(this, context);
        if (mevent != null) {
            mevent.setEndExecutionTime(System.currentTimeMillis());
            mevent.broadcast();
        }
    }

    public void processAction(WebuiRequestContext context) throws Exception {
        MonitorEvent<UIComponent> mevent = this.createMonitorEvent(Event.Phase.PROCESS, context);
        this.config.getUIComponentLifecycle().processAction(this, context);
        if (mevent != null) {
            mevent.setEndExecutionTime(System.currentTimeMillis());
            mevent.broadcast();
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        MonitorEvent<UIComponent> mevent = this.createMonitorEvent(Event.Phase.RENDER, context);
        this.config.getUIComponentLifecycle().processRender(this, context);
        if (mevent != null) {
            mevent.setEndExecutionTime(System.currentTimeMillis());
            mevent.broadcast();
        }
    }

    public Component getComponentConfig() {
        return this.config;
    }

    public void setComponentConfig(String componentId, Component config) throws Exception {
        this.config = config;
        if (componentId == null || componentId.length() == 0) {
            componentId = config.getId();
        }
        if (componentId == null) {
            String type = config.getType();
            componentId = type.substring(type.lastIndexOf(46) + 1);
        }
        this.setId(componentId);
    }

    public void setComponentConfig(Class<?> clazz, String id) {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        WebuiApplication app = (WebuiApplication)context.getApplication();
        this.config = app.getConfigurationManager().getComponentConfig(clazz, id);
    }

    public String getTemplate() {
        return this.config.getTemplate();
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return context.getResourceResolver(template);
    }

    public <T extends UIComponent> T getAncestorOfType(Class<T> classType) {
        for (T parent = this.getParent(); parent != null; parent = ((UIComponent)parent).getParent()) {
            if (!classType.isInstance(parent)) continue;
            return (T)((UIComponent)classType.cast(parent));
        }
        return null;
    }

    public String event(String name) throws Exception {
        return this.event(name, null);
    }

    public String event(String name, String beanId) throws Exception {
        return this.event(name, beanId, null);
    }

    public String event(String name, String beanId, Parameter[] params) throws Exception {
        Event event = this.config.getUIComponentEventConfig(name);
        if (event == null) {
            return "??config??";
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        URLBuilder<UIComponent> urlBuilder = context.getURLBuilder();
        if (urlBuilder == null) {
            return "??builder??";
        }
        String confirm = this.loadConfirmMesssage(event, context, beanId);
        return urlBuilder.createAjaxURL((Object)this, event.getName(), confirm, beanId, params);
    }

    protected String loadConfirmMesssage(Event event, WebuiRequestContext context, String beanId) {
        String confirmKey = event.getConfirm();
        if (confirmKey.length() < 1) {
            return confirmKey;
        }
        try {
            String confirm = context.getApplicationResourceBundle().getString(confirmKey);
            return confirm.replaceAll("\\{0\\}", beanId);
        }
        catch (Exception e) {
            return confirmKey;
        }
    }

    public String url(String name) throws Exception {
        return this.url(name, null);
    }

    public String url(String name, String beanId) throws Exception {
        return this.url(name, beanId, null);
    }

    public String url(String name, String beanId, Parameter[] params) throws Exception {
        Event event = this.config.getUIComponentEventConfig(name);
        if (event == null) {
            return "??config??";
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        String confirm = this.loadConfirmMesssage(event, context, beanId);
        try {
            return context.getURLBuilder().createURL((Object)this, event.getName(), confirm, beanId, params).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String doAsync(String name, String beanId, Parameter[] params) throws Exception {
        Parameter async_param = new Parameter(AJAX_ASYNC, "true");
        if (params == null) {
            params = new Parameter[]{async_param};
        } else {
            ArrayList<Parameter> paramList = new ArrayList<Parameter>();
            for (int i = 0; i < params.length; ++i) {
                if (params[i].getName().equals(AJAX_ASYNC)) {
                    params[i] = async_param;
                }
                paramList.add(params[i]);
            }
            if (!paramList.contains(async_param)) {
                paramList.add(async_param);
            }
            params = (Parameter[])paramList.toArray();
        }
        return this.event(name, beanId, new Parameter[]{async_param});
    }

    public <T> void broadcast(org.exoplatform.webui.event.Event<T> event, Event.Phase phase) throws Exception {
        if (this.config == null) {
            return;
        }
        Event econfig = this.config.getUIComponentEventConfig(event.getName());
        if (econfig == null) {
            return;
        }
        Event.Phase executionPhase = econfig.getExecutionPhase();
        if (executionPhase == phase || executionPhase == Event.Phase.ANY) {
            for (EventListener listener : econfig.getCachedEventListeners()) {
                listener.execute(event);
            }
        }
    }

    public <T extends UIComponent> T createUIComponent(Class<T> type, String configId, String componentId, UIComponent parent) throws Exception {
        T uicomp = this.createUIComponent(type, configId, componentId);
        ((UIComponent)uicomp).setParent(parent);
        return uicomp;
    }

    public <T extends UIComponent> T createUIComponent(Class<T> type, String configId, String componentId) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        return this.createUIComponent(context, type, configId, componentId);
    }

    public <T extends UIComponent> T createUIComponent(WebuiRequestContext context, Class<T> type, String configId, String componentId) throws Exception {
        WebuiApplication app = (WebuiApplication)context.getApplication();
        T comp = app.createUIComponent(type, configId, componentId, context);
        return comp;
    }

    public <T extends UIComponent> T findComponentById(String lookupId) {
        if (this.getId().equals(lookupId)) {
            return (T)this;
        }
        return null;
    }

    public <T extends UIComponent> T findFirstComponentOfType(Class<T> type) {
        if (type.isInstance(this)) {
            return (T)((UIComponent)type.cast(this));
        }
        return null;
    }

    public <T> void findComponentOfType(List<T> list, Class<T> type) {
        if (type.isInstance(this)) {
            list.add(type.cast(this));
        }
    }

    public <T extends UIComponent> void setRenderSibling(Class<T> type) {
        if (this.uiparent instanceof UIContainer) {
            UIContainer uicontainer = (UIContainer)this.uiparent;
            List<UIComponent> children = uicontainer.getChildren();
            for (UIComponent child : children) {
                if (type.isInstance(child)) {
                    child.setRendered(true);
                    continue;
                }
                child.setRendered(false);
            }
        }
    }

    public String getUIComponentName() {
        return UICOMPONENT;
    }

    public <T> T getApplicationComponent(Class<T> type) {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        return type.cast(container.getComponentInstanceOfType(type));
    }

    public org.exoplatform.webui.event.Event<UIComponent> createEvent(String name, Event.Phase phase, WebuiRequestContext context) throws Exception {
        if (this.config == null) {
            return null;
        }
        Event econfig = this.config.getUIComponentEventConfig(name);
        if (econfig == null) {
            return null;
        }
        Event.Phase executionPhase = econfig.getExecutionPhase();
        if (executionPhase == phase || executionPhase == Event.Phase.ANY) {
            org.exoplatform.webui.event.Event<UIComponent> event = new org.exoplatform.webui.event.Event<UIComponent>(this, name, context);
            event.setExecutionPhase(phase);
            event.setEventListeners(econfig.getCachedEventListeners());
            return event;
        }
        return null;
    }

    private MonitorEvent<UIComponent> createMonitorEvent(Event.Phase phase, WebuiRequestContext context) throws Exception {
        if (this.config == null) {
            return null;
        }
        Event econfig = this.config.getUIComponentEventConfig("uicomponent.lifecycle.monitor.event");
        if (econfig == null) {
            return null;
        }
        Event.Phase executionPhase = econfig.getExecutionPhase();
        if (executionPhase == phase || executionPhase == Event.Phase.ANY) {
            MonitorEvent<UIComponent> mevent = new MonitorEvent<UIComponent>(this, "uicomponent.lifecycle.monitor.event", context);
            mevent.setEventListeners(econfig.getCachedEventListeners());
            mevent.setStartExecutionTime(System.currentTimeMillis());
            mevent.setExecutionPhase(phase);
            return mevent;
        }
        return null;
    }

    public ValueRenderer<?> getRendererFor(Object value) {
        return this.rendererRegistry.getRendererFor(value);
    }

    public <V> void registerRendererFor(ValueRenderer<V> renderer, Class<? extends V> valueType) {
        this.rendererRegistry.registerRendererFor(renderer, valueType);
    }
}

