/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.rss;

import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.ks.rss.ForumFeedGenerator;

public class ForumRSSEventListener
implements EventListener {
    private String path_;
    private String workspace_;
    private String repository_;
    private KSDataLocation locator;

    public ForumRSSEventListener(KSDataLocation dataLocator) throws Exception {
        this.locator = dataLocator;
        this.workspace_ = dataLocator.getWorkspace();
        this.repository_ = dataLocator.getRepository();
    }

    public String getSrcWorkspace() {
        return this.workspace_;
    }

    public String getRepository() {
        return this.repository_;
    }

    public String getPath() {
        return this.path_;
    }

    public void setPath(String path) {
        this.path_ = path;
    }

    public void onEvent(EventIterator evIter) {
        try {
            ForumFeedGenerator process = new ForumFeedGenerator(this.locator);
            String path = null;
            if (evIter.hasNext()) {
                Event ev = evIter.nextEvent();
                path = ev.getPath();
                if (ev.getType() == 1) {
                    process.itemAdded(ev.getPath());
                } else if (ev.getType() == 16) {
                    process.itemUpdated(path.substring(0, path.lastIndexOf("/")));
                } else if (ev.getType() == 2) {
                    process.itemRemoved(ev.getPath());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

