/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.chromattic;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Session;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.GlobalContext;
import org.exoplatform.commons.chromattic.LoginContext;

public class Synchronization
implements LoginContext {
    private final Map<String, Session> repositorySessions = new HashMap<String, Session>();
    private final Map<String, GlobalContext> contexts = new HashMap<String, GlobalContext>();
    private boolean saveOnClose = true;

    public GlobalContext getContext(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.contexts.get(name);
    }

    public GlobalContext openContext(ChromatticLifeCycle lifeCycle) throws IllegalStateException {
        if (lifeCycle == null) {
            throw new NullPointerException();
        }
        String name = lifeCycle.getDomainName();
        GlobalContext context = this.contexts.get(name);
        if (context != null) {
            throw new IllegalStateException();
        }
        context = new GlobalContext(lifeCycle, this);
        this.contexts.put(name, context);
        lifeCycle.onOpenSession(context);
        return context;
    }

    public void loggedIn(Session session) {
        this.repositorySessions.put(session.getWorkspace().getName(), session);
    }

    public void close(boolean save) {
        for (GlobalContext context : this.contexts.values()) {
            context.close(save);
        }
        for (Session session : this.repositorySessions.values()) {
            session.logout();
        }
    }

    public boolean getSaveOnClose() {
        return this.saveOnClose;
    }

    public void setSaveOnClose(boolean saveOnClose) {
        this.saveOnClose = saveOnClose;
    }
}

