/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.portal.application.PortalStatistic;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="statistic"), @Property(key="type", value="portal")})
@ManagedDescription(value="The portal statistic service")
public class PortalStatisticService
implements Startable {
    private ConcurrentMap<String, PortalStatistic> apps = new ConcurrentHashMap<String, PortalStatistic>();
    private UserPortalConfigService configService;

    public PortalStatisticService(UserPortalConfigService res) {
        this.configService = res;
    }

    @Managed
    @ManagedDescription(value="The list of identifier of the known portals")
    public String[] getPortalList() {
        try {
            List names = this.configService.getAllPortalNames();
            return names.toArray(new String[names.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    public PortalStatistic getPortalStatistic(String appId) {
        PortalStatistic existing;
        PortalStatistic app = (PortalStatistic)this.apps.get(appId);
        if (app == null && (existing = this.apps.putIfAbsent(appId, app = new PortalStatistic(appId))) != null) {
            app = existing;
        }
        return app;
    }

    @Managed
    @ManagedDescription(value="The maximum execution time of a specified portal in seconds")
    public double getMaxTime(@ManagedDescription(value="The portal id") @ManagedName(value="portalId") String id) {
        return this.toSeconds(this.getPortalStatistic(id).getMaxTime());
    }

    @Managed
    @ManagedDescription(value="The mininum execution time of a specified portal in seconds")
    public double getMinTime(@ManagedDescription(value="The portal id") @ManagedName(value="portalId") String id) {
        return this.toSeconds(this.getPortalStatistic(id).getMinTime());
    }

    @Managed
    @ManagedDescription(value="The average execution time of a specified portal in seconds")
    public double getAverageTime(@ManagedDescription(value="The portal id") @ManagedName(value="portalId") String id) {
        return this.toSeconds(this.getPortalStatistic(id).getAverageTime());
    }

    @Managed
    @ManagedDescription(value="The number of request per second of a specified portal")
    public double getThroughput(@ManagedDescription(value="The portal id") @ManagedName(value="portalId") String id) {
        return this.getPortalStatistic(id).getThroughput();
    }

    @Managed
    @ManagedDescription(value="The execution count of a specified portal")
    public long getExecutionCount(@ManagedDescription(value="The portal id") @ManagedName(value="portalId") String id) {
        return this.getPortalStatistic(id).viewCount();
    }

    private double toSeconds(double value) {
        return value == -1.0 ? -1.0 : value / 1000.0;
    }

    public void start() {
    }

    public void stop() {
    }
}

