/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.portlet.WindowState;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.webui.application.UIAddNewApplication;
import org.exoplatform.portal.webui.application.UIApplication;
import org.exoplatform.portal.webui.application.UIGadget;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.navigation.PageNavigationUtils;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageActionListener;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.page.UIPageLifecycle;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalComponentActionListener;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIPageLifecycle.class, template="system:/groovy/portal/webui/page/UIDesktopPage.gtmpl", events={@EventConfig(listeners={UIPortalComponentActionListener.ShowLoginFormActionListener.class}), @EventConfig(listeners={UIPageActionListener.DeleteGadgetActionListener.class}), @EventConfig(listeners={UIPageActionListener.RemoveChildActionListener.class}), @EventConfig(listeners={SaveGadgetPropertiesActionListener.class}), @EventConfig(listeners={SaveWindowPropertiesActionListener.class}), @EventConfig(listeners={ShowAddNewApplicationActionListener.class}), @EventConfig(listeners={ChangePageActionListener.class}), @EventConfig(listeners={ShowPortletActionListener.class})})
public class UIDesktopPage
extends UIPage {
    public UIDesktopPage() {
        this.setChildren(new CopyOnWriteArrayList());
    }

    @Override
    public boolean isShowMaxWindow() {
        return true;
    }

    public List<PageNavigation> getNavigations() throws Exception {
        List<PageNavigation> allNav = Util.getUIPortal().getNavigations();
        String removeUser = Util.getPortalRequestContext().getRemoteUser();
        ArrayList<PageNavigation> result = new ArrayList<PageNavigation>();
        for (PageNavigation nav : allNav) {
            result.add(PageNavigationUtils.filter(nav, removeUser));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowPortletActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            UIPage uiPage = (UIPage)((Object)event.getSource());
            String portletId = event.getRequestContext().getRequestParameter("objectId");
            UIPortlet uiPortlet = (UIPortlet)uiPage.getChildById(portletId);
            uiPortlet.getProperties().setProperty("appStatus", "SHOW");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPortlet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangePageActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            String uri = event.getRequestContext().getRequestParameter("objectId");
            UIPortal uiPortal = Util.getUIPortal();
            UIPageBody uiPageBody = (UIPageBody)uiPortal.findFirstComponentOfType(UIPageBody.class);
            if (uiPageBody != null && uiPageBody.getMaximizedUIComponent() != null) {
                UIPortlet currentPortlet = (UIPortlet)uiPageBody.getMaximizedUIComponent();
                currentPortlet.setCurrentWindowState(WindowState.NORMAL);
                uiPageBody.setMaximizedUIComponent(null);
            }
            PageNodeEvent<UIPortal> pnevent = new PageNodeEvent<UIPortal>(uiPortal, "ChangePageNode", uri);
            uiPortal.broadcast(pnevent, Event.Phase.PROCESS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowAddNewApplicationActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            UIPage uiPage = (UIPage)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPage.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWorkspace = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            UIAddNewApplication uiAddApplication = (UIAddNewApplication)uiPage.createUIComponent(UIAddNewApplication.class, null, null);
            uiAddApplication.setInPage(true);
            uiAddApplication.setUiComponentParent((UIComponent)uiPage);
            uiAddApplication.getApplicationCategories(event.getRequestContext().getRemoteUser(), null);
            uiMaskWorkspace.setWindowSize(700, 375);
            uiMaskWorkspace.setUIComponent((UIComponent)uiAddApplication);
            uiMaskWorkspace.setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWorkspace);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveWindowPropertiesActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            String appStatus;
            String zIndex;
            String objectId;
            UIPage uiPage = (UIPage)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiPage.getChildById(objectId = event.getRequestContext().getRequestParameter("objectId"));
            if (uiApp == null) {
                return;
            }
            String posX = event.getRequestContext().getRequestParameter("posX");
            String posY = event.getRequestContext().getRequestParameter("posY");
            if (posX != null) {
                uiApp.getProperties().put((Object)"locationX", (Object)posX);
            }
            if (posY != null) {
                uiApp.getProperties().put((Object)"locationY", (Object)posY);
            }
            if ((zIndex = event.getRequestContext().getRequestParameter("zIndex")) != null) {
                uiApp.getProperties().put((Object)"zIndex", (Object)zIndex);
            }
            String windowWidth = event.getRequestContext().getRequestParameter("windowWidth");
            String windowHeight = event.getRequestContext().getRequestParameter("windowHeight");
            if (windowWidth != null) {
                uiApp.getProperties().put((Object)"windowWidth", (Object)windowWidth);
            }
            if (windowHeight != null) {
                uiApp.getProperties().put((Object)"windowHeight", (Object)windowHeight);
            }
            if ((appStatus = event.getRequestContext().getRequestParameter("appStatus")) != null) {
                uiApp.getProperties().put((Object)"appStatus", (Object)appStatus);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveGadgetPropertiesActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            UIPage uiPage = (UIPage)((Object)event.getSource());
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            ArrayList uiGadgets = new ArrayList();
            uiPage.findComponentOfType(uiGadgets, UIGadget.class);
            UIGadget uiGadget = null;
            for (UIGadget ele : uiGadgets) {
                if (!ele.getId().equals(objectId)) continue;
                uiGadget = ele;
                break;
            }
            if (uiGadget == null) {
                return;
            }
            String posX = event.getRequestContext().getRequestParameter("posX");
            String posY = event.getRequestContext().getRequestParameter("posY");
            String zIndex = event.getRequestContext().getRequestParameter("zIndex");
            uiGadget.getProperties().put((Object)"locationX", (Object)posX);
            uiGadget.getProperties().put((Object)"locationY", (Object)posY);
            uiGadget.getProperties().put((Object)"zIndex", (Object)zIndex);
            if (!uiPage.isModifiable()) {
                return;
            }
            Page page = (Page)PortalDataMapper.buildModelObject((UIComponent)uiPage);
            UserPortalConfigService configService = (UserPortalConfigService)uiPage.getApplicationComponent(UserPortalConfigService.class);
            if (page.getChildren() == null) {
                page.setChildren(new ArrayList());
            }
            configService.update(page);
        }
    }
}

