/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.serialization;

import java.io.IOException;
import java.util.ArrayList;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectReader;
import org.exoplatform.services.jcr.dataflow.serialization.UnknownClassIdException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ReaderSpoolFileHolder;
import org.exoplatform.services.jcr.impl.dataflow.serialization.TransientValueDataReader;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

public class TransientPropertyDataReader {
    private FileCleaner fileCleaner;
    private int maxBufferSize;
    private final ReaderSpoolFileHolder holder;

    public TransientPropertyDataReader(FileCleaner fileCleaner, int maxBufferSize, ReaderSpoolFileHolder holder) {
        this.fileCleaner = fileCleaner;
        this.maxBufferSize = maxBufferSize;
        this.holder = holder;
    }

    public TransientPropertyData read(ObjectReader in) throws UnknownClassIdException, IOException {
        QPath qpath;
        int key = in.readInt();
        if (key != 8) {
            throw new UnknownClassIdException("There is unexpected class [" + key + "]");
        }
        try {
            String sQPath = in.readString();
            qpath = QPath.parse(sQPath);
        }
        catch (IllegalPathException e) {
            throw new IOException("Deserialization error. " + (Object)((Object)e)){

                public Throwable getCause() {
                    return e;
                }
            };
        }
        String identifier = in.readString();
        String parentIdentifier = null;
        if (in.readByte() == 1) {
            parentIdentifier = in.readString();
        }
        int persistedVersion = in.readInt();
        int type = in.readInt();
        boolean multiValued = in.readBoolean();
        TransientPropertyData prop = new TransientPropertyData(qpath, identifier, persistedVersion, type, parentIdentifier, multiValued);
        if (in.readByte() == 1) {
            int listSize = in.readInt();
            ArrayList<ValueData> values = new ArrayList<ValueData>();
            TransientValueDataReader rdr = new TransientValueDataReader(this.fileCleaner, this.maxBufferSize, this.holder);
            for (int i = 0; i < listSize; ++i) {
                values.add(rdr.read(in));
            }
            prop.setValues(values);
        }
        return prop;
    }
}

