/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.session;

import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LocalWorkspaceDataManagerStub;
import org.exoplatform.services.jcr.impl.dataflow.session.LocalWorkspaceStorageDataManagerProxy;
import org.exoplatform.services.jcr.impl.dataflow.session.WorkspaceStorageDataManagerProxy;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.transaction.TransactionException;
import org.exoplatform.services.transaction.TransactionResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionableDataManager
implements TransactionResource,
DataManager {
    private WorkspaceStorageDataManagerProxy storageDataManager;
    protected static Log log = ExoLogger.getLogger((String)"jcr.TransactionableDataManager");
    private TransactionChangesLog transactionLog;

    public TransactionableDataManager(LocalWorkspaceDataManagerStub dataManager, SessionImpl session) throws RepositoryException {
        try {
            this.storageDataManager = new LocalWorkspaceStorageDataManagerProxy(dataManager, session.getValueFactory());
        }
        catch (Exception e1) {
            String infoString = "[Error of read value factory: " + e1.getMessage() + "]";
            throw new RepositoryException(infoString);
        }
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException {
        List<NodeData> nodes = this.storageDataManager.getChildNodesData(parent);
        if (this.txStarted()) {
            for (ItemState state : this.transactionLog.getChildrenChanges(parent.getIdentifier(), true)) {
                nodes.remove(state.getData());
                if (state.isDeleted()) continue;
                nodes.add((NodeData)state.getData());
            }
        }
        return nodes;
    }

    @Override
    public int getChildNodesCount(NodeData parent) throws RepositoryException {
        if (this.txStarted()) {
            int txChildsCount = 0;
            for (ItemState change : this.transactionLog.getAllStates()) {
                if (!change.isNode() || !change.isPersisted() || !change.getData().getParentIdentifier().equals(parent.getIdentifier())) continue;
                if (change.isDeleted()) {
                    --txChildsCount;
                    continue;
                }
                if (!change.isAdded()) continue;
                ++txChildsCount;
            }
            int childsCount = this.storageDataManager.getChildNodesCount(parent) + txChildsCount;
            if (childsCount < 0) {
                throw new InvalidItemStateException("Node's child nodes were changed in another Transaction " + parent.getQPath().getAsString());
            }
            return childsCount;
        }
        return this.storageDataManager.getChildNodesCount(parent);
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException {
        List<PropertyData> props = this.storageDataManager.getChildPropertiesData(parent);
        if (this.txStarted()) {
            for (ItemState state : this.transactionLog.getChildrenChanges(parent.getIdentifier(), false)) {
                props.remove(state.getData());
                if (state.isDeleted()) continue;
                props.add((PropertyData)state.getData());
            }
        }
        return props;
    }

    @Override
    public List<PropertyData> listChildPropertiesData(NodeData parent) throws RepositoryException {
        List<PropertyData> props = this.storageDataManager.listChildPropertiesData(parent);
        if (this.txStarted()) {
            for (ItemState state : this.transactionLog.getChildrenChanges(parent.getIdentifier(), false)) {
                props.remove(state.getData());
                if (state.isDeleted()) continue;
                props.add((PropertyData)state.getData());
            }
        }
        return props;
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name) throws RepositoryException {
        ItemState state;
        ItemData data = null;
        if (this.txStarted() && (state = this.transactionLog.getItemState(parentData, name)) != null) {
            data = state.getData();
        }
        if (data != null) {
            return data;
        }
        return this.storageDataManager.getItemData(parentData, name);
    }

    @Override
    public ItemData getItemData(String identifier) throws RepositoryException {
        ItemState state;
        ItemData data = null;
        if (this.txStarted() && (state = this.transactionLog.getItemState(identifier)) != null) {
            data = state.getData();
        }
        if (data != null) {
            return data;
        }
        return this.storageDataManager.getItemData(identifier);
    }

    @Override
    public List<PropertyData> getReferencesData(String identifier, boolean skipVersionStorage) throws RepositoryException {
        return this.storageDataManager.getReferencesData(identifier, skipVersionStorage);
    }

    public void start() {
        log.debug((Object)("tx start() " + this + " txStarted(): " + this.txStarted()));
        if (!this.txStarted()) {
            this.transactionLog = new TransactionChangesLog();
        }
    }

    public void commit() throws TransactionException {
        if (this.txStarted()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("tx commit() " + this + "\n" + this.transactionLog.dump()));
            }
            try {
                this.storageDataManager.save(this.transactionLog);
                this.transactionLog = null;
            }
            catch (InvalidItemStateException e) {
                throw new TransactionException((Throwable)e);
            }
            catch (RepositoryException e) {
                throw new TransactionException((Throwable)e);
            }
        }
    }

    public void rollback() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("tx rollback() " + this + (this.transactionLog != null ? "\n" + this.transactionLog.dump() : "[NULL]")));
        }
        if (this.txStarted()) {
            this.transactionLog = null;
        }
    }

    @Override
    public void save(ItemStateChangesLog changes) throws RepositoryException {
        PlainChangesLog statesLog = (PlainChangesLog)changes;
        if (log.isDebugEnabled()) {
            log.debug((Object)("save() " + this + " txStarted: " + this.txStarted() + "\n====== Changes ======\n" + (statesLog != null ? "\n" + statesLog.dump() : "[NULL]") + "====================="));
        }
        if (this.txStarted()) {
            this.transactionLog.addLog(statesLog);
        } else {
            this.storageDataManager.save(new TransactionChangesLog(statesLog));
        }
    }

    public boolean txStarted() {
        return this.transactionLog != null;
    }

    public boolean txHasPendingChages() {
        return this.txStarted() && this.transactionLog.getSize() > 0;
    }

    public WorkspaceStorageDataManagerProxy getStorageDataManager() {
        return this.storageDataManager;
    }
}

