/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion.xstream;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import org.apache.shindig.protocol.RestfulCollection;

public class RestfullCollectionConverter
extends AbstractCollectionConverter {
    public RestfullCollectionConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class clazz) {
        return RestfulCollection.class.isAssignableFrom(clazz);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        RestfulCollection collection = (RestfulCollection)source;
        writer.startNode("startIndex");
        writer.setValue(String.valueOf(collection.getStartIndex()));
        writer.endNode();
        writer.startNode("totalResults");
        writer.setValue(String.valueOf(collection.getTotalResults()));
        writer.endNode();
        writer.startNode("isFiltered");
        writer.setValue(String.valueOf(collection.isFiltered()));
        writer.endNode();
        writer.startNode("isSorted");
        writer.setValue(String.valueOf(collection.isSorted()));
        writer.endNode();
        writer.startNode("isUpdatedSince");
        writer.setValue(String.valueOf(collection.isUpdatedSince()));
        writer.endNode();
        for (Object o : collection.getEntry()) {
            writer.startNode("entry");
            this.writeItem(o, context, writer);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader arg0, UnmarshallingContext arg1) {
        return null;
    }
}

