/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.AbstractKernelController;
import org.jboss.kernel.plugins.dependency.InstallsAwareAction;
import org.jboss.kernel.plugins.dependency.ScopeHierarchyBuilder;
import org.jboss.kernel.plugins.dependency.ScopedKernelController;
import org.jboss.kernel.plugins.dependency.SecurityActions;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeFactory;
import org.jboss.metadata.spi.scope.ScopeFactoryLookup;
import org.jboss.metadata.spi.scope.ScopeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreInstallAction
extends InstallsAwareAction {
    private Map<Class<? extends ScopeFactory<? extends Annotation>>, WeakReference<ScopeFactory<? extends Annotation>>> factories = new WeakHashMap<Class<? extends ScopeFactory<? extends Annotation>>, WeakReference<ScopeFactory<? extends Annotation>>>();

    protected ScopeFactory<? extends Annotation> getScopeFactory(Class<? extends ScopeFactory<? extends Annotation>> clazz) throws Throwable {
        ScopeFactory<? extends Annotation> factory = null;
        WeakReference<ScopeFactory<? extends Annotation>> weak = this.factories.get(clazz);
        if (weak != null && (factory = (ScopeFactory<? extends Annotation>)weak.get()) != null) {
            return factory;
        }
        if (factory == null) {
            factory = clazz.newInstance();
            this.factories.put(clazz, new WeakReference<ScopeFactory<? extends Annotation>>(factory));
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void installActionInternal(KernelControllerContext context) throws Throwable {
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelConfigurator configurator = kernel.getConfigurator();
        BeanMetaData metaData = context.getBeanMetaData();
        if (metaData.getBean() != null) {
            BeanInfo info = configurator.getBeanInfo(metaData);
            context.setBeanInfo(info);
            KernelMetaDataRepository repository = controller.getKernel().getMetaDataRepository();
            ClassLoader oldCL = SecurityActions.setContextClassLoader(context);
            try {
                repository.addMetaData(context);
            }
            finally {
                SecurityActions.resetContextClassLoader(oldCL);
            }
            try {
                this.applyScoping(context);
            }
            catch (Throwable t) {
                this.removeMetaData(context);
                throw t;
            }
        }
    }

    protected ScopeKey getInstallScopeKey(KernelControllerContext context, KernelMetaDataRepository repository) throws Throwable {
        Annotation[] annotations;
        ScopeKey scopeKey = context.getScopeInfo().getInstallScope();
        if (scopeKey != null) {
            return scopeKey;
        }
        MetaData retrieval = repository.getMetaData(context);
        if (retrieval != null && (annotations = retrieval.getAnnotations()) != null && annotations.length > 0) {
            HashSet<Scope> scopes = new HashSet<Scope>();
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().isAnnotationPresent(ScopeFactoryLookup.class)) continue;
                ScopeFactoryLookup sfl = annotation.annotationType().getAnnotation(ScopeFactoryLookup.class);
                ScopeFactory<? extends Annotation> scf = this.getScopeFactory(sfl.value());
                Scope scope = scf.create(annotation);
                scopes.add(scope);
            }
            if (scopes.size() > 0) {
                return new ScopeKey(scopes);
            }
        }
        return null;
    }

    protected void applyScoping(KernelControllerContext context) throws Throwable {
        KernelController controller = (KernelController)context.getController();
        KernelMetaDataRepository repository = controller.getKernel().getMetaDataRepository();
        ScopeKey scopeKey = this.getInstallScopeKey(context, repository);
        if (scopeKey != null) {
            scopeKey.freeze();
            context.getScopeInfo().setInstallScope(scopeKey);
            if (!(controller instanceof AbstractKernelController)) {
                throw new IllegalArgumentException("Can only handle AbstractKernelController: " + controller);
            }
            MutableMetaDataRepository mmdr = repository.getMetaDataRepository();
            AbstractController abstractController = ScopeHierarchyBuilder.buildControllerHierarchy((AbstractKernelController)controller, mmdr, scopeKey);
            if (!(abstractController instanceof ScopedKernelController)) {
                throw new IllegalArgumentException("Should be ScopedKernelController instance: " + abstractController);
            }
            ScopedKernelController scopedController = (ScopedKernelController)abstractController;
            scopedController.addScopedControllerContext(context);
        }
    }

    protected void removeScoping(KernelControllerContext context) throws Throwable {
        ScopeKey scopeKey = context.getScopeInfo().getInstallScope();
        if (scopeKey != null) {
            KernelController controller = (KernelController)context.getController();
            KernelMetaDataRepository repository = controller.getKernel().getMetaDataRepository();
            MutableMetaDataRepository mmdr = repository.getMetaDataRepository();
            ScopeHierarchyBuilder.cleanControllerHierarchy(mmdr, scopeKey, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void uninstallActionInternal(KernelControllerContext context) {
        try {
            this.removeScoping(context);
        }
        catch (Throwable ignored) {
            this.log.warn((Object)"Unexpected error removing scoping: ", ignored);
        }
        finally {
            this.removeMetaData(context);
            context.setBeanInfo(null);
        }
    }

    private void removeMetaData(KernelControllerContext context) {
        try {
            KernelController controller = (KernelController)context.getController();
            KernelMetaDataRepository repository = controller.getKernel().getMetaDataRepository();
            repository.removeMetaData(context);
        }
        catch (Throwable ignored) {
            this.log.warn((Object)"Unexpected error removing metadata: ", ignored);
        }
    }

    @Override
    protected ControllerState getState() {
        return ControllerState.PRE_INSTALL;
    }
}

