/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.util.AreaReference;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;

public class AreaPtg
extends Ptg {
    public static final short sid = 37;
    private static final int SIZE = 9;
    private short field_1_first_row;
    private short field_2_last_row;
    private short field_3_first_column;
    private short field_4_last_column;
    private static final BitField rowRelative = BitFieldFactory.getInstance(32768);
    private static final BitField colRelative = BitFieldFactory.getInstance(16384);
    private static final BitField columnMask = BitFieldFactory.getInstance(16383);

    protected AreaPtg() {
    }

    public AreaPtg(String arearef) {
        AreaReference ar = new AreaReference(arearef);
        this.setFirstRow((short)ar.getCells()[0].getRow());
        this.setFirstColumn(ar.getCells()[0].getCol());
        this.setLastRow((short)ar.getCells()[1].getRow());
        this.setLastColumn(ar.getCells()[1].getCol());
        this.setFirstColRelative(!ar.getCells()[0].isColAbsolute());
        this.setLastColRelative(!ar.getCells()[1].isColAbsolute());
        this.setFirstRowRelative(!ar.getCells()[0].isRowAbsolute());
        this.setLastRowRelative(!ar.getCells()[1].isRowAbsolute());
    }

    public AreaPtg(short firstRow, short lastRow, short firstColumn, short lastColumn, boolean firstRowRelative, boolean lastRowRelative, boolean firstColRelative, boolean lastColRelative) {
        this.setFirstRow(firstRow);
        this.setLastRow(lastRow);
        this.setFirstColumn(firstColumn);
        this.setLastColumn(lastColumn);
        this.setFirstRowRelative(firstRowRelative);
        this.setLastRowRelative(lastRowRelative);
        this.setFirstColRelative(firstColRelative);
        this.setLastColRelative(lastColRelative);
    }

    public AreaPtg(RecordInputStream in) {
        this.field_1_first_row = in.readShort();
        this.field_2_last_row = in.readShort();
        this.field_3_first_column = in.readShort();
        this.field_4_last_column = in.readShort();
    }

    public String getAreaPtgName() {
        return "AreaPtg";
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getAreaPtgName());
        buffer.append("\n");
        buffer.append("firstRow = " + this.getFirstRow()).append("\n");
        buffer.append("lastRow  = " + this.getLastRow()).append("\n");
        buffer.append("firstCol = " + this.getFirstColumn()).append("\n");
        buffer.append("lastCol  = " + this.getLastColumn()).append("\n");
        buffer.append("firstColRowRel= " + this.isFirstRowRelative()).append("\n");
        buffer.append("lastColRowRel = " + this.isLastRowRelative()).append("\n");
        buffer.append("firstColRel   = " + this.isFirstColRelative()).append("\n");
        buffer.append("lastColRel    = " + this.isLastColRelative()).append("\n");
        return buffer.toString();
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset] = (byte)(37 + this.ptgClass);
        LittleEndian.putShort(array, offset + 1, this.field_1_first_row);
        LittleEndian.putShort(array, offset + 3, this.field_2_last_row);
        LittleEndian.putShort(array, offset + 5, this.field_3_first_column);
        LittleEndian.putShort(array, offset + 7, this.field_4_last_column);
    }

    public int getSize() {
        return 9;
    }

    public short getFirstRow() {
        return this.field_1_first_row;
    }

    public void setFirstRow(short row) {
        this.field_1_first_row = row;
    }

    public short getLastRow() {
        return this.field_2_last_row;
    }

    public void setLastRow(short row) {
        this.field_2_last_row = row;
    }

    public short getFirstColumn() {
        return columnMask.getShortValue(this.field_3_first_column);
    }

    public short getFirstColumnRaw() {
        return this.field_3_first_column;
    }

    public boolean isFirstRowRelative() {
        return rowRelative.isSet(this.field_3_first_column);
    }

    public void setFirstRowRelative(boolean rel) {
        this.field_3_first_column = rowRelative.setShortBoolean(this.field_3_first_column, rel);
    }

    public boolean isFirstColRelative() {
        return colRelative.isSet(this.field_3_first_column);
    }

    public void setFirstColRelative(boolean rel) {
        this.field_3_first_column = colRelative.setShortBoolean(this.field_3_first_column, rel);
    }

    public void setFirstColumn(short column) {
        this.field_3_first_column = columnMask.setShortValue(this.field_3_first_column, column);
    }

    public void setFirstColumnRaw(short column) {
        this.field_3_first_column = column;
    }

    public short getLastColumn() {
        return columnMask.getShortValue(this.field_4_last_column);
    }

    public short getLastColumnRaw() {
        return this.field_4_last_column;
    }

    public boolean isLastRowRelative() {
        return rowRelative.isSet(this.field_4_last_column);
    }

    public void setLastRowRelative(boolean rel) {
        this.field_4_last_column = rowRelative.setShortBoolean(this.field_4_last_column, rel);
    }

    public boolean isLastColRelative() {
        return colRelative.isSet(this.field_4_last_column);
    }

    public void setLastColRelative(boolean rel) {
        this.field_4_last_column = colRelative.setShortBoolean(this.field_4_last_column, rel);
    }

    public void setLastColumn(short column) {
        this.field_4_last_column = columnMask.setShortValue(this.field_4_last_column, column);
    }

    public void setLastColumnRaw(short column) {
        this.field_4_last_column = column;
    }

    public String toFormulaString(Workbook book) {
        return new CellReference(this.getFirstRow(), this.getFirstColumn(), !this.isFirstRowRelative(), !this.isFirstColRelative()).toString() + ":" + new CellReference(this.getLastRow(), this.getLastColumn(), !this.isLastRowRelative(), !this.isLastColRelative()).toString();
    }

    public byte getDefaultOperandClass() {
        return 0;
    }

    public Object clone() {
        AreaPtg ptg = new AreaPtg();
        ptg.field_1_first_row = this.field_1_first_row;
        ptg.field_2_last_row = this.field_2_last_row;
        ptg.field_3_first_column = this.field_3_first_column;
        ptg.field_4_last_column = this.field_4_last_column;
        ptg.setClass(this.ptgClass);
        return ptg;
    }
}

