/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding;

import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Set;
import org.jboss.services.binding.DuplicateServiceException;
import org.jboss.services.binding.ElementServiceBindingValueSource;
import org.jboss.services.binding.InetAddressServiceBindingValueSource;
import org.jboss.services.binding.IntServiceBindingValueSource;
import org.jboss.services.binding.NoSuchBindingException;
import org.jboss.services.binding.ServiceBinding;
import org.jboss.services.binding.ServiceBindingManagerMBean;
import org.jboss.services.binding.ServiceBindingMetadata;
import org.jboss.services.binding.ServiceBindingStore;
import org.jboss.services.binding.ServiceBindingValueSource;
import org.jboss.services.binding.StringServiceBindingValueSource;
import org.jboss.services.binding.URLServiceBindingValueSource;
import org.jboss.services.binding.impl.SimpleServiceBindingValueSourceImpl;
import org.jboss.services.binding.impl.StringReplacementServiceBindingValueSourceImpl;
import org.jboss.services.binding.impl.Util;
import org.jboss.services.binding.impl.XSLTServiceBindingValueSourceConfig;
import org.jboss.services.binding.impl.XSLTServiceBindingValueSourceImpl;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceBindingManager
implements ServiceBindingManagerMBean {
    private String serverName;
    private final ServiceBindingStore store;

    public static ServiceBindingValueSource getServiceBindingValueSource(ServiceBinding binding, BindingType bindingType) {
        ServiceBindingValueSource source = binding.getServiceBindingValueSource();
        if (source == null) {
            switch (bindingType) {
                case INT: 
                case INETADDRESS: {
                    source = new SimpleServiceBindingValueSourceImpl();
                    break;
                }
                case STRING: {
                    source = new StringReplacementServiceBindingValueSourceImpl();
                    break;
                }
                case ELEMENT: 
                case URL: 
                case RESOURCE: {
                    Object config = binding.getServiceBindingValueSourceConfig();
                    if (config instanceof XSLTServiceBindingValueSourceConfig) {
                        source = new XSLTServiceBindingValueSourceImpl();
                        break;
                    }
                    source = new StringReplacementServiceBindingValueSourceImpl();
                    break;
                }
                default: {
                    throw new IllegalStateException("No ServiceBindingValueSource configured for " + binding + " and no default source available for binding of type " + (Object)((Object)bindingType));
                }
            }
        }
        return source;
    }

    public ServiceBindingManager(String serverName, ServiceBindingStore store) {
        if (serverName == null) {
            throw new IllegalArgumentException("serverName is null");
        }
        if (store == null) {
            throw new IllegalArgumentException("store is null");
        }
        this.serverName = serverName;
        this.store = store;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        if (serverName == null) {
            throw new IllegalArgumentException("serverName is null");
        }
        this.serverName = serverName;
    }

    public Set<ServiceBinding> getServiceBindings() {
        return this.store.getServiceBindings(this.serverName);
    }

    public int getIntBinding(String serviceName) throws NoSuchBindingException {
        return this.getIntBinding(serviceName, null);
    }

    public int getIntBinding(String serviceName, String bindingName) throws NoSuchBindingException {
        ServiceBinding binding = this.store.getServiceBinding(this.serverName, serviceName, bindingName);
        ServiceBindingValueSource source = ServiceBindingManager.getServiceBindingValueSource(binding, BindingType.INT);
        if (source instanceof IntServiceBindingValueSource) {
            return ((IntServiceBindingValueSource)source).getIntServiceBindingValue(binding);
        }
        return Util.getBindingValue(source, binding, Number.class).intValue();
    }

    public int getIntBinding(String serviceName, String bindingName, String hostName, int basePort) throws UnknownHostException, DuplicateServiceException {
        return this.getIntBinding(serviceName, bindingName, hostName, basePort, false, hostName != null);
    }

    public int getIntBinding(String serviceName, String bindingName, String hostName, int basePort, boolean fixedPort, boolean fixedHostName) throws UnknownHostException, DuplicateServiceException {
        try {
            return this.getIntBinding(serviceName, bindingName);
        }
        catch (NoSuchBindingException e) {
            this.createBindingFromDefaults(serviceName, bindingName, hostName, basePort, fixedPort, fixedHostName);
            try {
                return this.getIntBinding(serviceName, bindingName);
            }
            catch (NoSuchBindingException e1) {
                throw new IllegalStateException("Newly created binding not found", e1);
            }
        }
    }

    public InetAddress getInetAddressBinding(String serviceName) throws NoSuchBindingException {
        return this.getInetAddressBinding(serviceName, null);
    }

    public InetAddress getInetAddressBinding(String serviceName, String bindingName) throws NoSuchBindingException {
        ServiceBinding binding = this.store.getServiceBinding(this.serverName, serviceName, bindingName);
        ServiceBindingValueSource source = ServiceBindingManager.getServiceBindingValueSource(binding, BindingType.INETADDRESS);
        if (source instanceof InetAddressServiceBindingValueSource) {
            return ((InetAddressServiceBindingValueSource)source).getInetAddressServiceBindingValue(binding);
        }
        return Util.getBindingValue(source, binding, InetAddress.class);
    }

    public InetAddress getInetAddressBinding(String serviceName, String bindingName, String hostName, int basePort) throws UnknownHostException, DuplicateServiceException {
        return this.getInetAddressBinding(serviceName, bindingName, hostName, basePort, false, hostName != null);
    }

    public InetAddress getInetAddressBinding(String serviceName, String bindingName, String hostName, int basePort, boolean fixedPort, boolean fixedHostName) throws UnknownHostException, DuplicateServiceException {
        try {
            return this.getInetAddressBinding(serviceName, bindingName);
        }
        catch (NoSuchBindingException e) {
            this.createBindingFromDefaults(serviceName, bindingName, hostName, basePort, fixedPort, fixedHostName);
            try {
                return this.getInetAddressBinding(serviceName, bindingName);
            }
            catch (NoSuchBindingException e1) {
                throw new IllegalStateException("Newly created binding not found", e1);
            }
        }
    }

    public String getStringBinding(String serviceName) throws NoSuchBindingException {
        return this.getStringBinding(serviceName, null, null);
    }

    public String getStringBinding(String serviceName, String input) throws NoSuchBindingException {
        return this.getStringBinding(serviceName, null, input);
    }

    public String getStringBinding(String serviceName, String bindingName, String input) throws NoSuchBindingException {
        ServiceBinding binding = this.store.getServiceBinding(this.serverName, serviceName, bindingName);
        ServiceBindingValueSource source = ServiceBindingManager.getServiceBindingValueSource(binding, BindingType.STRING);
        if (source instanceof StringServiceBindingValueSource) {
            return ((StringServiceBindingValueSource)source).getStringServiceBindingValue(binding, input);
        }
        return Util.getBindingValueWithInput(source, binding, input, String.class);
    }

    public String getStringBinding(String serviceName, String bindingName, String input, String hostName, int basePort) throws UnknownHostException, DuplicateServiceException {
        return this.getStringBinding(serviceName, bindingName, input, hostName, basePort, false, hostName != null);
    }

    public String getStringBinding(String serviceName, String bindingName, String input, String hostName, int basePort, boolean fixedPort, boolean fixedHostName) throws UnknownHostException, DuplicateServiceException {
        try {
            return this.getStringBinding(serviceName, bindingName, input);
        }
        catch (NoSuchBindingException e) {
            this.createBindingFromDefaults(serviceName, bindingName, hostName, basePort, fixedPort, fixedHostName);
            try {
                return this.getStringBinding(serviceName, bindingName, input);
            }
            catch (NoSuchBindingException e1) {
                throw new IllegalStateException("Newly created binding not found", e1);
            }
        }
    }

    public Element getElementBinding(String serviceName, Element input) throws NoSuchBindingException {
        return this.getElementBinding(serviceName, null, input);
    }

    public Element getElementBinding(String serviceName, String bindingName, Element input) throws NoSuchBindingException {
        ServiceBinding binding = this.store.getServiceBinding(this.serverName, serviceName, bindingName);
        ServiceBindingValueSource source = ServiceBindingManager.getServiceBindingValueSource(binding, BindingType.ELEMENT);
        if (source instanceof ElementServiceBindingValueSource) {
            return ((ElementServiceBindingValueSource)source).getElementServiceBindingValue(binding, input);
        }
        return Util.getBindingValueWithInput(source, binding, input, Element.class);
    }

    public Element getElementBinding(String serviceName, String bindingName, Element input, String hostName, int basePort) throws UnknownHostException, DuplicateServiceException {
        return this.getElementBinding(serviceName, bindingName, input, hostName, basePort, false, hostName != null);
    }

    public Element getElementBinding(String serviceName, String bindingName, Element input, String hostName, int basePort, boolean fixedPort, boolean fixedHostName) throws UnknownHostException, DuplicateServiceException {
        try {
            return this.getElementBinding(serviceName, bindingName, input);
        }
        catch (NoSuchBindingException e) {
            this.createBindingFromDefaults(serviceName, bindingName, hostName, basePort, fixedPort, fixedHostName);
            try {
                return this.getElementBinding(serviceName, bindingName, input);
            }
            catch (NoSuchBindingException e1) {
                throw new IllegalStateException("Newly created binding not found", e1);
            }
        }
    }

    public URL getURLBinding(String serviceName, URL input) throws NoSuchBindingException {
        return this.getURLBinding(serviceName, null, input);
    }

    public URL getURLBinding(String serviceName, String bindingName, URL input) throws NoSuchBindingException {
        ServiceBinding binding = this.store.getServiceBinding(this.serverName, serviceName, bindingName);
        ServiceBindingValueSource source = ServiceBindingManager.getServiceBindingValueSource(binding, BindingType.URL);
        if (source instanceof URLServiceBindingValueSource) {
            return ((URLServiceBindingValueSource)source).getURLServiceBindingValue(binding, input);
        }
        return Util.getBindingValueWithInput(source, binding, input, URL.class);
    }

    public URL getURLBinding(String serviceName, String bindingName, URL input, String hostName, int basePort) throws UnknownHostException, DuplicateServiceException {
        return this.getURLBinding(serviceName, bindingName, input, hostName, basePort, false, hostName != null);
    }

    public URL getURLBinding(String serviceName, String bindingName, URL input, String hostName, int basePort, boolean fixedPort, boolean fixedHostName) throws UnknownHostException, DuplicateServiceException {
        try {
            return this.getURLBinding(serviceName, bindingName, input);
        }
        catch (NoSuchBindingException e) {
            this.createBindingFromDefaults(serviceName, bindingName, hostName, basePort, fixedPort, fixedHostName);
            try {
                return this.getURLBinding(serviceName, bindingName, input);
            }
            catch (NoSuchBindingException e1) {
                throw new IllegalStateException("Newly created binding not found", e1);
            }
        }
    }

    public String getResourceBinding(String serviceName, String input) throws NoSuchBindingException {
        return this.getResourceBinding(serviceName, null, input);
    }

    public String getResourceBinding(String serviceName, String bindingName, String input) throws NoSuchBindingException {
        ServiceBinding binding = this.store.getServiceBinding(this.serverName, serviceName, bindingName);
        ServiceBindingValueSource source = ServiceBindingManager.getServiceBindingValueSource(binding, BindingType.RESOURCE);
        if (source instanceof URLServiceBindingValueSource) {
            return ((URLServiceBindingValueSource)source).getResourceServiceBindingValue(binding, input);
        }
        return Util.getBindingValueWithInput(source, binding, input, String.class);
    }

    public String getResourceBinding(String serviceName, String bindingName, String input, String hostName, int basePort) throws UnknownHostException, DuplicateServiceException {
        return this.getResourceBinding(serviceName, bindingName, input, hostName, basePort, false, hostName != null);
    }

    public String getResourceBinding(String serviceName, String bindingName, String input, String hostName, int basePort, boolean fixedPort, boolean fixedHostName) throws UnknownHostException, DuplicateServiceException {
        try {
            return this.getResourceBinding(serviceName, bindingName, input);
        }
        catch (NoSuchBindingException e) {
            this.createBindingFromDefaults(serviceName, bindingName, hostName, basePort, fixedPort, fixedHostName);
            try {
                return this.getResourceBinding(serviceName, bindingName, input);
            }
            catch (NoSuchBindingException e1) {
                throw new IllegalStateException("Newly created binding not found", e1);
            }
        }
    }

    public Object getGenericBinding(String serviceName, Object ... params) throws NoSuchBindingException {
        return this.getGenericBinding(serviceName, null, params);
    }

    public Object getGenericBinding(String serviceName, String bindingName, Object ... params) throws NoSuchBindingException {
        ServiceBinding binding = this.store.getServiceBinding(this.serverName, serviceName, bindingName);
        ServiceBindingValueSource source = ServiceBindingManager.getServiceBindingValueSource(binding, BindingType.GENERIC);
        return source.getServiceBindingValue(binding, params);
    }

    private void createBindingFromDefaults(String serviceName, String bindingName, String hostName, int basePort, boolean fixedPort, boolean fixedHostName) throws UnknownHostException, DuplicateServiceException {
        ServiceBindingMetadata md = new ServiceBindingMetadata(serviceName, bindingName, hostName, basePort, fixedPort, fixedHostName);
        this.store.addServiceBinding(this.getServerName(), md);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BindingType {
        INT,
        INETADDRESS,
        STRING,
        ELEMENT,
        URL,
        RESOURCE,
        GENERIC;

    }
}

