/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.txtimer;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.TimerService;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.ejb.ContainerMBean;
import org.jboss.ejb.txtimer.DatabasePersistencePlugin;
import org.jboss.ejb.txtimer.DatabasePersistencePluginExt;
import org.jboss.ejb.txtimer.DatabasePersistencePolicyMBean;
import org.jboss.ejb.txtimer.GeneralPurposeDatabasePersistencePlugin;
import org.jboss.ejb.txtimer.TimedObjectId;
import org.jboss.ejb.txtimer.TimerHandleImpl;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.system.ServiceMBeanSupport;

public class DatabasePersistencePolicy
extends ServiceMBeanSupport
implements DatabasePersistencePolicyMBean {
    private static Logger log = Logger.getLogger(DatabasePersistencePolicy.class);
    private DatabasePersistencePlugin dbpPlugin;
    private ObjectName dataSource;
    private String dbpPluginClassName;
    private String timersTable = "TIMERS";
    private List timersToRestore;

    public void startService() throws Exception {
        if (this.dbpPluginClassName != null) {
            Class<?> dbpPolicyClass = Thread.currentThread().getContextClassLoader().loadClass(this.dbpPluginClassName);
            this.dbpPlugin = (DatabasePersistencePlugin)dbpPolicyClass.newInstance();
        } else {
            this.dbpPlugin = new GeneralPurposeDatabasePersistencePlugin();
        }
        if (this.dbpPlugin instanceof DatabasePersistencePluginExt) {
            ((DatabasePersistencePluginExt)this.dbpPlugin).init(this.server, this.dataSource, this.timersTable);
        } else {
            this.dbpPlugin.init(this.server, this.dataSource);
        }
        if (!this.dbpPlugin.getTableName().equals(this.timersTable)) {
            log.warn((Object)("Database persistence plugin '" + this.dbpPluginClassName + "' uses hardcoded timers table name: '" + this.dbpPlugin.getTableName()));
        }
        this.dbpPlugin.createTableIfNotExists();
    }

    public void insertTimer(String timerId, TimedObjectId timedObjectId, Date firstEvent, long intervalDuration, Serializable info) {
        try {
            this.dbpPlugin.insertTimer(timerId, timedObjectId, firstEvent, intervalDuration, info);
        }
        catch (SQLException e) {
            IllegalStateException ex = new IllegalStateException("Unable to persist timer");
            ex.initCause(e);
            throw ex;
        }
    }

    public void deleteTimer(String timerId, TimedObjectId timedObjectId) {
        try {
            this.dbpPlugin.deleteTimer(timerId, timedObjectId);
        }
        catch (SQLException e) {
            log.warn((Object)"Unable to delete timer", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listTimerHandles(ObjectName containerId, ClassLoader loader) {
        ArrayList list = new ArrayList();
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            try {
                if (loader != null) {
                    Thread.currentThread().setContextClassLoader(loader);
                }
                list.addAll(this.dbpPlugin.selectTimers(containerId));
            }
            catch (SQLException e) {
                log.warn((Object)("Unable to get timer handles for containerId: " + containerId), (Throwable)e);
                Object var7_6 = null;
                Thread.currentThread().setContextClassLoader(oldCl);
            }
            Object var7_5 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
            throw throwable;
        }
        return list;
    }

    public List listTimerHandles() {
        ArrayList list = new ArrayList();
        try {
            list.addAll(this.dbpPlugin.selectTimers(null));
        }
        catch (SQLException e) {
            log.warn((Object)"Unable to get timer handles", (Throwable)e);
        }
        return list;
    }

    public void restoreTimers() {
        if (this.timersToRestore != null && this.timersToRestore.size() > 0) {
            log.debug((Object)("Restoring " + this.timersToRestore.size() + " timer(s)"));
            for (int i = 0; i < this.timersToRestore.size(); ++i) {
                TimerHandleImpl handle = (TimerHandleImpl)this.timersToRestore.get(i);
                try {
                    TimedObjectId targetId = handle.getTimedObjectId();
                    ObjectName containerName = targetId.getContainerId();
                    ContainerMBean container = (ContainerMBean)MBeanProxyExt.create(ContainerMBean.class, (ObjectName)containerName, (MBeanServer)this.server);
                    TimerService timerService = container.getTimerService(targetId.getInstancePk());
                    timerService.createTimer(handle.getFirstTime(), handle.getPeriode(), handle.getInfo());
                    continue;
                }
                catch (Exception e) {
                    log.warn((Object)("Unable to restore timer record: " + handle));
                }
            }
            this.timersToRestore.clear();
        }
    }

    public void clearTimers() {
        try {
            this.dbpPlugin.clearTimers();
        }
        catch (SQLException e) {
            log.warn((Object)"Unable to clear timers", (Throwable)e);
        }
    }

    public void resetAndRestoreTimers() throws SQLException {
        this.timersToRestore = this.dbpPlugin.selectTimers(null);
        log.debug((Object)("Found " + this.timersToRestore.size() + " timer(s)"));
        if (this.timersToRestore.size() > 0) {
            this.clearTimers();
        }
        this.restoreTimers();
    }

    public ObjectName getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ObjectName dataSource) {
        this.dataSource = dataSource;
    }

    public String getDatabasePersistencePlugin() {
        return this.dbpPluginClassName;
    }

    public void setDatabasePersistencePlugin(String dbpPluginClass) {
        this.dbpPluginClassName = dbpPluginClass;
    }

    public String getTimersTable() {
        return this.timersTable;
    }

    public void setTimersTable(String timersTable) {
        this.timersTable = timersTable;
    }
}

