/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.javascript;

import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import javax.faces.FacesException;
import org.ajax4jsf.javascript.JSEncoder;
import org.ajax4jsf.javascript.ScriptString;
import org.apache.commons.beanutils.PropertyUtils;

public class ScriptUtils {
    private ScriptUtils() {
    }

    public static String toScript(Object obj) {
        if (null == obj) {
            return "null";
        }
        if (obj instanceof ScriptString) {
            return ((ScriptString)obj).toScript();
        }
        if (obj.getClass().isArray()) {
            StringBuilder ret = new StringBuilder("[");
            boolean first = true;
            for (int i = 0; i < Array.getLength(obj); ++i) {
                Object element = Array.get(obj, i);
                if (!first) {
                    ret.append(',');
                }
                ret.append(ScriptUtils.toScript(element));
                first = false;
            }
            return ret.append("] ").toString();
        }
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            StringBuilder ret = new StringBuilder("[");
            boolean first = true;
            for (Object element : collection) {
                if (!first) {
                    ret.append(',');
                }
                ret.append(ScriptUtils.toScript(element));
                first = false;
            }
            return ret.append("] ").toString();
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            StringBuilder ret = new StringBuilder("{");
            boolean first = true;
            for (Map.Entry entry : map.entrySet()) {
                if (!first) {
                    ret.append(',');
                }
                ScriptUtils.addEncodedString(ret, entry.getKey());
                ret.append(":");
                ret.append(ScriptUtils.toScript(entry.getValue()));
                first = false;
            }
            return ret.append("} ").toString();
        }
        if (obj instanceof Number || obj instanceof Boolean) {
            return obj.toString();
        }
        if (obj instanceof String) {
            StringBuilder ret = new StringBuilder();
            ScriptUtils.addEncodedString(ret, obj);
            return ret.toString();
        }
        if (obj instanceof Enum) {
            StringBuilder ret = new StringBuilder();
            ScriptUtils.addEncodedString(ret, obj);
            return ret.toString();
        }
        try {
            StringBuilder ret = new StringBuilder("{");
            PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)obj);
            boolean first = true;
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
                String key = propertyDescriptor.getName();
                if ("class".equals(key)) continue;
                if (!first) {
                    ret.append(',');
                }
                ScriptUtils.addEncodedString(ret, key);
                ret.append(":");
                ret.append(ScriptUtils.toScript(PropertyUtils.getProperty((Object)obj, (String)key)));
                first = false;
            }
            return ret.append("} ").toString();
        }
        catch (Exception e) {
            throw new FacesException("Error in conversion Java Object to JavaScript", (Throwable)e);
        }
    }

    public static void addEncodedString(StringBuilder buff, Object obj) {
        buff.append("'");
        ScriptUtils.addEncoded(buff, obj);
        buff.append("'");
    }

    public static void addEncoded(StringBuilder buff, Object obj) {
        JSEncoder encoder = new JSEncoder();
        char[] chars = obj.toString().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!encoder.compile(c)) {
                buff.append(encoder.encode(c));
                continue;
            }
            buff.append(c);
        }
    }

    public static String getValidJavascriptName(String s) {
        StringBuffer buf = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            byte[] bytes;
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') {
                if (buf == null) continue;
                buf.append(c);
                continue;
            }
            if (buf == null) {
                buf = new StringBuffer(s.length() + 10);
                buf.append(s.substring(0, i));
            }
            buf.append('_');
            if (c < '\u0010') {
                buf.append('0');
            }
            if (c < '\u0080') {
                buf.append(Integer.toHexString(c).toUpperCase());
                continue;
            }
            try {
                bytes = Character.toString(c).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            for (int j = 0; j < bytes.length; ++j) {
                int intVal = bytes[j];
                if (intVal < 0) {
                    intVal = 256 + intVal;
                } else if (intVal < 16) {
                    buf.append('0');
                }
                buf.append(Integer.toHexString(intVal).toUpperCase());
            }
        }
        return buf == null ? s : buf.toString();
    }
}

